/*
 * Decompiled with CFR 0.152.
 */
package net.phbwt.jtans.calc;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.phbwt.jtans.calc.CalcPiece;
import net.phbwt.jtans.calc.CalcPieceC;
import net.phbwt.jtans.calc.CalcPieceGT;
import net.phbwt.jtans.calc.CalcPieceMT;
import net.phbwt.jtans.calc.CalcPiecePT;
import net.phbwt.jtans.calc.CalcPieceT;
import net.phbwt.jtans.calc.CalcPolyPoints;
import net.phbwt.jtans.calc.CalcPolyTriangles;
import net.phbwt.jtans.calc.StaticCalcOutline;

public class CalcFigure {
    private static final boolean DEBUG = false;
    public static final int COMPARE_ACCURACY_HIGH = 16;
    public static final int COMPARE_ACCURACY_MEDIUM = 17;
    public static final int COMPARE_ACCURACY_LOW = 18;
    private static final int NB_PIECES = 7;
    private static final int NB_TINY = 32;
    private Set pieces;
    public int figureChangeCount;
    public CalcPolyTriangles figureTinyTab;
    private int figureTinyTabLastChange;
    private double tinyXMean;
    private double tinyYMean;
    private List outlinePolygons;
    private int outlinePolygonsLastChange;
    private CalcPolyPoints minMax;
    private int minMaxLastChange;
    private boolean[] libre;

    public CalcFigure() {
        this.initTransient();
        this.pieces = new HashSet(7);
        this.pieces.add(new CalcPieceGT(0.9, 0.9, 0.0, false));
        this.pieces.add(new CalcPieceGT(1.54, 1.84, Math.PI, false));
        this.pieces.add(new CalcPieceMT(3.83, 0.54, 2.356194490192345, false));
        this.pieces.add(new CalcPiecePT(2.78, 2.16, 1.5707963267948966, false));
        this.pieces.add(new CalcPiecePT(4.76, 0.88, Math.PI, false));
        this.pieces.add(new CalcPieceT(3.0, 1.22, 3.9269908169872414, false));
        this.pieces.add(new CalcPieceC(4.2, 2.0, 1.5707963267948966, false));
        Iterator iterator = this.pieces.iterator();
        while (iterator.hasNext()) {
            ((CalcPiece)iterator.next()).setFigure(this);
        }
    }

    private CalcFigure(Set set) {
        this.initTransient();
        this.pieces = set;
        Iterator iterator = this.pieces.iterator();
        while (iterator.hasNext()) {
            ((CalcPiece)iterator.next()).setFigure(this);
        }
    }

    private void initTransient() {
        this.figureTinyTab = new CalcPolyTriangles(32);
        this.figureTinyTabLastChange = -1;
        this.minMax = new CalcPolyPoints(2);
        this.minMaxLastChange = -1;
        this.outlinePolygons = null;
        this.outlinePolygonsLastChange = -1;
        this.libre = new boolean[32];
        this.figureChangeCount = 0;
    }

    public CalcPolyTriangles getFigureTinyTab() {
        if (this.figureTinyTabLastChange != this.figureChangeCount) {
            Object object = this.pieces.iterator();
            while (object.hasNext()) {
                ((CalcPiece)object.next()).putInTinyTab();
            }
            object = this.figureTinyTab.xtriangles;
            double[] dArray = this.figureTinyTab.ytriangles;
            this.tinyYMean = 0.0;
            this.tinyXMean = 0.0;
            for (int i = 31; i >= 0; --i) {
                this.tinyXMean += object[i];
                this.tinyYMean += dArray[i];
            }
            this.tinyXMean /= 32.0;
            this.tinyYMean /= 32.0;
            this.figureTinyTabLastChange = this.figureChangeCount;
        }
        return this.figureTinyTab;
    }

    public CalcPolyPoints getMinMax() {
        if (this.minMaxLastChange != this.figureChangeCount) {
            double d = 1.0E10;
            double d2 = 1.0E10;
            double d3 = -1.0E10;
            double d4 = -1.0E10;
            Iterator iterator = this.pieces.iterator();
            while (iterator.hasNext()) {
                CalcPolyPoints calcPolyPoints = ((CalcPiece)iterator.next()).getPolygon();
                double[] dArray = calcPolyPoints.xpoints;
                double[] dArray2 = calcPolyPoints.ypoints;
                for (int i = 0; i < calcPolyPoints.npoints; ++i) {
                    if (dArray[i] < d) {
                        d = dArray[i];
                    }
                    if (dArray2[i] < d2) {
                        d2 = dArray2[i];
                    }
                    if (dArray[i] > d3) {
                        d3 = dArray[i];
                    }
                    if (!(dArray2[i] > d4)) continue;
                    d4 = dArray2[i];
                }
            }
            this.minMax.xpoints[0] = d;
            this.minMax.xpoints[1] = d3;
            this.minMax.ypoints[0] = d2;
            this.minMax.ypoints[1] = d4;
            this.minMaxLastChange = this.figureChangeCount;
        }
        return this.minMax;
    }

    public Iterator pieceIterator() {
        return this.pieces.iterator();
    }

    public List getOutlinePolygons() {
        if (this.outlinePolygonsLastChange != this.figureChangeCount) {
            this.outlinePolygons = StaticCalcOutline.createOutline(this);
            this.outlinePolygonsLastChange = this.figureChangeCount;
        }
        return this.outlinePolygons;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[");
        Iterator iterator = this.pieces.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((CalcPiece)iterator.next()).toString());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean compare(CalcFigure calcFigure, int n) {
        int n2;
        double d;
        double d2;
        long l = System.currentTimeMillis();
        switch (n) {
            case 16: {
                d2 = 1.0;
                d = 64.0;
                break;
            }
            case 18: {
                d2 = 4.0;
                d = 32.0;
                break;
            }
            default: {
                d2 = 2.0;
                d = 32.0;
            }
        }
        d2 = Math.pow(d2 * 0.1, 2.0);
        d = Math.PI * 2 / d;
        CalcPolyTriangles calcPolyTriangles = this.getFigureTinyTab();
        CalcPolyTriangles calcPolyTriangles2 = calcFigure.getFigureTinyTab();
        double[] dArray = calcPolyTriangles.xtriangles;
        double[] dArray2 = calcPolyTriangles.ytriangles;
        double[] dArray3 = calcPolyTriangles.rtriangles;
        double[] dArray4 = calcPolyTriangles2.xtriangles;
        double[] dArray5 = calcPolyTriangles2.ytriangles;
        double[] dArray6 = calcPolyTriangles2.rtriangles;
        for (n2 = 31; n2 >= 0; --n2) {
            this.libre[n2] = true;
        }
        for (n2 = 31; n2 >= 0; --n2) {
            int n3 = 0;
            double d3 = 100000.0;
            double d4 = dArray[n2] - this.tinyXMean + calcFigure.tinyXMean;
            double d5 = dArray2[n2] - this.tinyYMean + calcFigure.tinyYMean;
            double d6 = dArray3[n2];
            for (int i = 31; i >= 0; --i) {
                if (!this.libre[i]) continue;
                double d7 = Math.pow(d4 - dArray4[i], 2.0) + Math.pow(d5 - dArray5[i], 2.0);
                double d8 = Math.abs(d6 - dArray6[i]);
                if (d8 > Math.PI) {
                    d8 = Math.PI * 2 - d8;
                }
                if (!(d7 < d3) || !(d8 < d)) continue;
                d3 = d7;
                n3 = i;
            }
            this.libre[n3] = false;
            if (!(d3 > d2)) continue;
            return false;
        }
        return true;
    }

    public StoredFigure getStoredFigure() {
        return new StoredFigure(this);
    }

    public static class StoredFigure {
        private CalcPiece.StoredPiece[] pieces;

        public StoredFigure() {
            this(new CalcFigure());
        }

        private StoredFigure(CalcFigure calcFigure) {
            this.pieces = new CalcPiece.StoredPiece[calcFigure.pieces.size()];
            int n = 0;
            Iterator iterator = calcFigure.pieces.iterator();
            while (iterator.hasNext()) {
                this.pieces[n++] = ((CalcPiece)iterator.next()).getStoredPiece();
            }
        }

        public CalcFigure getCalcFigure() {
            HashSet<CalcPiece> hashSet = new HashSet<CalcPiece>(this.pieces.length);
            for (int i = this.pieces.length - 1; i >= 0; --i) {
                hashSet.add(this.pieces[i].getCalcPiece());
            }
            return new CalcFigure(hashSet);
        }

        public StoredFigure(StreamTokenizer streamTokenizer) throws IOException {
            this.pieces = new CalcPiece.StoredPiece[7];
            if (streamTokenizer.nextToken() != -3 || streamTokenizer.nextToken() != -3 || streamTokenizer.nextToken() != -3 || streamTokenizer.nextToken() != 10) {
                throw new RuntimeException("ERROR : bad figure format : line=" + streamTokenizer.lineno());
            }
            for (int i = this.pieces.length - 1; i >= 0; --i) {
                this.pieces[i] = new CalcPiece.StoredPiece(streamTokenizer);
            }
            if (streamTokenizer.nextToken() != 10 && streamTokenizer.ttype != -1) {
                throw new RuntimeException("bad end of figure : missing empty line : line=" + streamTokenizer.lineno());
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(512);
            stringBuffer.append("1.0 1.0 1024\n");
            for (int i = this.pieces.length - 1; i >= 0; --i) {
                stringBuffer.append(this.pieces[i].toString());
            }
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }
}

