/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.rosetta.ui;

import com.artenum.rosetta.core.ConsoleTextPaneWriter;
import com.artenum.rosetta.interfaces.ui.OutputView;
import java.io.Writer;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;

public class ConsoleTextPane
extends JTextPane
implements OutputView {
    private static final long serialVersionUID = 1L;
    private String currentStyleName = "default";

    public ConsoleTextPane() {
        this.setAutoscrolls(true);
        this.setDragEnabled(true);
    }

    public void append(String content) {
        this.append(content, this.currentStyleName);
    }

    public void setStyleName(String styleName) {
        this.currentStyleName = styleName;
    }

    public void append(String content, String styleName) {
        try {
            this.getStyledDocument().insertString(this.getCaretPosition(), content, this.getStyle(styleName));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void reset() {
        try {
            this.getStyledDocument().remove(0, this.getStyledDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.setCaretPosition(0);
    }

    public Writer getErrorWriter() {
        return new ConsoleTextPaneWriter(this, "default");
    }

    public Writer getWriter() {
        return new ConsoleTextPaneWriter(this, "default");
    }

    public void setCaretPositionToBeginning() {
        this.setCaretPosition(0);
    }

    public void setCaretPositionToEnd() {
        this.setCaretPosition(this.getStyledDocument().getLength());
    }

    public void backspace() {
        try {
            this.getStyledDocument().remove(this.getCaretPosition() - 1, 1);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

