/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jrobin.core.ArcDef;
import org.jrobin.core.DsDef;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdToolkit;
import org.jrobin.inspector.EditArchiveDialog;
import org.jrobin.inspector.EditDatasourceDialog;
import org.jrobin.inspector.GraphFrame;
import org.jrobin.inspector.InspectorModel;
import org.jrobin.inspector.RrdNode;
import org.jrobin.inspector.Util;

public class RrdInspector
extends JFrame {
    private static final long serialVersionUID = 1L;
    static final boolean SHOULD_CREATE_BACKUPS = true;
    static final String TITLE = "RRD File Inspector";
    static final boolean SHOULD_FIX_ARCHIVED_VALUES = false;
    static final Dimension MAIN_TREE_SIZE = new Dimension(250, 400);
    static final Dimension INFO_PANE_SIZE = new Dimension(450, 400);
    static final String ABOUT = "JRobinLite project\nRrdInspector utility\nCopyright (C) 2003-2005 Sasa Markovic. All rights reserved.";
    JTabbedPane tabbedPane = new JTabbedPane();
    private JTree mainTree = new JTree();
    private JTable generalTable = new JTable();
    private JTable datasourceTable = new JTable();
    private JTable archiveTable = new JTable();
    private JTable dataTable = new JTable();
    private InspectorModel inspectorModel = new InspectorModel();
    private String lastDirectory = null;

    private RrdInspector(String path) {
        super(TITLE);
        this.constructUI();
        this.pack();
        Util.placeWindow(this);
        this.setVisible(true);
        if (path == null) {
            this.selectFile();
        } else {
            this.loadFile(new File(path));
        }
    }

    private void constructUI() {
        JPanel content = (JPanel)this.getContentPane();
        content.setLayout(new BorderLayout());
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        JScrollPane treePane = new JScrollPane(this.mainTree);
        leftPanel.add(treePane);
        leftPanel.setPreferredSize(MAIN_TREE_SIZE);
        content.add((Component)leftPanel, "West");
        this.mainTree.getSelectionModel().setSelectionMode(1);
        this.mainTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                RrdInspector.this.nodeChangedAction();
            }
        });
        this.mainTree.setModel(this.inspectorModel.getMainTreeModel());
        JScrollPane spGeneral = new JScrollPane(this.generalTable);
        spGeneral.setPreferredSize(INFO_PANE_SIZE);
        this.tabbedPane.add("General info", spGeneral);
        this.generalTable.setModel(this.inspectorModel.getGeneralTableModel());
        this.generalTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.generalTable.getColumnModel().getColumn(0).setMaxWidth(150);
        JScrollPane spDatasource = new JScrollPane(this.datasourceTable);
        spDatasource.setPreferredSize(INFO_PANE_SIZE);
        this.tabbedPane.add("Datasource info", spDatasource);
        this.datasourceTable.setModel(this.inspectorModel.getDatasourceTableModel());
        this.datasourceTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.datasourceTable.getColumnModel().getColumn(0).setMaxWidth(150);
        JScrollPane spArchive = new JScrollPane(this.archiveTable);
        this.archiveTable.setModel(this.inspectorModel.getArchiveTableModel());
        this.archiveTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.archiveTable.getColumnModel().getColumn(0).setMaxWidth(150);
        spArchive.setPreferredSize(INFO_PANE_SIZE);
        this.tabbedPane.add("Archive info", spArchive);
        JScrollPane spData = new JScrollPane(this.dataTable);
        this.dataTable.setModel(this.inspectorModel.getDataTableModel());
        this.dataTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.dataTable.getColumnModel().getColumn(0).setMaxWidth(100);
        this.dataTable.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.dataTable.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;
            {
                this.setBackground(Color.YELLOW);
            }
        });
        spData.setPreferredSize(INFO_PANE_SIZE);
        this.tabbedPane.add("Archive data", spData);
        content.add((Component)this.tabbedPane, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        JMenuItem fileMenuItem = new JMenuItem("Open RRD file...", 79);
        fileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RrdInspector.this.selectFile();
            }
        });
        fileMenu.add(fileMenuItem);
        JMenuItem fileMenuItem2 = new JMenuItem("Open RRD file in new window...");
        fileMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new RrdInspector(null);
            }
        });
        fileMenu.add(fileMenuItem2);
        fileMenu.addSeparator();
        JMenuItem addDatasourceMenuItem = new JMenuItem("Add datasource...");
        addDatasourceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RrdInspector.this.addDatasource();
            }
        });
        fileMenu.add(addDatasourceMenuItem);
        JMenuItem editDatasourceMenuItem = new JMenuItem("Edit datasource...");
        editDatasourceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RrdInspector.this.editDatasource();
            }
        });
        fileMenu.add(editDatasourceMenuItem);
        JMenuItem removeDatasourceMenuItem = new JMenuItem("Remove datasource");
        removeDatasourceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RrdInspector.this.removeDatasource();
            }
        });
        fileMenu.add(removeDatasourceMenuItem);
        fileMenu.addSeparator();
        JMenuItem addArchiveMenuItem = new JMenuItem("Add archive...");
        addArchiveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RrdInspector.this.addArchive();
            }
        });
        fileMenu.add(addArchiveMenuItem);
        JMenuItem editArchiveMenuItem = new JMenuItem("Edit archive...");
        editArchiveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RrdInspector.this.editArchive();
            }
        });
        fileMenu.add(editArchiveMenuItem);
        JMenuItem removeArchiveMenuItem = new JMenuItem("Remove archive...");
        removeArchiveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RrdInspector.this.removeArchive();
            }
        });
        fileMenu.add(removeArchiveMenuItem);
        JMenuItem plotArchiveMenuItem = new JMenuItem("Plot archive values...");
        plotArchiveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RrdInspector.this.plotArchive();
            }
        });
        fileMenu.add(plotArchiveMenuItem);
        fileMenu.addSeparator();
        JMenuItem exitMenuItem = new JMenuItem("Exit", 88);
        exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        fileMenu.add(exitMenuItem);
        JMenu helpMenu = new JMenu("Help");
        fileMenu.setMnemonic(72);
        JMenuItem aboutMenuItem = new JMenuItem("About...");
        aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RrdInspector.this.about();
            }
        });
        helpMenu.add(aboutMenuItem);
        menuBar.add(fileMenu);
        menuBar.add(helpMenu);
        this.setJMenuBar(menuBar);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                RrdInspector.this.closeWindow();
            }
        });
    }

    private void closeWindow() {
        Util.dismissWindow(this);
    }

    private void about() {
        JOptionPane.showMessageDialog(this, ABOUT, "About", 1);
    }

    private void nodeChangedAction() {
        RrdNode rrdNode = this.getSelectedRrdNode();
        if (rrdNode != null) {
            this.inspectorModel.selectModel(rrdNode.getDsIndex(), rrdNode.getArcIndex());
            if (rrdNode.getDsIndex() >= 0 && rrdNode.getArcIndex() >= 0) {
                if (this.tabbedPane.getSelectedIndex() < 2) {
                    this.tabbedPane.setSelectedIndex(2);
                }
            } else if (rrdNode.getDsIndex() >= 0) {
                this.tabbedPane.setSelectedIndex(1);
            } else {
                this.tabbedPane.setSelectedIndex(0);
            }
        }
    }

    private RrdNode getSelectedRrdNode() {
        DefaultMutableTreeNode node;
        Object obj;
        TreePath path = this.mainTree.getSelectionPath();
        if (path != null && (obj = (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof RrdNode) {
            return (RrdNode)obj;
        }
        return null;
    }

    private void selectFile() {
        File file;
        JFileChooser chooser = new JFileChooser(this.lastDirectory);
        FileFilter filter = new FileFilter(){

            public boolean accept(File file) {
                String path = file.getAbsolutePath().toLowerCase();
                return file.isDirectory() || path.endsWith(".rrd") || path.endsWith(".jrb") || path.endsWith(".jrobin");
            }

            public String getDescription() {
                return "JRobin RRD files (*.rrd;*.jrb;*.jrobin)";
            }
        };
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0 && (file = chooser.getSelectedFile()) != null) {
            this.lastDirectory = file.getParent();
            this.loadFile(file);
        }
    }

    private void loadFile(File file) {
        this.inspectorModel.setFile(file);
        this.tabbedPane.setSelectedIndex(0);
    }

    private void addDatasource() {
        if (!this.inspectorModel.isOk()) {
            Util.error((Component)this, "Open a valid RRD file first.");
            return;
        }
        DsDef newDsDef = new EditDatasourceDialog((Frame)this, null).getDsDef();
        if (newDsDef != null) {
            try {
                String sourcePath = this.inspectorModel.getFile().getCanonicalPath();
                RrdToolkit.addDatasource(sourcePath, newDsDef, true);
                this.inspectorModel.refresh();
                this.tabbedPane.setSelectedIndex(0);
            }
            catch (IOException e) {
                Util.error((Component)this, e);
            }
            catch (RrdException e) {
                Util.error((Component)this, e);
            }
        }
    }

    private void addArchive() {
        if (!this.inspectorModel.isOk()) {
            Util.error((Component)this, "Open a valid RRD file first.");
            return;
        }
        ArcDef newArcDef = new EditArchiveDialog((Frame)this, null).getArcDef();
        if (newArcDef != null) {
            try {
                String sourcePath = this.inspectorModel.getFile().getCanonicalPath();
                RrdToolkit.addArchive(sourcePath, newArcDef, true);
                this.inspectorModel.refresh();
                this.tabbedPane.setSelectedIndex(0);
            }
            catch (IOException e) {
                Util.error((Component)this, e);
            }
            catch (RrdException e) {
                Util.error((Component)this, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editDatasource() {
        int dsIndex;
        if (!this.inspectorModel.isOk()) {
            Util.error((Component)this, "Open a valid RRD file first.");
            return;
        }
        RrdNode rrdNode = this.getSelectedRrdNode();
        if (rrdNode == null || (dsIndex = rrdNode.getDsIndex()) < 0) {
            Util.error((Component)this, "Select datasource first");
            return;
        }
        try {
            String sourcePath = this.inspectorModel.getFile().getCanonicalPath();
            RrdDb rrd = new RrdDb(sourcePath, true);
            try {
                DsDef dsDef = rrd.getRrdDef().getDsDefs()[dsIndex];
                rrd.close();
                DsDef newDsDef = new EditDatasourceDialog((Frame)this, dsDef).getDsDef();
                if (newDsDef != null) {
                    RrdToolkit.setDsHeartbeat(sourcePath, newDsDef.getDsName(), newDsDef.getHeartbeat());
                    RrdToolkit.setDsMinMaxValue(sourcePath, newDsDef.getDsName(), newDsDef.getMinValue(), newDsDef.getMaxValue(), false);
                    this.inspectorModel.refresh();
                    this.tabbedPane.setSelectedIndex(0);
                }
            }
            finally {
                rrd.close();
            }
        }
        catch (IOException e) {
            Util.error((Component)this, e);
        }
        catch (RrdException e) {
            Util.error((Component)this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editArchive() {
        int arcIndex;
        if (!this.inspectorModel.isOk()) {
            Util.error((Component)this, "Open a valid RRD file first.");
            return;
        }
        RrdNode rrdNode = this.getSelectedRrdNode();
        if (rrdNode == null || (arcIndex = rrdNode.getArcIndex()) < 0) {
            Util.error((Component)this, "Select archive first");
            return;
        }
        try {
            String sourcePath = this.inspectorModel.getFile().getCanonicalPath();
            RrdDb rrd = new RrdDb(sourcePath, true);
            try {
                ArcDef arcDef = rrd.getRrdDef().getArcDefs()[arcIndex];
                rrd.close();
                ArcDef newArcDef = new EditArchiveDialog((Frame)this, arcDef).getArcDef();
                if (newArcDef != null) {
                    RrdToolkit.setArcXff(sourcePath, newArcDef.getConsolFun(), newArcDef.getSteps(), newArcDef.getXff());
                    RrdToolkit.resizeArchive(sourcePath, newArcDef.getConsolFun(), newArcDef.getSteps(), newArcDef.getRows(), true);
                    this.inspectorModel.refresh();
                    this.tabbedPane.setSelectedIndex(0);
                }
            }
            finally {
                rrd.close();
            }
        }
        catch (IOException e) {
            Util.error((Component)this, e);
        }
        catch (RrdException e) {
            Util.error((Component)this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDatasource() {
        int dsIndex;
        if (!this.inspectorModel.isOk()) {
            Util.error((Component)this, "Open a valid RRD file first.");
            return;
        }
        RrdNode rrdNode = this.getSelectedRrdNode();
        if (rrdNode == null || (dsIndex = rrdNode.getDsIndex()) < 0) {
            Util.error((Component)this, "Select datasource first");
            return;
        }
        try {
            String dsName;
            String sourcePath = this.inspectorModel.getFile().getCanonicalPath();
            RrdDb rrd = new RrdDb(sourcePath, true);
            try {
                dsName = rrd.getRrdDef().getDsDefs()[dsIndex].getDsName();
            }
            finally {
                rrd.close();
            }
            RrdToolkit.removeDatasource(sourcePath, dsName, true);
            this.inspectorModel.refresh();
            this.tabbedPane.setSelectedIndex(0);
        }
        catch (IOException e) {
            Util.error((Component)this, e);
        }
        catch (RrdException e) {
            Util.error((Component)this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeArchive() {
        int arcIndex;
        if (!this.inspectorModel.isOk()) {
            Util.error((Component)this, "Open a valid RRD file first.");
            return;
        }
        RrdNode rrdNode = this.getSelectedRrdNode();
        if (rrdNode == null || (arcIndex = rrdNode.getArcIndex()) < 0) {
            Util.error((Component)this, "Select archive first");
            return;
        }
        try {
            int steps;
            String consolFun;
            String sourcePath = this.inspectorModel.getFile().getCanonicalPath();
            RrdDb rrd = new RrdDb(sourcePath, true);
            try {
                ArcDef arcDef = rrd.getRrdDef().getArcDefs()[arcIndex];
                consolFun = arcDef.getConsolFun();
                steps = arcDef.getSteps();
            }
            finally {
                rrd.close();
            }
            RrdToolkit.removeArchive(sourcePath, consolFun, steps, true);
            this.inspectorModel.refresh();
            this.tabbedPane.setSelectedIndex(0);
        }
        catch (IOException e) {
            Util.error((Component)this, e);
        }
        catch (RrdException e) {
            Util.error((Component)this, e);
        }
    }

    private void plotArchive() {
        int arcIndex;
        if (!this.inspectorModel.isOk()) {
            Util.error((Component)this, "Open a valid RRD file first.");
            return;
        }
        RrdNode rrdNode = this.getSelectedRrdNode();
        if (rrdNode == null || (arcIndex = rrdNode.getArcIndex()) < 0) {
            Util.error((Component)this, "Select archive first");
            return;
        }
        String sourcePath = this.inspectorModel.getFile().getAbsolutePath();
        int dsIndex = rrdNode.getDsIndex();
        new GraphFrame(sourcePath, dsIndex, arcIndex);
    }

    private static void printUsageAndExit() {
        System.err.println("usage: " + RrdInspector.class.getName() + " [<filename>]");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length > 1) {
            RrdInspector.printUsageAndExit();
        }
        String path = args.length == 1 ? args[0] : null;
        new RrdInspector(path);
    }
}

