/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jrobin.core.ConsolFuns;
import org.jrobin.core.FetchData;
import org.jrobin.core.FetchRequest;
import org.jrobin.core.RrdBackendFactory;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDbPool;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.data.Aggregates;
import org.jrobin.data.CDef;
import org.jrobin.data.Def;
import org.jrobin.data.Normalizer;
import org.jrobin.data.PDef;
import org.jrobin.data.PercentileDef;
import org.jrobin.data.Plottable;
import org.jrobin.data.RpnCalculator;
import org.jrobin.data.SDef;
import org.jrobin.data.Source;

public class DataProcessor
implements ConsolFuns {
    public static final int DEFAULT_PIXEL_COUNT = 600;
    private static final double DEFAULT_PERCENTILE = 95.0;
    private int pixelCount = 600;
    public static final boolean DEFAULT_POOL_USAGE_POLICY = false;
    private boolean poolUsed = false;
    private final long tStart;
    private long tEnd;
    private long[] timestamps;
    private long lastRrdArchiveUpdateTime = 0L;
    private long step = 0L;
    private long fetchRequestResolution = 1L;
    private Map<String, Source> sources = new LinkedHashMap<String, Source>();
    private Def[] defSources;

    public DataProcessor(long t1, long t2) throws RrdException {
        if (!(t1 < t2 && t1 > 0L && t2 > 0L || t1 > 0L && t2 == 0L)) {
            throw new RrdException("Invalid timestamps specified: " + t1 + ", " + t2);
        }
        this.tStart = t1;
        this.tEnd = t2;
    }

    public DataProcessor(Date d1, Date d2) throws RrdException {
        this(Util.getTimestamp(d1), d2 != null ? Util.getTimestamp(d2) : 0L);
    }

    public DataProcessor(Calendar gc1, Calendar gc2) throws RrdException {
        this(Util.getTimestamp(gc1), gc2 != null ? Util.getTimestamp(gc2) : 0L);
    }

    public boolean isPoolUsed() {
        return this.poolUsed;
    }

    public void setPoolUsed(boolean poolUsed) {
        this.poolUsed = poolUsed;
    }

    public void setPixelCount(int pixelCount) {
        this.pixelCount = pixelCount;
    }

    public int getPixelCount() {
        return this.pixelCount;
    }

    public void setStep(long step) {
        this.step = step;
    }

    public long getStep() {
        return this.step;
    }

    public long getFetchRequestResolution() {
        return this.fetchRequestResolution;
    }

    public void setFetchRequestResolution(long fetchRequestResolution) {
        this.fetchRequestResolution = fetchRequestResolution;
    }

    public long getEndingTimestamp() {
        return this.tEnd;
    }

    public long[] getTimestamps() throws RrdException {
        if (this.timestamps == null) {
            throw new RrdException("Timestamps not calculated yet");
        }
        return this.timestamps;
    }

    public double[] getValues(String sourceName) throws RrdException {
        Source source = this.getSource(sourceName);
        double[] values = source.getValues();
        if (values == null) {
            throw new RrdException("Values not available for source [" + sourceName + "]");
        }
        return values;
    }

    public double getAggregate(String sourceName, String consolFun) throws RrdException {
        Source source = this.getSource(sourceName);
        return source.getAggregates(this.tStart, this.tEnd).getAggregate(consolFun);
    }

    public Aggregates getAggregates(String sourceName) throws RrdException {
        Source source = this.getSource(sourceName);
        return source.getAggregates(this.tStart, this.tEnd);
    }

    public double get95Percentile(String sourceName) throws RrdException {
        return this.getPercentile(sourceName);
    }

    public double getPercentile(String sourceName) throws RrdException {
        return this.getPercentile(sourceName, 95.0);
    }

    public double getPercentile(String sourceName, double percentile) throws RrdException {
        if (percentile <= 0.0 || percentile > 100.0) {
            throw new RrdException("Invalid percentile [" + percentile + "], should be between 0 and 100");
        }
        Source source = this.getSource(sourceName);
        return source.getPercentile(this.tStart, this.tEnd, percentile);
    }

    public String[] getSourceNames() {
        return this.sources.keySet().toArray(new String[0]);
    }

    public double[][] getValues() throws RrdException {
        String[] names = this.getSourceNames();
        double[][] values = new double[names.length][];
        for (int i = 0; i < names.length; ++i) {
            values[i] = this.getValues(names[i]);
        }
        return values;
    }

    private Source getSource(String sourceName) throws RrdException {
        Source source = this.sources.get(sourceName);
        if (source != null) {
            return source;
        }
        throw new RrdException("Unknown source: " + sourceName);
    }

    public void addDatasource(String name, Plottable plottable) {
        PDef pDef = new PDef(name, plottable);
        this.sources.put(name, pDef);
    }

    public void addDatasource(String name, String rpnExpression) {
        CDef cDef = new CDef(name, rpnExpression);
        this.sources.put(name, cDef);
    }

    public void addDatasource(String name, String defName, String consolFun) {
        SDef sDef = new SDef(name, defName, consolFun);
        this.sources.put(name, sDef);
    }

    public void addDatasource(String name, String file, String dsName, String consolFunc) {
        Def def = new Def(name, file, dsName, consolFunc);
        this.sources.put(name, def);
    }

    public void addDatasource(String name, String file, String dsName, String consolFunc, String backend) {
        Def def = new Def(name, file, dsName, consolFunc, backend);
        this.sources.put(name, def);
    }

    public void addDatasource(String name, FetchData fetchData) {
        Def def = new Def(name, fetchData);
        this.sources.put(name, def);
    }

    public void addDatasource(String name, String sourceName, double percentile) {
        Source source = this.sources.get(sourceName);
        this.sources.put(name, new PercentileDef(name, source, percentile));
    }

    public void processData() throws IOException, RrdException {
        this.extractDefs();
        this.fetchRrdData();
        this.fixZeroEndingTimestamp();
        this.chooseOptimalStep();
        this.createTimestamps();
        this.assignTimestampsToSources();
        this.normalizeRrdValues();
        this.calculateNonRrdSources();
    }

    public double[] getValuesPerPixel(String sourceName, int pixelCount) throws RrdException {
        this.setPixelCount(pixelCount);
        return this.getValuesPerPixel(sourceName);
    }

    public double[] getValuesPerPixel(String sourceName) throws RrdException {
        double[] values = this.getValues(sourceName);
        double[] pixelValues = new double[this.pixelCount];
        Arrays.fill(pixelValues, Double.NaN);
        long span = this.tEnd - this.tStart;
        int ref = 0;
        block0: for (int pix = 0; pix < this.pixelCount; ++pix) {
            double t = (double)this.tStart + (double)(span * (long)pix) / (double)(this.pixelCount - 1);
            while (ref < this.timestamps.length && !(t <= (double)(this.timestamps[ref] - this.step))) {
                if (t <= (double)this.timestamps[ref]) {
                    pixelValues[pix] = values[ref];
                    continue block0;
                }
                ++ref;
            }
        }
        return pixelValues;
    }

    public long[] getTimestampsPerPixel(int pixelCount) {
        this.setPixelCount(pixelCount);
        return this.getTimestampsPerPixel();
    }

    public long[] getTimestampsPerPixel() {
        long[] times = new long[this.pixelCount];
        long span = this.tEnd - this.tStart;
        for (int i = 0; i < this.pixelCount; ++i) {
            times[i] = Math.round((double)this.tStart + (double)(span * (long)i) / (double)(this.pixelCount - 1));
        }
        return times;
    }

    public String dump() throws RrdException {
        String[] names = this.getSourceNames();
        double[][] values = this.getValues();
        StringBuffer buffer = new StringBuffer();
        buffer.append(DataProcessor.format("timestamp", 12));
        for (String name : names) {
            buffer.append(DataProcessor.format(name, 20));
        }
        buffer.append("\n");
        for (int i = 0; i < this.timestamps.length; ++i) {
            buffer.append(DataProcessor.format("" + this.timestamps[i], 12));
            for (int j = 0; j < names.length; ++j) {
                buffer.append(DataProcessor.format(Util.formatDouble(values[j][i]), 20));
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public long getLastRrdArchiveUpdateTime() {
        return this.lastRrdArchiveUpdateTime;
    }

    private void extractDefs() {
        ArrayList<Def> defList = new ArrayList<Def>();
        for (Source source : this.sources.values()) {
            if (!(source instanceof Def)) continue;
            defList.add((Def)source);
        }
        this.defSources = defList.toArray(new Def[defList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchRrdData() throws IOException, RrdException {
        long tEndFixed = this.tEnd == 0L ? Util.getTime() : this.tEnd;
        for (int i = 0; i < this.defSources.length; ++i) {
            if (this.defSources[i].isLoaded()) continue;
            HashSet<String> dsNames = new HashSet<String>();
            dsNames.add(this.defSources[i].getDsName());
            for (int j = i + 1; j < this.defSources.length; ++j) {
                if (!this.defSources[i].isCompatibleWith(this.defSources[j])) continue;
                dsNames.add(this.defSources[j].getDsName());
            }
            RrdDb rrd = null;
            try {
                rrd = this.getRrd(this.defSources[i]);
                this.lastRrdArchiveUpdateTime = Math.max(this.lastRrdArchiveUpdateTime, rrd.getLastArchiveUpdateTime());
                FetchRequest req = rrd.createFetchRequest(this.defSources[i].getConsolFun(), this.tStart, tEndFixed, this.fetchRequestResolution);
                req.setFilter(dsNames);
                FetchData data = req.fetchData();
                this.defSources[i].setFetchData(data);
                for (int j = i + 1; j < this.defSources.length; ++j) {
                    if (!this.defSources[i].isCompatibleWith(this.defSources[j])) continue;
                    this.defSources[j].setFetchData(data);
                }
                continue;
            }
            finally {
                if (rrd != null) {
                    this.releaseRrd(rrd, this.defSources[i]);
                }
            }
        }
    }

    private void fixZeroEndingTimestamp() throws RrdException {
        if (this.tEnd == 0L) {
            if (this.defSources.length == 0) {
                throw new RrdException("Could not adjust zero ending timestamp, no DEF source provided");
            }
            this.tEnd = this.defSources[0].getArchiveEndTime();
            for (int i = 1; i < this.defSources.length; ++i) {
                this.tEnd = Math.min(this.tEnd, this.defSources[i].getArchiveEndTime());
            }
            if (this.tEnd <= this.tStart) {
                throw new RrdException("Could not resolve zero ending timestamp.");
            }
        }
    }

    private void chooseOptimalStep() {
        long newStep = Long.MAX_VALUE;
        for (Def defSource : this.defSources) {
            long fetchStep;
            long tryStep = fetchStep = defSource.getFetchStep();
            if (this.step > 0L) {
                tryStep = Math.min(newStep, ((this.step - 1L) / fetchStep + 1L) * fetchStep);
            }
            newStep = Math.min(newStep, tryStep);
        }
        this.step = newStep != Long.MAX_VALUE ? newStep : Math.max((this.tEnd - this.tStart) / (long)this.pixelCount, 1L);
    }

    private void createTimestamps() {
        long t1 = Util.normalize(this.tStart, this.step);
        long t2 = Util.normalize(this.tEnd, this.step);
        if (t2 < this.tEnd) {
            t2 += this.step;
        }
        int count = (int)((t2 - t1) / this.step + 1L);
        this.timestamps = new long[count];
        for (int i = 0; i < count; ++i) {
            this.timestamps[i] = t1;
            t1 += this.step;
        }
    }

    private void assignTimestampsToSources() {
        for (Source src : this.sources.values()) {
            src.setTimestamps(this.timestamps);
        }
    }

    private void normalizeRrdValues() throws RrdException {
        Normalizer normalizer = new Normalizer(this.timestamps);
        for (Def def : this.defSources) {
            long[] rrdTimestamps = def.getRrdTimestamps();
            double[] rrdValues = def.getRrdValues();
            double[] values = normalizer.normalize(rrdTimestamps, rrdValues);
            def.setValues(values);
        }
    }

    private void calculateNonRrdSources() throws RrdException {
        for (Source source : this.sources.values()) {
            if (source instanceof SDef) {
                this.calculateSDef((SDef)source);
                continue;
            }
            if (source instanceof CDef) {
                this.calculateCDef((CDef)source);
                continue;
            }
            if (source instanceof PDef) {
                this.calculatePDef((PDef)source);
                continue;
            }
            if (!(source instanceof PercentileDef)) continue;
            this.calculatePercentileDef((PercentileDef)source);
        }
    }

    private void calculatePDef(PDef pdef) {
        pdef.calculateValues();
    }

    private void calculateCDef(CDef cDef) throws RrdException {
        RpnCalculator calc = new RpnCalculator(cDef.getRpnExpression(), cDef.getName(), this);
        cDef.setValues(calc.calculateValues());
    }

    private void calculateSDef(SDef sDef) throws RrdException {
        String defName = sDef.getDefName();
        String consolFun = sDef.getConsolFun();
        Source source = this.getSource(defName);
        double value = source.getAggregates(this.tStart, this.tEnd).getAggregate(consolFun);
        sDef.setValue(value);
    }

    private void calculatePercentileDef(PercentileDef def) throws RrdException {
        def.calculate(this.tStart, this.tEnd);
    }

    private RrdDb getRrd(Def def) throws IOException, RrdException {
        String path = def.getPath();
        String backend = def.getBackend();
        if (this.poolUsed && backend == null) {
            return RrdDbPool.getInstance().requestRrdDb(path);
        }
        if (backend != null) {
            return new RrdDb(path, true, RrdBackendFactory.getFactory(backend));
        }
        return new RrdDb(path, true);
    }

    private void releaseRrd(RrdDb rrd, Def def) throws IOException, RrdException {
        String backend = def.getBackend();
        if (this.poolUsed && backend == null) {
            RrdDbPool.getInstance().release(rrd);
        } else {
            rrd.close();
        }
    }

    private static String format(String s, int length) {
        StringBuffer b = new StringBuffer(s);
        for (int i = 0; i < length - s.length(); ++i) {
            b.append(' ');
        }
        return b.toString();
    }

    public static void main(String[] args) throws IOException, RrdException {
        long t1 = Util.getTimestamp(2003, 4, 1);
        long t2 = Util.getTimestamp(2003, 5, 1);
        System.out.println("t1 = " + t1);
        System.out.println("t2 = " + t2);
        String rrdPath = Util.getJRobinDemoPath("demo.rrd");
        DataProcessor dp = new DataProcessor(t1, t2);
        dp.addDatasource("X", rrdPath, "sun", "AVERAGE");
        dp.addDatasource("Y", rrdPath, "shade", "AVERAGE");
        dp.addDatasource("Z", "X,Y,+,2,/");
        dp.addDatasource("DERIVE[Z]", "Z,PREV(Z),-,STEP,/");
        dp.addDatasource("TREND[Z]", "DERIVE[Z],SIGN");
        dp.addDatasource("AVG[Z]", "Z", "AVERAGE");
        dp.addDatasource("DELTA", "Z,AVG[Z],-");
        long laptime = System.currentTimeMillis();
        dp.processData();
        System.out.println("Data processed in " + (System.currentTimeMillis() - laptime) + " milliseconds\n---");
        System.out.println(dp.dump());
        System.out.println("\nAggregates for X");
        Aggregates agg = dp.getAggregates("X");
        System.out.println(agg.dump());
        System.out.println("\nAggregates for Y");
        agg = dp.getAggregates("Y");
        System.out.println(agg.dump());
        System.out.println("\n95-percentile for X: " + Util.formatDouble(dp.get95Percentile("X")));
        System.out.println("95-percentile for Y: " + Util.formatDouble(dp.get95Percentile("Y")));
        System.out.println("\nLast archive update time was: " + dp.getLastRrdArchiveUpdateTime());
    }
}

