/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.jrobin.core.ArcDef;
import org.jrobin.core.Archive;
import org.jrobin.core.DataImporter;
import org.jrobin.core.Datasource;
import org.jrobin.core.DsDef;
import org.jrobin.core.FetchData;
import org.jrobin.core.FetchRequest;
import org.jrobin.core.Header;
import org.jrobin.core.RrdAllocator;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.RrdBackendFactory;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdFileBackend;
import org.jrobin.core.RrdFileBackendFactory;
import org.jrobin.core.RrdToolReader;
import org.jrobin.core.RrdUpdater;
import org.jrobin.core.Sample;
import org.jrobin.core.Util;
import org.jrobin.core.XmlReader;
import org.jrobin.core.XmlWriter;

public class RrdDb
implements RrdUpdater {
    public static final String PREFIX_XML = "xml:/";
    public static final String PREFIX_RRDTool = "rrdtool:/";
    static final int XML_INITIAL_BUFFER_CAPACITY = 100000;
    private RrdBackend backend;
    private RrdAllocator allocator = new RrdAllocator();
    private Header header;
    private Datasource[] datasources;
    private Archive[] archives;
    private boolean closed = false;

    public RrdDb(RrdDef rrdDef) throws RrdException, IOException {
        this(rrdDef, RrdFileBackendFactory.getDefaultFactory());
    }

    public RrdDb(RrdDef rrdDef, RrdBackendFactory factory) throws RrdException, IOException {
        rrdDef.validate();
        String path = rrdDef.getPath();
        this.backend = factory.open(path, false);
        try {
            this.backend.setLength(rrdDef.getEstimatedSize());
            this.header = new Header(this, rrdDef);
            DsDef[] dsDefs = rrdDef.getDsDefs();
            this.datasources = new Datasource[dsDefs.length];
            for (int i = 0; i < dsDefs.length; ++i) {
                this.datasources[i] = new Datasource(this, dsDefs[i]);
            }
            ArcDef[] arcDefs = rrdDef.getArcDefs();
            this.archives = new Archive[arcDefs.length];
            for (int i = 0; i < arcDefs.length; ++i) {
                this.archives[i] = new Archive(this, arcDefs[i]);
            }
        }
        catch (IOException e) {
            this.backend.close();
            throw e;
        }
    }

    public RrdDb(String path, boolean readOnly) throws IOException, RrdException {
        this(path, readOnly, RrdBackendFactory.getDefaultFactory());
    }

    public RrdDb(String path, boolean readOnly, RrdBackendFactory factory) throws FileNotFoundException, IOException, RrdException {
        if (!factory.exists(path)) {
            throw new FileNotFoundException("Could not open " + path + " [non existent]");
        }
        this.backend = factory.open(path, readOnly);
        try {
            this.header = new Header(this, (RrdDef)null);
            this.header.validateHeader();
            int dsCount = this.header.getDsCount();
            this.datasources = new Datasource[dsCount];
            for (int i = 0; i < dsCount; ++i) {
                this.datasources[i] = new Datasource(this, null);
            }
            int arcCount = this.header.getArcCount();
            this.archives = new Archive[arcCount];
            for (int i = 0; i < arcCount; ++i) {
                this.archives[i] = new Archive(this, null);
            }
        }
        catch (RrdException e) {
            this.backend.close();
            throw e;
        }
        catch (IOException e) {
            this.backend.close();
            throw e;
        }
    }

    public RrdDb(String path) throws IOException, RrdException {
        this(path, false);
    }

    public RrdDb(String path, RrdBackendFactory factory) throws IOException, RrdException {
        this(path, false, factory);
    }

    public RrdDb(String rrdPath, String externalPath) throws IOException, RrdException, RrdException {
        this(rrdPath, externalPath, RrdBackendFactory.getDefaultFactory());
    }

    public RrdDb(String rrdPath, String externalPath, RrdBackendFactory factory) throws IOException, RrdException {
        DataImporter reader;
        if (externalPath.startsWith(PREFIX_RRDTool)) {
            String rrdToolPath = externalPath.substring(PREFIX_RRDTool.length());
            reader = new RrdToolReader(rrdToolPath);
        } else if (externalPath.startsWith(PREFIX_XML)) {
            externalPath = externalPath.substring(PREFIX_XML.length());
            reader = new XmlReader(externalPath);
        } else {
            reader = new XmlReader(externalPath);
        }
        this.backend = factory.open(rrdPath, false);
        try {
            int i;
            this.backend.setLength(reader.getEstimatedSize());
            this.header = new Header(this, reader);
            this.datasources = new Datasource[reader.getDsCount()];
            for (i = 0; i < this.datasources.length; ++i) {
                this.datasources[i] = new Datasource(this, reader, i);
            }
            this.archives = new Archive[reader.getArcCount()];
            for (i = 0; i < this.archives.length; ++i) {
                this.archives[i] = new Archive(this, reader, i);
            }
            reader.release();
        }
        catch (RrdException e) {
            this.backend.close();
            throw e;
        }
        catch (IOException e) {
            this.backend.close();
            throw e;
        }
    }

    public RrdDb(File file) throws IOException, RrdException {
        this(file.getPath());
    }

    public RrdDb(File file, boolean readOnly) throws IOException, RrdException {
        this(file.getPath(), readOnly);
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.backend.close();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Header getHeader() {
        return this.header;
    }

    public Datasource getDatasource(int dsIndex) {
        return this.datasources[dsIndex];
    }

    public Archive getArchive(int arcIndex) {
        return this.archives[arcIndex];
    }

    public String[] getDsNames() throws IOException {
        int n = this.datasources.length;
        String[] dsNames = new String[n];
        for (int i = 0; i < n; ++i) {
            dsNames[i] = this.datasources[i].getDsName();
        }
        return dsNames;
    }

    public Sample createSample(long time) throws IOException {
        return new Sample(this, time);
    }

    public Sample createSample() throws IOException {
        return this.createSample(Util.getTime());
    }

    public FetchRequest createFetchRequest(String consolFun, long fetchStart, long fetchEnd, long resolution) throws RrdException {
        return new FetchRequest(this, consolFun, fetchStart, fetchEnd, resolution);
    }

    public FetchRequest createFetchRequest(String consolFun, long fetchStart, long fetchEnd) throws RrdException {
        return this.createFetchRequest(consolFun, fetchStart, fetchEnd, 1L);
    }

    synchronized void store(Sample sample) throws IOException, RrdException {
        if (this.closed) {
            throw new RrdException("RRD already closed, cannot store this  sample");
        }
        long newTime = sample.getTime();
        long lastTime = this.header.getLastUpdateTime();
        if (lastTime >= newTime) {
            throw new RrdException("Bad sample timestamp " + newTime + ". Last update time was " + lastTime + ", at least one second step is required");
        }
        double[] newValues = sample.getValues();
        for (int i = 0; i < this.datasources.length; ++i) {
            double newValue = newValues[i];
            this.datasources[i].process(newTime, newValue);
        }
        this.header.setLastUpdateTime(newTime);
    }

    synchronized FetchData fetchData(FetchRequest request) throws IOException, RrdException {
        if (this.closed) {
            throw new RrdException("RRD already closed, cannot fetch data");
        }
        Archive archive = this.findMatchingArchive(request);
        return archive.fetchData(request);
    }

    public Archive findMatchingArchive(FetchRequest request) throws RrdException, IOException {
        String consolFun = request.getConsolFun();
        long fetchStart = request.getFetchStart();
        long fetchEnd = request.getFetchEnd();
        long resolution = request.getResolution();
        Archive bestFullMatch = null;
        Archive bestPartialMatch = null;
        long bestStepDiff = 0L;
        long bestMatch = 0L;
        for (Archive archive : this.archives) {
            if (!archive.getConsolFun().equals(consolFun)) continue;
            long arcStep = archive.getArcStep();
            long arcStart = archive.getStartTime() - arcStep;
            long arcEnd = archive.getEndTime();
            long fullMatch = fetchEnd - fetchStart;
            if (arcEnd >= fetchEnd && arcStart <= fetchStart) {
                long tmpStepDiff = Math.abs(archive.getArcStep() - resolution);
                if (tmpStepDiff >= bestStepDiff && bestFullMatch != null) continue;
                bestStepDiff = tmpStepDiff;
                bestFullMatch = archive;
                continue;
            }
            long tmpMatch = fullMatch;
            if (arcStart > fetchStart) {
                tmpMatch -= arcStart - fetchStart;
            }
            if (arcEnd < fetchEnd) {
                tmpMatch -= fetchEnd - arcEnd;
            }
            if (bestPartialMatch != null && bestMatch >= tmpMatch) continue;
            bestPartialMatch = archive;
            bestMatch = tmpMatch;
        }
        if (bestFullMatch != null) {
            return bestFullMatch;
        }
        if (bestPartialMatch != null) {
            return bestPartialMatch;
        }
        throw new RrdException("RRD file does not contain RRA:" + consolFun + " archive");
    }

    public Archive findStartMatchArchive(String consolFun, long startTime, long resolution) throws IOException {
        int fallBackIndex = 0;
        int arcIndex = -1;
        long minDiff = Long.MAX_VALUE;
        long fallBackDiff = Long.MAX_VALUE;
        for (int i = 0; i < this.archives.length; ++i) {
            if (!this.archives[i].getConsolFun().equals(consolFun)) continue;
            long arcStep = this.archives[i].getArcStep();
            long diff = Math.abs(resolution - arcStep);
            if (startTime >= this.archives[i].getStartTime()) {
                if (diff == 0L) {
                    return this.archives[i];
                }
                if (diff >= minDiff) continue;
                minDiff = diff;
                arcIndex = i;
                continue;
            }
            if (diff >= fallBackDiff) continue;
            fallBackDiff = diff;
            fallBackIndex = i;
        }
        return arcIndex >= 0 ? this.archives[arcIndex] : this.archives[fallBackIndex];
    }

    public synchronized String dump() throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.header.dump());
        for (Datasource datasource : this.datasources) {
            buffer.append(datasource.dump());
        }
        for (RrdUpdater rrdUpdater : this.archives) {
            buffer.append(((Archive)rrdUpdater).dump());
        }
        return buffer.toString();
    }

    void archive(Datasource datasource, double value, long numUpdates) throws IOException, RrdException {
        int dsIndex = this.getDsIndex(datasource.getDsName());
        for (Archive archive : this.archives) {
            archive.archive(dsIndex, value, numUpdates);
        }
    }

    public int getDsIndex(String dsName) throws RrdException, IOException {
        for (int i = 0; i < this.datasources.length; ++i) {
            if (!this.datasources[i].getDsName().equals(dsName)) continue;
            return i;
        }
        throw new RrdException("Unknown datasource name: " + dsName);
    }

    public boolean containsDs(String dsName) throws IOException {
        for (Datasource datasource : this.datasources) {
            if (!datasource.getDsName().equals(dsName)) continue;
            return true;
        }
        return false;
    }

    Datasource[] getDatasources() {
        return this.datasources;
    }

    Archive[] getArchives() {
        return this.archives;
    }

    public synchronized void dumpXml(OutputStream destination) throws IOException {
        XmlWriter writer = new XmlWriter(destination);
        writer.startTag("rrd");
        this.header.appendXml(writer);
        for (Datasource datasource : this.datasources) {
            datasource.appendXml(writer);
        }
        for (RrdUpdater rrdUpdater : this.archives) {
            ((Archive)rrdUpdater).appendXml(writer);
        }
        writer.closeTag();
        writer.flush();
    }

    public synchronized void exportXml(OutputStream destination) throws IOException {
        this.dumpXml(destination);
    }

    public synchronized String getXml() throws IOException, RrdException {
        ByteArrayOutputStream destination = new ByteArrayOutputStream(100000);
        this.dumpXml(destination);
        return destination.toString();
    }

    public synchronized String exportXml() throws IOException, RrdException {
        return this.getXml();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dumpXml(String filename) throws IOException, RrdException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(filename, false);
            this.dumpXml(outputStream);
        }
        finally {
            if (outputStream != null) {
                ((OutputStream)outputStream).close();
            }
        }
    }

    public synchronized void exportXml(String filename) throws IOException, RrdException {
        this.dumpXml(filename);
    }

    public synchronized long getLastUpdateTime() throws IOException {
        return this.header.getLastUpdateTime();
    }

    public synchronized RrdDef getRrdDef() throws RrdException, IOException {
        long startTime = this.header.getLastUpdateTime();
        long step = this.header.getStep();
        String path = this.backend.getPath();
        RrdDef rrdDef = new RrdDef(path, startTime, step);
        for (Datasource datasource : this.datasources) {
            DsDef dsDef = new DsDef(datasource.getDsName(), datasource.getDsType(), datasource.getHeartbeat(), datasource.getMinValue(), datasource.getMaxValue());
            rrdDef.addDatasource(dsDef);
        }
        for (RrdUpdater rrdUpdater : this.archives) {
            ArcDef arcDef = new ArcDef(((Archive)rrdUpdater).getConsolFun(), ((Archive)rrdUpdater).getXff(), ((Archive)rrdUpdater).getSteps(), ((Archive)rrdUpdater).getRows());
            rrdDef.addArchive(arcDef);
        }
        return rrdDef;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public synchronized void copyStateTo(RrdUpdater other) throws IOException, RrdException {
        int j;
        int i;
        if (!(other instanceof RrdDb)) {
            throw new RrdException("Cannot copy RrdDb object to " + other.getClass().getName());
        }
        RrdDb otherRrd = (RrdDb)other;
        this.header.copyStateTo(otherRrd.header);
        for (i = 0; i < this.datasources.length; ++i) {
            j = Util.getMatchingDatasourceIndex(this, i, otherRrd);
            if (j < 0) continue;
            this.datasources[i].copyStateTo(otherRrd.datasources[j]);
        }
        for (i = 0; i < this.archives.length; ++i) {
            j = Util.getMatchingArchiveIndex(this, i, otherRrd);
            if (j < 0) continue;
            this.archives[i].copyStateTo(otherRrd.archives[j]);
        }
    }

    public Datasource getDatasource(String dsName) throws IOException {
        try {
            return this.getDatasource(this.getDsIndex(dsName));
        }
        catch (RrdException e) {
            return null;
        }
    }

    public int getArcIndex(String consolFun, int steps) throws RrdException, IOException {
        for (int i = 0; i < this.archives.length; ++i) {
            if (!this.archives[i].getConsolFun().equals(consolFun) || this.archives[i].getSteps() != steps) continue;
            return i;
        }
        throw new RrdException("Could not find archive " + consolFun + "/" + steps);
    }

    public Archive getArchive(String consolFun, int steps) throws IOException {
        try {
            return this.getArchive(this.getArcIndex(consolFun, steps));
        }
        catch (RrdException e) {
            return null;
        }
    }

    public String getCanonicalPath() throws IOException {
        if (this.backend instanceof RrdFileBackend) {
            return ((RrdFileBackend)this.backend).getCanonicalPath();
        }
        throw new IOException("The underlying backend has no canonical path");
    }

    public String getPath() {
        return this.backend.getPath();
    }

    public RrdBackend getRrdBackend() {
        return this.backend;
    }

    public RrdAllocator getRrdAllocator() {
        return this.allocator;
    }

    public synchronized byte[] getBytes() throws IOException {
        return this.backend.readAll();
    }

    public static void setDefaultFactory(String factoryName) throws RrdException {
        RrdBackendFactory.setDefaultFactory(factoryName);
    }

    public synchronized double[] getLastDatasourceValues() throws IOException {
        double[] values = new double[this.datasources.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.datasources[i].getLastValue();
        }
        return values;
    }

    public synchronized double getLastDatasourceValue(String dsName) throws IOException, RrdException {
        int dsIndex = this.getDsIndex(dsName);
        return this.datasources[dsIndex].getLastValue();
    }

    public int getDsCount() {
        return this.datasources.length;
    }

    public int getArcCount() {
        return this.archives.length;
    }

    public long getLastArchiveUpdateTime() throws IOException {
        long last = 0L;
        for (Archive archive : this.archives) {
            last = Math.max(last, archive.getEndTime());
        }
        return last;
    }

    public synchronized String getInfo() throws IOException {
        return this.header.getInfo();
    }

    public synchronized void setInfo(String info) throws IOException {
        this.header.setInfo(info);
    }

    public static void main(String[] args) {
        System.out.println("JRobin Java Library :: RRDTool choice for the Java world");
        System.out.println("==================================================================");
        System.out.println("JRobin base directory: " + Util.getJRobinHomeDirectory());
        long time = Util.getTime();
        System.out.println("Current timestamp: " + time + ": " + new Date(time * 1000L));
        System.out.println("------------------------------------------------------------------");
        System.out.println("For the latest information visit: http://www.jrobin.org");
        System.out.println("(C) 2003-2005 Sasa Markovic. All rights reserved.");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "[" + new File(this.getPath()).getName() + "]";
    }
}

