/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.ArcDef;
import org.jrobin.core.ArcState;
import org.jrobin.core.ConsolFuns;
import org.jrobin.core.DataImporter;
import org.jrobin.core.FetchData;
import org.jrobin.core.FetchRequest;
import org.jrobin.core.Robin;
import org.jrobin.core.RrdAllocator;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDouble;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdInt;
import org.jrobin.core.RrdString;
import org.jrobin.core.RrdUpdater;
import org.jrobin.core.Util;
import org.jrobin.core.XmlWriter;

public class Archive
implements RrdUpdater,
ConsolFuns {
    private RrdDb parentDb;
    private RrdString consolFun;
    private RrdDouble xff;
    private RrdInt steps;
    private RrdInt rows;
    private Robin[] robins;
    private ArcState[] states;

    Archive(RrdDb parentDb, ArcDef arcDef) throws IOException {
        boolean shouldInitialize = arcDef != null;
        this.parentDb = parentDb;
        this.consolFun = new RrdString(this, true);
        this.xff = new RrdDouble(this);
        this.steps = new RrdInt(this, true);
        this.rows = new RrdInt(this, true);
        if (shouldInitialize) {
            this.consolFun.set(arcDef.getConsolFun());
            this.xff.set(arcDef.getXff());
            this.steps.set(arcDef.getSteps());
            this.rows.set(arcDef.getRows());
        }
        int dsCount = parentDb.getHeader().getDsCount();
        this.states = new ArcState[dsCount];
        this.robins = new Robin[dsCount];
        int numRows = this.rows.get();
        for (int i = 0; i < dsCount; ++i) {
            this.states[i] = new ArcState(this, shouldInitialize);
            this.robins[i] = new Robin(this, numRows, shouldInitialize);
        }
    }

    Archive(RrdDb parentDb, DataImporter reader, int arcIndex) throws IOException, RrdException, RrdException {
        this(parentDb, new ArcDef(reader.getConsolFun(arcIndex), reader.getXff(arcIndex), reader.getSteps(arcIndex), reader.getRows(arcIndex)));
        int dsCount = parentDb.getHeader().getDsCount();
        for (int i = 0; i < dsCount; ++i) {
            this.states[i].setAccumValue(reader.getStateAccumValue(arcIndex, i));
            this.states[i].setNanSteps(reader.getStateNanSteps(arcIndex, i));
            double[] values = reader.getValues(arcIndex, i);
            this.robins[i].update(values);
        }
    }

    public long getArcStep() throws IOException {
        long step = this.parentDb.getHeader().getStep();
        return step * (long)this.steps.get();
    }

    String dump() throws IOException {
        StringBuffer buffer = new StringBuffer("== ARCHIVE ==\n");
        buffer.append("RRA:").append(this.consolFun.get()).append(":").append(this.xff.get()).append(":").append(this.steps.get()).append(":").append(this.rows.get()).append("\n");
        buffer.append("interval [").append(this.getStartTime()).append(", ").append(this.getEndTime()).append("]\n");
        for (int i = 0; i < this.robins.length; ++i) {
            buffer.append(this.states[i].dump());
            buffer.append(this.robins[i].dump());
        }
        return buffer.toString();
    }

    RrdDb getParentDb() {
        return this.parentDb;
    }

    public void archive(int dsIndex, double value, long numStepUpdates) throws IOException {
        Robin robin = this.robins[dsIndex];
        ArcState state = this.states[dsIndex];
        long step = this.parentDb.getHeader().getStep();
        long lastUpdateTime = this.parentDb.getHeader().getLastUpdateTime();
        long updateTime = Util.normalize(lastUpdateTime, step) + step;
        long arcStep = this.getArcStep();
        String consolFunString = this.consolFun.get();
        int numSteps = this.steps.get();
        int numRows = this.rows.get();
        double xffValue = this.xff.get();
        long numUpdates = numStepUpdates;
        while (numUpdates > 0L) {
            this.accumulate(state, value, consolFunString);
            --numUpdates;
            if (updateTime % arcStep == 0L) {
                this.finalizeStep(state, robin, consolFunString, numSteps, xffValue);
                break;
            }
            updateTime += step;
        }
        int bulkUpdateCount = (int)Math.min(numUpdates / (long)numSteps, (long)numRows);
        robin.bulkStore(value, bulkUpdateCount);
        long remainingUpdates = numUpdates % (long)numSteps;
        for (long i = 0L; i < remainingUpdates; ++i) {
            this.accumulate(state, value, consolFunString);
        }
    }

    private void accumulate(ArcState state, double value, String consolFunString) throws IOException {
        if (Double.isNaN(value)) {
            state.setNanSteps(state.getNanSteps() + 1L);
        } else {
            double accumValue = state.getAccumValue();
            if (consolFunString.equals("MIN")) {
                double minValue = Util.min(accumValue, value);
                if (minValue != accumValue) {
                    state.setAccumValue(minValue);
                }
            } else if (consolFunString.equals("MAX")) {
                double maxValue = Util.max(accumValue, value);
                if (maxValue != accumValue) {
                    state.setAccumValue(maxValue);
                }
            } else if (consolFunString.equals("LAST")) {
                state.setAccumValue(value);
            } else if (consolFunString.equals("AVERAGE")) {
                state.setAccumValue(Util.sum(accumValue, value));
            }
        }
    }

    private void finalizeStep(ArcState state, Robin robin, String consolFunString, long numSteps, double xffValue) throws IOException {
        long nanSteps = state.getNanSteps();
        double accumValue = state.getAccumValue();
        if ((double)nanSteps <= xffValue * (double)numSteps && !Double.isNaN(accumValue)) {
            if (consolFunString.equals("AVERAGE")) {
                accumValue /= (double)(numSteps - nanSteps);
            }
            robin.store(accumValue);
        } else {
            robin.store(Double.NaN);
        }
        state.setAccumValue(Double.NaN);
        state.setNanSteps(0L);
    }

    public String getConsolFun() throws IOException {
        return this.consolFun.get();
    }

    public double getXff() throws IOException {
        return this.xff.get();
    }

    public int getSteps() throws IOException {
        return this.steps.get();
    }

    public int getRows() throws IOException {
        return this.rows.get();
    }

    public long getStartTime() throws IOException {
        long endTime = this.getEndTime();
        long arcStep = this.getArcStep();
        long numRows = this.rows.get();
        return endTime - (numRows - 1L) * arcStep;
    }

    public long getEndTime() throws IOException {
        long arcStep = this.getArcStep();
        long lastUpdateTime = this.parentDb.getHeader().getLastUpdateTime();
        return Util.normalize(lastUpdateTime, arcStep);
    }

    public ArcState getArcState(int dsIndex) {
        return this.states[dsIndex];
    }

    public Robin getRobin(int dsIndex) {
        return this.robins[dsIndex];
    }

    FetchData fetchData(FetchRequest request) throws IOException, RrdException {
        long arcStep = this.getArcStep();
        long fetchStart = Util.normalize(request.getFetchStart(), arcStep);
        long fetchEnd = Util.normalize(request.getFetchEnd(), arcStep);
        if (fetchEnd < request.getFetchEnd()) {
            fetchEnd += arcStep;
        }
        long startTime = this.getStartTime();
        long endTime = this.getEndTime();
        String[] dsToFetch = request.getFilter();
        if (dsToFetch == null) {
            dsToFetch = this.parentDb.getDsNames();
        }
        int dsCount = dsToFetch.length;
        int ptsCount = (int)((fetchEnd - fetchStart) / arcStep + 1L);
        long[] timestamps = new long[ptsCount];
        double[][] values = new double[dsCount][ptsCount];
        long matchStartTime = Math.max(fetchStart, startTime);
        long matchEndTime = Math.min(fetchEnd, endTime);
        Object robinValues = null;
        if (matchStartTime <= matchEndTime) {
            int matchCount = (int)((matchEndTime - matchStartTime) / arcStep + 1L);
            int matchStartIndex = (int)((matchStartTime - startTime) / arcStep);
            robinValues = new double[dsCount][];
            for (int i = 0; i < dsCount; ++i) {
                int dsIndex = this.parentDb.getDsIndex(dsToFetch[i]);
                robinValues[i] = this.robins[dsIndex].getValues(matchStartIndex, matchCount);
            }
        }
        for (int ptIndex = 0; ptIndex < ptsCount; ++ptIndex) {
            long time;
            timestamps[ptIndex] = time = fetchStart + (long)ptIndex * arcStep;
            for (int i = 0; i < dsCount; ++i) {
                double value = Double.NaN;
                if (time >= matchStartTime && time <= matchEndTime) {
                    int robinValueIndex = (int)((time - matchStartTime) / arcStep);
                    assert (robinValues != null);
                    value = robinValues[i][robinValueIndex];
                }
                values[i][ptIndex] = value;
            }
        }
        FetchData fetchData = new FetchData(this, request);
        fetchData.setTimestamps(timestamps);
        fetchData.setValues(values);
        return fetchData;
    }

    void appendXml(XmlWriter writer) throws IOException {
        writer.startTag("rra");
        writer.writeTag("cf", this.consolFun.get());
        writer.writeComment(this.getArcStep() + " seconds");
        writer.writeTag("pdp_per_row", this.steps.get());
        writer.writeTag("xff", this.xff.get());
        writer.startTag("cdp_prep");
        for (ArcState state : this.states) {
            state.appendXml(writer);
        }
        writer.closeTag();
        writer.startTag("database");
        long startTime = this.getStartTime();
        for (int i = 0; i < this.rows.get(); ++i) {
            long time = startTime + (long)i * this.getArcStep();
            writer.writeComment(Util.getDate(time) + " / " + time);
            writer.startTag("row");
            for (Robin robin : this.robins) {
                writer.writeTag("v", robin.getValue(i));
            }
            writer.closeTag();
        }
        writer.closeTag();
        writer.closeTag();
    }

    public void copyStateTo(RrdUpdater other) throws IOException, RrdException {
        if (!(other instanceof Archive)) {
            throw new RrdException("Cannot copy Archive object to " + other.getClass().getName());
        }
        Archive arc = (Archive)other;
        if (!arc.consolFun.get().equals(this.consolFun.get())) {
            throw new RrdException("Incompatible consolidation functions");
        }
        if (arc.steps.get() != this.steps.get()) {
            throw new RrdException("Incompatible number of steps");
        }
        int count = this.parentDb.getHeader().getDsCount();
        for (int i = 0; i < count; ++i) {
            int j = Util.getMatchingDatasourceIndex(this.parentDb, i, arc.parentDb);
            if (j < 0) continue;
            this.states[i].copyStateTo(arc.states[j]);
            this.robins[i].copyStateTo(arc.robins[j]);
        }
    }

    public void setXff(double xff) throws RrdException, IOException {
        if (xff < 0.0 || xff >= 1.0) {
            throw new RrdException("Invalid xff supplied (" + xff + "), must be >= 0 and < 1");
        }
        this.xff.set(xff);
    }

    public RrdBackend getRrdBackend() {
        return this.parentDb.getRrdBackend();
    }

    public RrdAllocator getRrdAllocator() {
        return this.parentDb.getRrdAllocator();
    }

    public String toString() {
        return "Archive@" + Integer.toHexString(this.hashCode()) + "[parentDb=" + this.parentDb + ",consolFun=" + this.consolFun + ",xff=" + this.xff + ",steps=" + this.steps + ",rows=" + this.rows + ",robins=" + this.robins + ",states=" + this.states + "]";
    }
}

