package jrdesktop.server.main;

import javax.swing.ImageIcon;
import jrdesktop.main;

import jrdesktop.utilities.InetAdrUtility;

/**
 * ConfigGUI.java
 * @author  benbac
 */

public class ConfigGUI extends javax.swing.JFrame {
    
    /** Creates new form ServerConnection */
    public ConfigGUI() {
        initComponents();
        Config.loadConfiguration();
        
        jComboBoxLocalAdrs.setSelectedItem(Config.server_address);
        jTextFieldPort.setText(String.valueOf(Config.server_port));
       
        jTextFieldUsername.setText(Config.username);        
        jPasswordField.setText(Config.password);
        
        jCheckBoxSSLEnabled.setSelected(Config.ssl_enabled);
        jCheckBoxMultihomedEnabled.setSelected(Config.multihomed_enabled);        
        jCheckBoxDefaultAdr.setSelected(Config.default_address);
        
        if (jCheckBoxMultihomedEnabled.isSelected())
            jCheckBoxMultihomedEnabledActionPerformed(null);
        else
            jCheckBoxManualAdrActionPerformed(null);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jButtonCancel = new javax.swing.JButton();
        jButtonOK = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jComboBoxLocalAdrs = new javax.swing.JComboBox(InetAdrUtility.getLocalIPAdresses());
        jLabel1 = new javax.swing.JLabel();
        jCheckBoxMultihomedEnabled = new javax.swing.JCheckBox();
        jCheckBoxManualAdr = new javax.swing.JCheckBox();
        jLabel2 = new javax.swing.JLabel();
        jTextFieldPort = new javax.swing.JTextField();
        jCheckBoxDefaultAdr = new javax.swing.JCheckBox();
        jLabel3 = new javax.swing.JLabel();
        jTextFieldUsername = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        jPasswordField = new javax.swing.JPasswordField();
        jCheckBoxSSLEnabled = new javax.swing.JCheckBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Server configuration");
        setIconImage(new ImageIcon(main.IDLE_ICON).getImage());
        setResizable(false);

        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Server configuration"));

        jComboBoxLocalAdrs.setMaximumSize(new java.awt.Dimension(28, 20));
        jComboBoxLocalAdrs.setMinimumSize(new java.awt.Dimension(28, 20));

        jLabel1.setText("Address:");

        jCheckBoxMultihomedEnabled.setText("Auto detect (Multihomed server)");
        jCheckBoxMultihomedEnabled.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxMultihomedEnabledActionPerformed(evt);
            }
        });

        jCheckBoxManualAdr.setSelected(true);
        jCheckBoxManualAdr.setText("Manual");
        jCheckBoxManualAdr.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxManualAdrActionPerformed(evt);
            }
        });

        jLabel2.setText("Port:");

        jTextFieldPort.setText("6666");
        jTextFieldPort.setMaximumSize(new java.awt.Dimension(28, 20));
        jTextFieldPort.setMinimumSize(new java.awt.Dimension(28, 20));
        jTextFieldPort.setPreferredSize(new java.awt.Dimension(28, 20));

        jCheckBoxDefaultAdr.setText("Default");

        jLabel3.setText("Username:");

        jTextFieldUsername.setText("admin");
        jTextFieldUsername.setMaximumSize(new java.awt.Dimension(28, 2147483647));

        jLabel4.setText("Password:");

        jPasswordField.setText("admin");
        jPasswordField.setMaximumSize(new java.awt.Dimension(28, 2147483647));

        jCheckBoxSSLEnabled.setText("SSL");

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup()
                        .addComponent(jCheckBoxManualAdr)
                        .addGap(18, 18, 18)
                        .addComponent(jCheckBoxDefaultAdr)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 13, Short.MAX_VALUE)
                        .addComponent(jCheckBoxMultihomedEnabled)
                        .addGap(18, 18, 18)
                        .addComponent(jCheckBoxSSLEnabled))
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup()
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel1)
                            .addComponent(jLabel3))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel2Layout.createSequentialGroup()
                                .addComponent(jTextFieldUsername, javax.swing.GroupLayout.PREFERRED_SIZE, 131, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jLabel4)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jPasswordField, javax.swing.GroupLayout.PREFERRED_SIZE, 148, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(jPanel2Layout.createSequentialGroup()
                                .addComponent(jComboBoxLocalAdrs, javax.swing.GroupLayout.PREFERRED_SIZE, 217, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jLabel2)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jTextFieldPort, javax.swing.GroupLayout.DEFAULT_SIZE, 88, Short.MAX_VALUE))))))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBoxManualAdr)
                    .addComponent(jCheckBoxSSLEnabled)
                    .addComponent(jCheckBoxMultihomedEnabled)
                    .addComponent(jCheckBoxDefaultAdr))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(jLabel2)
                    .addComponent(jTextFieldPort, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBoxLocalAdrs, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(jPasswordField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel4)
                    .addComponent(jTextFieldUsername, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jButtonOK)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonCancel))
                    .addComponent(jPanel2, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(53, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonCancel)
                    .addComponent(jButtonOK))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-490)/2, (screenSize.height-209)/2, 490, 209);
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
        dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
        Config.server_address = jComboBoxLocalAdrs.getSelectedItem().toString();
        Config.server_port = Integer.valueOf(jTextFieldPort.getText());
        
        Config.username = jTextFieldUsername.getText();
        Config.password = String.copyValueOf(jPasswordField.getPassword());
        
        Config.multihomed_enabled = jCheckBoxMultihomedEnabled.isSelected();
        Config.ssl_enabled = jCheckBoxSSLEnabled.isSelected();
        
        Config.default_address = jCheckBoxDefaultAdr.isSelected();
        
        Config.storeConfiguration();
        dispose();
    }//GEN-LAST:event_jButtonOKActionPerformed

    private void jCheckBoxManualAdrActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxManualAdrActionPerformed
        jCheckBoxDefaultAdr.setEnabled(jCheckBoxManualAdr.isSelected());
        jComboBoxLocalAdrs.setEnabled(jCheckBoxManualAdr.isSelected());
        jCheckBoxMultihomedEnabled.setSelected(!jCheckBoxManualAdr.isSelected());
    }//GEN-LAST:event_jCheckBoxManualAdrActionPerformed

    private void jCheckBoxMultihomedEnabledActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxMultihomedEnabledActionPerformed
        jCheckBoxManualAdr.setSelected(!jCheckBoxMultihomedEnabled.isSelected());
        jCheckBoxDefaultAdr.setSelected(false);        
        jCheckBoxDefaultAdr.setEnabled(!jCheckBoxMultihomedEnabled.isSelected());
        jComboBoxLocalAdrs.setEnabled(!jCheckBoxMultihomedEnabled.isSelected());                
    }//GEN-LAST:event_jCheckBoxMultihomedEnabledActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new ConfigGUI().setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JCheckBox jCheckBoxDefaultAdr;
    private javax.swing.JCheckBox jCheckBoxManualAdr;
    private javax.swing.JCheckBox jCheckBoxMultihomedEnabled;
    private javax.swing.JCheckBox jCheckBoxSSLEnabled;
    private javax.swing.JComboBox jComboBoxLocalAdrs;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPasswordField jPasswordField;
    private javax.swing.JTextField jTextFieldPort;
    private javax.swing.JTextField jTextFieldUsername;
    // End of variables declaration//GEN-END:variables
    
}
