package jrdesktop;

import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

import jrdesktop.server.main.ActiveConnectionsGUI;
import jrdesktop.server.main.ConfigGUI;
import jrdesktop.server.rmi.Server;
import jrdesktop.viewer.main.ConnectionDialog;

/**
 * GUI.java
 * @author  benbac
 */
public class mainFrame extends javax.swing.JFrame {
    private static mainFrame frame = new mainFrame();
    
    /** Creates new form ServerGUI */
    public mainFrame() {        
        initComponents();        
        updateStatus();
        
        Config.loadConfiguration();
        jCheckBoxWindow.setSelected(Config.GUI_disabled);
        jCheckBoxTrayicon.setSelected(Config.Systray_disabled);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPopupMenuFileTranfer = new javax.swing.JPopupMenu();
        jMenuItemSendFiles = new javax.swing.JMenuItem();
        jMenuItemReceiveFiles = new javax.swing.JMenuItem();
        jPanel1 = new javax.swing.JPanel();
        jButtonStartStop = new javax.swing.JButton();
        jButtonFileTrans = new javax.swing.JButton();
        jButtonViewers = new javax.swing.JButton();
        jButtonConfig = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextAreaStatus = new javax.swing.JTextArea();
        jCheckBoxWindow = new javax.swing.JCheckBox();
        jCheckBoxTrayicon = new javax.swing.JCheckBox();
        jPanel2 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jButtonAbout = new javax.swing.JButton();
        jButtonExit = new javax.swing.JButton();

        jMenuItemSendFiles.setText("Send files");
        jMenuItemSendFiles.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSendFilesActionPerformed(evt);
            }
        });
        jPopupMenuFileTranfer.add(jMenuItemSendFiles);

        jMenuItemReceiveFiles.setText("Receive files");
        jMenuItemReceiveFiles.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemReceiveFilesActionPerformed(evt);
            }
        });
        jPopupMenuFileTranfer.add(jMenuItemReceiveFiles);

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle("Java Remote Desktop - jrdesktop");
        setIconImage(new ImageIcon(main.IDLE_ICON).getImage());
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Server"));

        jButtonStartStop.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/player_play.png"))); // NOI18N
        jButtonStartStop.setText("Start");
        jButtonStartStop.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonStartStopActionPerformed(evt);
            }
        });

        jButtonFileTrans.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/file_trans.png"))); // NOI18N
        jButtonFileTrans.setText("File transfer");
        jButtonFileTrans.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFileTransActionPerformed(evt);
            }
        });

        jButtonViewers.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/connect_established.png"))); // NOI18N
        jButtonViewers.setText("Active connections...");
        jButtonViewers.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonViewersActionPerformed(evt);
            }
        });

        jButtonConfig.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/configure.png"))); // NOI18N
        jButtonConfig.setText("Configuration");
        jButtonConfig.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonConfigActionPerformed(evt);
            }
        });

        jTextAreaStatus.setColumns(20);
        jTextAreaStatus.setEditable(false);
        jTextAreaStatus.setFont(new java.awt.Font("Courier New", 0, 12)); // NOI18N
        jTextAreaStatus.setRows(4);
        jTextAreaStatus.setBorder(javax.swing.BorderFactory.createTitledBorder("Status"));
        jScrollPane1.setViewportView(jTextAreaStatus);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 213, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jButtonFileTrans, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jButtonViewers, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jButtonConfig, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jButtonStartStop, javax.swing.GroupLayout.DEFAULT_SIZE, 159, Short.MAX_VALUE))
                .addContainerGap(20, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jButtonStartStop)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonConfig)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonViewers)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonFileTrans))
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 118, Short.MAX_VALUE))
                .addContainerGap())
        );

        jCheckBoxWindow.setSelected(true);
        jCheckBoxWindow.setText("Do not display this window on application startup.");
        jCheckBoxWindow.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxWindowActionPerformed(evt);
            }
        });

        jCheckBoxTrayicon.setSelected(true);
        jCheckBoxTrayicon.setText("Disable Trayicon.");
        jCheckBoxTrayicon.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxTrayiconActionPerformed(evt);
            }
        });

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(""));

        jButton1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/connect_creating.png"))); // NOI18N
        jButton1.setText("Connect to Server ...");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jButtonAbout.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/about.png"))); // NOI18N
        jButtonAbout.setText("About");
        jButtonAbout.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAboutActionPerformed(evt);
            }
        });

        jButtonExit.setIcon(new javax.swing.ImageIcon(getClass().getResource("/jrdesktop/images/exit.png"))); // NOI18N
        jButtonExit.setText("Exit");
        jButtonExit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonExitActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jButton1, javax.swing.GroupLayout.PREFERRED_SIZE, 175, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonAbout, javax.swing.GroupLayout.PREFERRED_SIZE, 98, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonExit, javax.swing.GroupLayout.DEFAULT_SIZE, 103, Short.MAX_VALUE)
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                .addComponent(jButton1, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(jButtonAbout)
                .addComponent(jButtonExit))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(jPanel2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addComponent(jCheckBoxWindow)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jCheckBoxTrayicon)))
                .addContainerGap(19, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBoxWindow)
                    .addComponent(jCheckBoxTrayicon))
                .addContainerGap(12, Short.MAX_VALUE))
        );

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-461)/2, (screenSize.height-309)/2, 461, 309);
    }// </editor-fold>//GEN-END:initComponents

private void jButtonStartStopActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonStartStopActionPerformed
    if (Server.isRunning())
        Server.Stop();            
    else
        Server.Start();
    
    updateStatus();
}//GEN-LAST:event_jButtonStartStopActionPerformed

private void jButtonViewersActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonViewersActionPerformed
    if (isServerRunning())
        ActiveConnectionsGUI.main(null); 
}//GEN-LAST:event_jButtonViewersActionPerformed

private void jButtonConfigActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonConfigActionPerformed
    ConfigGUI.main(null);
}//GEN-LAST:event_jButtonConfigActionPerformed

private void jButtonAboutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAboutActionPerformed
    AboutGUI.main(null);
}//GEN-LAST:event_jButtonAboutActionPerformed

private void jButtonExitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonExitActionPerformed
    if (JOptionPane.showConfirmDialog(this, "Exit application ?", "Confirm Dialog", 
            JOptionPane.OK_CANCEL_OPTION) == JOptionPane.OK_OPTION)
            main.exit();
}//GEN-LAST:event_jButtonExitActionPerformed

private void jMenuItemSendFilesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSendFilesActionPerformed
    if (isServerRunning())
        if (Server.SendClipboardFileList() == 0) {
            // no files in clipboard, exit
            JOptionPane.showMessageDialog(null, "No file in clipboard !!", 
                "Information", JOptionPane.INFORMATION_MESSAGE);                                        
        }  
}//GEN-LAST:event_jMenuItemSendFilesActionPerformed

private void jMenuItemReceiveFilesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemReceiveFilesActionPerformed
    if (isServerRunning())
        Server.setUploadingFolder(); 
}//GEN-LAST:event_jMenuItemReceiveFilesActionPerformed

private void jButtonFileTransActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFileTransActionPerformed
    jPopupMenuFileTranfer.show(jButtonFileTrans, 15, 15);
}//GEN-LAST:event_jButtonFileTransActionPerformed

private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
    ConnectionDialog.main(null);
}//GEN-LAST:event_jButton1ActionPerformed

private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    if (evt.getID() == WindowEvent.WINDOW_CLOSING) {
            if (!Server.isRunning() && (!SysTray.isEnabled() || !SysTray.isSupported())) {
                if (JOptionPane.showConfirmDialog(this, "Exit application ?", 
                        "Confirm Dialog", JOptionPane.OK_CANCEL_OPTION) == 
                    JOptionPane.OK_OPTION)
                        main.exit();            
            }
            else
                dispose();
    }
    else
        super.processWindowEvent(evt);       
}//GEN-LAST:event_formWindowClosing

private void jCheckBoxTrayiconActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxTrayiconActionPerformed
    Config.Systray_disabled = jCheckBoxTrayicon.isSelected();
    Config.storeConfiguration();
    
    if (!SysTray.isSupported()) {
        JOptionPane.showMessageDialog(this, "Systray not supported !!", "Info", 
                    JOptionPane.ERROR_MESSAGE);
        return;
    }
            
    if (Config.Systray_disabled) {
        if (SysTray.isEnabled())
            SysTray.Hide();        
    }
    else {
        if (!SysTray.isEnabled())
            SysTray.Show();
    }      
}//GEN-LAST:event_jCheckBoxTrayiconActionPerformed

private void jCheckBoxWindowActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxWindowActionPerformed
    Config.GUI_disabled = jCheckBoxWindow.isSelected();
    Config.storeConfiguration();
}//GEN-LAST:event_jCheckBoxWindowActionPerformed

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        if (frame.isDisplayable()) return;
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                frame.setVisible(true);
            }
        });
    }

    public static boolean isServerRunning() {
        boolean bool = Server.isRunning();
        if (!bool)
            JOptionPane.showMessageDialog(null, 
                "Server is not running !!", 
                "Information", JOptionPane.INFORMATION_MESSAGE);            
        return bool;
    }
    
    public void updateStatus() {
        if (Server.isRunning()) {
            jTextAreaStatus.setText(Server.getStatus());
            jButtonStartStop.setText("Stop");  
            jButtonStartStop.setIcon(new ImageIcon(main.STOP_ICON));
        }
        else {
            if (Server.isIdle())        
                jTextAreaStatus.setText("Idle.");
            else
                jTextAreaStatus.setText("Stopped.");
            jButtonStartStop.setText("Start");
            jButtonStartStop.setIcon(new ImageIcon(main.START_ICON));
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButtonAbout;
    private javax.swing.JButton jButtonConfig;
    private javax.swing.JButton jButtonExit;
    private javax.swing.JButton jButtonFileTrans;
    private javax.swing.JButton jButtonStartStop;
    private javax.swing.JButton jButtonViewers;
    private javax.swing.JCheckBox jCheckBoxTrayicon;
    private javax.swing.JCheckBox jCheckBoxWindow;
    private javax.swing.JMenuItem jMenuItemReceiveFiles;
    private javax.swing.JMenuItem jMenuItemSendFiles;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPopupMenu jPopupMenuFileTranfer;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea jTextAreaStatus;
    // End of variables declaration//GEN-END:variables

}
