/*
 * Decompiled with CFR 0.152.
 */
package patterns;

class ObjectMap {
    static final int EMPTY = 0;
    static final int INCOMPLETE = 1;
    static final int COMPLETE = 2;
    ObjectMapEntry[] map = new ObjectMapEntry[0];
    float fPos = 0.0f;
    int iState = 0;

    ObjectMap() {
    }

    void addEntry(float position, Object object) {
        if (position < this.fPos) {
            throw new IllegalArgumentException("position " + position + " < last position " + this.fPos);
        }
        if (position > 1.0f) {
            throw new IllegalArgumentException("position " + position + " > 1");
        }
        if (this.iState == 0 && position != 0.0f) {
            throw new IllegalStateException("First entry must be at position 0, was " + position);
        }
        this.appendEntry(position, object);
        if (position == 0.0f) {
            this.iState = 1;
        } else if (position == 1.0f) {
            this.iState = 2;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.map.length) {
            sb.append(String.valueOf(i) + "\t").append(this.map[i++].toString()).append("\n");
        }
        return sb.toString();
    }

    void appendEntry(float position, Object object) {
        int l = this.map.length;
        ObjectMapEntry[] newMap = new ObjectMapEntry[l + 1];
        System.arraycopy(this.map, 0, newMap, 0, l);
        newMap[l] = new ObjectMapEntry(position, object);
        this.map = newMap;
        this.fPos = position;
    }

    int lowIndex(float position) {
        int min = 0;
        int max = this.map.length - 1;
        int i = max >> 1;
        while (max > min + 1) {
            if (this.map[i].position >= position) {
                max = i;
                i -= i - min >> 1;
                continue;
            }
            min = i;
            i += max - i >> 1;
        }
        return min;
    }

    class ObjectMapEntry {
        float position;
        Object object;

        ObjectMapEntry(float position, Object object) {
            this.position = position;
            this.object = object;
        }

        public String toString() {
            return String.valueOf(this.position) + "\t" + this.object;
        }
    }
}

