/*
 * Decompiled with CFR 0.152.
 */
package jpatch.renderer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import jpatch.boundary.JPatchSettings;
import jpatch.entity.AnimLight;
import jpatch.entity.AnimModel;
import jpatch.entity.Camera;
import jpatch.entity.JPatchMaterial;
import jpatch.entity.Model;
import jpatch.entity.Patch;
import jpatch.renderer.AbstractRenderer;
import jpatch.renderer.PatchTesselator3;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RibRenderer4 {
    private PatchTesselator3 patchTesselator;

    public void writeToFile(List list, Camera camera, List list2, BufferedWriter bufferedWriter, String string) {
        JPatchSettings jPatchSettings = JPatchSettings.getInstance();
        try {
            Object object;
            String[] stringArray = new String[]{"box", "triangle", "catmullrom", "gaussian", "sinc"};
            float f = jPatchSettings.fRenderAspectHeight / jPatchSettings.fRenderAspectWidth;
            float f2 = (float)jPatchSettings.iRenderWidth / (float)jPatchSettings.iRenderHeight * f;
            float[] fArray = jPatchSettings.cBackgroundColor.getRGBColorComponents(new float[3]);
            bufferedWriter.write("##RenderMan RIB-Structure 1.1\n");
            bufferedWriter.write("##Creator JPatch pre0.4 development version - http://www.jpatch.com\n");
            bufferedWriter.write("\n\n");
            bufferedWriter.write("FrameBegin 1\n");
            bufferedWriter.write("\n");
            bufferedWriter.write("Display \"" + string + "\" \"tiff\" \"rgb\" \"string compression\" \"none\" \n");
            bufferedWriter.write("Format " + jPatchSettings.iRenderWidth + ' ' + jPatchSettings.iRenderHeight + ' ' + f2 + '\n');
            bufferedWriter.write("PixelSamples " + jPatchSettings.ribSettings.iPixelSamplesX + ' ' + jPatchSettings.ribSettings.iPixelSamplesX + '\n');
            bufferedWriter.write("PixelFilter \"" + stringArray[jPatchSettings.ribSettings.iPixelFilter] + "\" " + jPatchSettings.ribSettings.iPixelFilterX + ' ' + jPatchSettings.ribSettings.iPixelFilterY + '\n');
            bufferedWriter.write("ShadingRate " + jPatchSettings.ribSettings.fShadingRate + '\n');
            if (jPatchSettings.ribSettings.iShadingInterpolation == 0) {
                bufferedWriter.write("ShadingInterpolation \"constant\"\n");
            } else {
                bufferedWriter.write("ShadingInterpolation \"smooth\"\n");
            }
            bufferedWriter.write("\n");
            bufferedWriter.write("Imager \"background\" \"color background\" [" + fArray[0] + ' ' + fArray[1] + ' ' + fArray[2] + "]\n");
            bufferedWriter.write("\n");
            Matrix4d matrix4d = new Matrix4d(camera.getTransform());
            matrix4d.invert();
            bufferedWriter.write("Projection \"perspective\" \"fov\" [" + camera.getFieldOfView() + "]\n");
            bufferedWriter.write("ScreenWindow -1 1 " + -f + ' ' + f + '\n');
            bufferedWriter.write("Transform [" + matrix4d.m00 + ' ' + matrix4d.m10 + ' ' + matrix4d.m20 + ' ' + matrix4d.m30 + ' ' + matrix4d.m01 + ' ' + matrix4d.m11 + ' ' + matrix4d.m21 + ' ' + matrix4d.m31 + ' ' + matrix4d.m02 + ' ' + matrix4d.m12 + ' ' + matrix4d.m22 + ' ' + matrix4d.m32 + ' ' + matrix4d.m03 + ' ' + matrix4d.m13 + ' ' + matrix4d.m23 + ' ' + matrix4d.m33 + "]\n");
            bufferedWriter.write("Orientation \"rh\"\n");
            bufferedWriter.write("\n");
            bufferedWriter.write("WorldBegin\n");
            bufferedWriter.write("\n");
            int n = 0;
            int n2 = list2.size();
            while (n < n2) {
                object = (AnimLight)list2.get(n);
                if (((AnimLight)object).isActive()) {
                    bufferedWriter.write(RibRenderer4.light((AnimLight)object));
                }
                ++n;
            }
            bufferedWriter.write("\n");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AnimModel animModel = (AnimModel)iterator.next();
                object = animModel.getModel();
                Matrix4d matrix4d2 = animModel.getTransform();
                bufferedWriter.write("TransformBegin\n");
                bufferedWriter.write("Transform [" + matrix4d2.m00 + ' ' + matrix4d2.m10 + ' ' + matrix4d2.m20 + ' ' + matrix4d2.m30 + ' ' + matrix4d2.m01 + ' ' + matrix4d2.m11 + ' ' + matrix4d2.m21 + ' ' + matrix4d2.m31 + ' ' + matrix4d2.m02 + ' ' + matrix4d2.m12 + ' ' + matrix4d2.m22 + ' ' + matrix4d2.m32 + ' ' + matrix4d2.m03 + ' ' + matrix4d2.m13 + ' ' + matrix4d2.m23 + ' ' + matrix4d2.m33 + "]\n");
                bufferedWriter.write("\n");
                this.writeModel((Model)object, matrix4d2, animModel.getRenderString("renderman", ""), animModel.getSubdivisionOffset(), bufferedWriter);
                bufferedWriter.write("TransformEnd\n\n");
            }
            bufferedWriter.write("WorldEnd\n");
            bufferedWriter.write("FrameEnd\n");
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    public void writeModel(Model model, Matrix4d matrix4d, String string, int n, BufferedWriter bufferedWriter) throws IOException {
        if (JPatchSettings.getInstance().ribSettings.iOutputMode != 3) {
            int n2 = JPatchSettings.getInstance().ribSettings.iSubdivMode + n;
            if (n2 < 1) {
                n2 = 1;
            }
            if (n2 > 5) {
                n2 = 5;
            }
            boolean bl = false;
            if (JPatchSettings.getInstance().ribSettings.iOutputMode != 2) {
                bl = true;
            }
            this.patchTesselator.tesselate(model, n2, null, bl);
            Iterator iterator = model.getMaterialList().iterator();
            while (iterator.hasNext()) {
                JPatchMaterial jPatchMaterial = (JPatchMaterial)iterator.next();
                PatchTesselator3.Vertex[] vertexArray = this.patchTesselator.getPerMaterialVertexArray(jPatchMaterial);
                if (vertexArray.length <= 0) continue;
                bufferedWriter.write(string);
                bufferedWriter.write("AttributeBegin\n");
                bufferedWriter.write(AbstractRenderer.shader(jPatchMaterial.getMaterialProperties(), jPatchMaterial.getRenderString("renderman", "")));
                switch (JPatchSettings.getInstance().ribSettings.iOutputMode) {
                    case 0: {
                        bufferedWriter.write("PointsPolygons [");
                        int[][] nArray = this.patchTesselator.getPerMaterialTriangleArray();
                        int n3 = 0;
                        while (n3 < nArray.length) {
                            bufferedWriter.write("3 ");
                            ++n3;
                        }
                        bufferedWriter.write("]\n[");
                        n3 = 0;
                        while (n3 < nArray.length) {
                            bufferedWriter.write("" + nArray[n3][0] + ' ' + nArray[n3][1] + ' ' + nArray[n3][2] + ' ');
                            ++n3;
                        }
                        bufferedWriter.write("]\n\"P\" [");
                        n3 = 0;
                        while (n3 < vertexArray.length) {
                            bufferedWriter.write("" + vertexArray[n3].p.x + ' ' + vertexArray[n3].p.y + ' ' + vertexArray[n3].p.z + ' ');
                            ++n3;
                        }
                        bufferedWriter.write("]\n\"vertex point Pref\" [");
                        n3 = 0;
                        while (n3 < vertexArray.length) {
                            bufferedWriter.write("" + vertexArray[n3].r.x + ' ' + vertexArray[n3].r.y + ' ' + vertexArray[n3].r.z + ' ');
                            ++n3;
                        }
                        bufferedWriter.write("]\n\"N\" [");
                        n3 = 0;
                        while (n3 < vertexArray.length) {
                            bufferedWriter.write("" + vertexArray[n3].n.x + ' ' + vertexArray[n3].n.y + ' ' + vertexArray[n3].n.z + ' ');
                            ++n3;
                        }
                        bufferedWriter.write("]\n");
                        break;
                    }
                    case 1: {
                        int n4;
                        bufferedWriter.write("PointsPolygons [");
                        int[][] nArray = this.patchTesselator.getPerMaterialQuadArray();
                        int n3 = 0;
                        while (n3 < nArray.length) {
                            bufferedWriter.write("" + nArray[n3].length + ' ');
                            ++n3;
                        }
                        bufferedWriter.write("]\n[");
                        n3 = 0;
                        while (n3 < nArray.length) {
                            n4 = 0;
                            while (n4 < nArray[n3].length) {
                                bufferedWriter.write("" + nArray[n3][n4] + ' ');
                                ++n4;
                            }
                            ++n3;
                        }
                        bufferedWriter.write("]\n\"P\" [");
                        n3 = 0;
                        while (n3 < vertexArray.length) {
                            bufferedWriter.write("" + vertexArray[n3].p.x + ' ' + vertexArray[n3].p.y + ' ' + vertexArray[n3].p.z + ' ');
                            ++n3;
                        }
                        bufferedWriter.write("]\n\"vertex point Pref\" [");
                        n3 = 0;
                        while (n3 < vertexArray.length) {
                            bufferedWriter.write("" + vertexArray[n3].r.x + ' ' + vertexArray[n3].r.y + ' ' + vertexArray[n3].r.z + ' ');
                            ++n3;
                        }
                        bufferedWriter.write("]\n\"N\" [");
                        n3 = 0;
                        while (n3 < vertexArray.length) {
                            bufferedWriter.write("" + vertexArray[n3].n.x + ' ' + vertexArray[n3].n.y + ' ' + vertexArray[n3].n.z + ' ');
                            ++n3;
                        }
                        bufferedWriter.write("]\n");
                        break;
                    }
                    case 2: {
                        int n4;
                        bufferedWriter.write("SubdivisionMesh \"catmull-clark\" [ ");
                        int[][] nArray = this.patchTesselator.getPerMaterialQuadArray();
                        int n3 = 0;
                        while (n3 < nArray.length) {
                            bufferedWriter.write("" + nArray[n3].length + ' ');
                            ++n3;
                        }
                        bufferedWriter.write("]\n[");
                        n3 = 0;
                        while (n3 < nArray.length) {
                            n4 = 0;
                            while (n4 < nArray[n3].length) {
                                bufferedWriter.write("" + nArray[n3][n4] + ' ');
                                ++n4;
                            }
                            ++n3;
                        }
                        bufferedWriter.write("]\n[\"interpolateboundary\"] [0 0] [] [] \"P\" [");
                        n3 = 0;
                        while (n3 < vertexArray.length) {
                            bufferedWriter.write("" + vertexArray[n3].p.x + ' ' + vertexArray[n3].p.y + ' ' + vertexArray[n3].p.z + ' ');
                            ++n3;
                        }
                        bufferedWriter.write("]\n\"vertex point Pref\" [");
                        n3 = 0;
                        while (n3 < vertexArray.length) {
                            bufferedWriter.write("" + vertexArray[n3].r.x + ' ' + vertexArray[n3].r.y + ' ' + vertexArray[n3].r.z + ' ');
                            ++n3;
                        }
                        bufferedWriter.write("]\n");
                        break;
                    }
                }
                bufferedWriter.write("AttributeEnd\n\n");
            }
        } else {
            bufferedWriter.write("Basis \"bezier\" 3 \"bezier\" 3\n");
            Iterator iterator = model.getMaterialList().iterator();
            while (iterator.hasNext()) {
                JPatchMaterial jPatchMaterial = (JPatchMaterial)iterator.next();
                boolean bl = false;
                Patch patch = model.getFirstPatch();
                while (patch != null) {
                    if (patch.getMaterial() == jPatchMaterial) {
                        if (!bl) {
                            bufferedWriter.write(string);
                            bufferedWriter.write("AttributeBegin\n");
                            bufferedWriter.write(AbstractRenderer.shader(jPatchMaterial.getMaterialProperties(), jPatchMaterial.getRenderString("renderman", "")));
                            bl = true;
                        }
                        Point3f[][] point3fArray = patch.bicubicPatches();
                        Point3f[][] point3fArray2 = patch.bicubicReferencePatches();
                        int n5 = 0;
                        while (n5 < point3fArray.length) {
                            Point3f[] point3fArray3 = point3fArray[n5];
                            bufferedWriter.write("Patch \"bicubic\" \"P\" [");
                            String string2 = "";
                            int n6 = 0;
                            while (n6 < 16) {
                                string2 = string2 + point3fArray3[n6].x + ' ' + point3fArray3[n6].y + ' ' + point3fArray3[n6].z;
                                if (n6 != 15) {
                                    string2 = string2 + ' ';
                                }
                                ++n6;
                            }
                            bufferedWriter.write(string2 + "]\n");
                            if (point3fArray2 != null) {
                                point3fArray3 = point3fArray2[n5];
                                bufferedWriter.write("\"vertex point Pref\" [");
                                string2 = "";
                                n6 = 0;
                                while (n6 < 16) {
                                    string2 = string2 + point3fArray3[n6].x + ' ' + point3fArray3[n6].y + ' ' + point3fArray3[n6].z;
                                    if (n6 != 15) {
                                        string2 = string2 + ' ';
                                    }
                                    ++n6;
                                }
                                bufferedWriter.write(string2 + "]\n");
                            }
                            ++n5;
                        }
                    }
                    patch = patch.getNext();
                }
                if (!bl) continue;
                bufferedWriter.write("AttributeEnd\n");
            }
        }
    }

    private static final String toRibVector(Tuple3d tuple3d) {
        return "[" + tuple3d.x + ' ' + tuple3d.y + ' ' + tuple3d.z + ']';
    }

    private static final String toRibVector(Tuple3f tuple3f) {
        return "[" + tuple3f.x + ' ' + tuple3f.y + ' ' + tuple3f.z + ']';
    }

    public static String light(AnimLight animLight) {
        String string = animLight.getRenderString("renderman", "");
        string = AbstractRenderer.light(animLight, string);
        string = string.replaceAll("\\$position", RibRenderer4.toRibVector(animLight.getPosition()));
        string = string.replaceAll("\\$color", RibRenderer4.toRibVector(animLight.getColor()));
        return string;
    }

    private final /* synthetic */ void this() {
        this.patchTesselator = new PatchTesselator3();
    }

    public RibRenderer4() {
        this.this();
    }
}

