/*
 * Decompiled with CFR 0.152.
 */
package jpatch.renderer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import jpatch.boundary.Animator;
import jpatch.boundary.JPatchSettings;
import jpatch.boundary.JPatchTreeLeaf;
import jpatch.entity.AnimLight;
import jpatch.entity.AnimModel;
import jpatch.entity.AnimObject;
import jpatch.entity.Camera;
import jpatch.entity.JPatchMaterial;
import jpatch.entity.Model;
import jpatch.entity.Patch;
import jpatch.renderer.AbstractRenderer;
import jpatch.renderer.PatchTesselator3;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PovrayRenderer3 {
    private BufferedWriter file;
    private PatchTesselator3 patchTesselator;

    public void writeFrame(List list, Camera camera, List list2, String string, BufferedWriter bufferedWriter) throws IOException {
        Object object;
        JPatchSettings jPatchSettings = JPatchSettings.getInstance();
        bufferedWriter.write("/*\n");
        bufferedWriter.write(" * JPatch animator POV-Ray scene file\n");
        bufferedWriter.write(" */\n");
        bufferedWriter.write("\n");
        bufferedWriter.write("/*\n");
        bufferedWriter.write(" * Frame number\n");
        bufferedWriter.write(" */\n");
        bufferedWriter.write("#declare jpatchFrame = " + Animator.getInstance().getPosition() + ";\n\n");
        bufferedWriter.write("/*\n");
        bufferedWriter.write(" * Include block\n");
        bufferedWriter.write(" */\n");
        bufferedWriter.write("\n");
        bufferedWriter.write(string);
        bufferedWriter.write("\n\n");
        bufferedWriter.write("/*\n");
        bufferedWriter.write(" * Background\n");
        bufferedWriter.write(" */\n");
        bufferedWriter.write("\n");
        bufferedWriter.write("background {\n");
        float[] fArray = jPatchSettings.cBackgroundColor.getRGBColorComponents(new float[3]);
        bufferedWriter.write("\tcolor rgb <" + fArray[0] + ',' + fArray[1] + ',' + fArray[2] + ">\n");
        bufferedWriter.write("}\n\n");
        bufferedWriter.write("/*\n");
        bufferedWriter.write(" * Camera " + camera.getName() + '\n');
        bufferedWriter.write(" */\n");
        bufferedWriter.write("\n");
        bufferedWriter.write("camera {\n");
        Matrix4d matrix4d = camera.getTransform();
        bufferedWriter.write("\tperspective\n");
        bufferedWriter.write("\tright x * " + JPatchSettings.getInstance().fRenderAspectWidth + '\n');
        bufferedWriter.write("\tup y * " + JPatchSettings.getInstance().fRenderAspectHeight + '\n');
        bufferedWriter.write("\tmatrix <" + matrix4d.m00 + ", " + matrix4d.m10 + ", " + matrix4d.m20 + ", " + matrix4d.m01 + ", " + matrix4d.m11 + ", " + matrix4d.m21 + ", " + matrix4d.m02 + ", " + matrix4d.m12 + ", " + matrix4d.m22 + ", " + matrix4d.m03 + ", " + matrix4d.m13 + ", " + matrix4d.m23 + ">\n");
        bufferedWriter.write("\tangle " + camera.getFieldOfView() + '\n');
        bufferedWriter.write("}\n");
        bufferedWriter.write("\n");
        int n = 0;
        int n2 = list2.size();
        while (n < n2) {
            object = (AnimLight)list2.get(n);
            if (((AnimLight)object).isActive()) {
                bufferedWriter.write("/*\n");
                bufferedWriter.write(" * Lightsource " + ((AnimObject)object).getName() + '\n');
                bufferedWriter.write(" */\n");
                bufferedWriter.write("\n");
                bufferedWriter.write(PovrayRenderer3.light((AnimLight)object));
            }
            ++n;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AnimModel animModel = (AnimModel)iterator.next();
            object = animModel.getModel();
            bufferedWriter.write("/*\n");
            bufferedWriter.write(" * Model " + ((JPatchTreeLeaf)object).getName() + '\n');
            bufferedWriter.write(" */\n");
            bufferedWriter.write("\n");
            this.writeModel((Model)object, animModel.getTransform(), animModel.getRenderString("povray", ""), animModel.getSubdivisionOffset(), bufferedWriter);
        }
    }

    public void writeModel(Model model, Matrix4d matrix4d, String string, int n, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("union {\n");
        bufferedWriter.write("\t" + string + '\n');
        if (JPatchSettings.getInstance().povraySettings.iOutputMode == 0) {
            int n2 = JPatchSettings.getInstance().povraySettings.iSubdivMode + n;
            if (n2 < 1) {
                n2 = 1;
            }
            if (n2 > 5) {
                n2 = 5;
            }
            this.patchTesselator.tesselate(model, n2, null, true);
        }
        Iterator iterator = model.getMaterialList().iterator();
        block4: while (iterator.hasNext()) {
            JPatchMaterial jPatchMaterial = (JPatchMaterial)iterator.next();
            switch (JPatchSettings.getInstance().povraySettings.iOutputMode) {
                case 0: {
                    PatchTesselator3.Vertex[] vertexArray = this.patchTesselator.getPerMaterialVertexArray(jPatchMaterial);
                    if (vertexArray.length <= 0) continue block4;
                    bufferedWriter.write("\t/*\n");
                    bufferedWriter.write("\t * Material " + jPatchMaterial.getName() + '\n');
                    bufferedWriter.write("\t */\n");
                    bufferedWriter.write("\n");
                    bufferedWriter.write("\tmesh2 {\n");
                    bufferedWriter.write("\t\tvertex_vectors {\n");
                    bufferedWriter.write("\t\t\t" + vertexArray.length + ",\n");
                    int n3 = 0;
                    while (n3 < vertexArray.length) {
                        bufferedWriter.write("\t\t\t" + PovrayRenderer3.toPovVector(vertexArray[n3].p) + ",\n");
                        ++n3;
                    }
                    bufferedWriter.write("\t\t}\n");
                    bufferedWriter.write("\t\tnormal_vectors {\n");
                    bufferedWriter.write("\t\t\t" + vertexArray.length + ",\n");
                    n3 = 0;
                    while (n3 < vertexArray.length) {
                        bufferedWriter.write("\t\t\t" + PovrayRenderer3.toPovVector(vertexArray[n3].n) + ",\n");
                        ++n3;
                    }
                    bufferedWriter.write("\t\t}\n");
                    int[][] nArray = this.patchTesselator.getPerMaterialTriangleArray();
                    bufferedWriter.write("\t\tface_indices {\n");
                    bufferedWriter.write("\t\t\t" + nArray.length + ",\n");
                    int n4 = 0;
                    while (n4 < nArray.length) {
                        bufferedWriter.write("\t\t\t<" + nArray[n4][0] + ',' + nArray[n4][1] + ',' + nArray[n4][2] + ">,\n");
                        ++n4;
                    }
                    bufferedWriter.write("\t\t}\n");
                    bufferedWriter.write(AbstractRenderer.shader(jPatchMaterial.getMaterialProperties(), jPatchMaterial.getRenderString("povray", "")));
                    bufferedWriter.write("}\n");
                    break;
                }
                case 1: {
                    boolean bl = false;
                    int n5 = JPatchSettings.getInstance().povraySettings.iSubdivMode;
                    Patch patch = model.getFirstPatch();
                    while (patch != null) {
                        if (patch.getMaterial() == jPatchMaterial) {
                            if (!bl) {
                                bufferedWriter.write("\t/*\n");
                                bufferedWriter.write("\t * Material " + jPatchMaterial.getName() + '\n');
                                bufferedWriter.write("\t */\n");
                                bufferedWriter.write("\t \n");
                                bufferedWriter.write("\tunion {\n");
                                bl = true;
                            }
                            Point3f[][] point3fArray = patch.bicubicPatches();
                            int n6 = 0;
                            while (n6 < point3fArray.length) {
                                Point3f[] point3fArray2 = point3fArray[n6];
                                bufferedWriter.write("\t\tbicubic_patch { type 1 flatness 0 u_steps " + n5 + " v_steps " + n5 + ' ');
                                String string2 = "";
                                int n7 = 0;
                                while (n7 < 16) {
                                    string2 = string2 + '<' + point3fArray2[n7].x + ',' + point3fArray2[n7].y + ',' + point3fArray2[n7].z + '>';
                                    if (n7 != 15) {
                                        string2 = string2 + ',';
                                    }
                                    ++n7;
                                }
                                bufferedWriter.write(string2 + " }\n");
                                ++n6;
                            }
                        }
                        patch = patch.getNext();
                    }
                    if (!bl) continue block4;
                    bufferedWriter.write(AbstractRenderer.shader(jPatchMaterial.getMaterialProperties(), jPatchMaterial.getRenderString("povray", "")));
                    bufferedWriter.write("}\n");
                    break;
                }
            }
        }
        if (matrix4d != null) {
            bufferedWriter.write("\tmatrix <" + matrix4d.m00 + ", " + matrix4d.m10 + ", " + matrix4d.m20 + ", " + matrix4d.m01 + ", " + matrix4d.m11 + ", " + matrix4d.m21 + ", " + matrix4d.m02 + ", " + matrix4d.m12 + ", " + matrix4d.m22 + ", " + matrix4d.m03 + ", " + matrix4d.m13 + ", " + matrix4d.m23 + ">\n");
        }
        bufferedWriter.write("}\n");
    }

    private static final String toPovVector(Tuple3d tuple3d) {
        return "<" + tuple3d.x + ", " + tuple3d.y + ", " + tuple3d.z + '>';
    }

    private static final String toPovVector(Tuple3f tuple3f) {
        return "<" + tuple3f.x + ", " + tuple3f.y + ", " + tuple3f.z + '>';
    }

    public static String light(AnimLight animLight) {
        String string = animLight.getRenderString("povray", "");
        string = AbstractRenderer.light(animLight, string);
        string = string.replaceAll("\\$position", PovrayRenderer3.toPovVector(animLight.getPosition()));
        string = string.replaceAll("\\$color", PovrayRenderer3.toPovVector(animLight.getColor()));
        return string;
    }

    private final /* synthetic */ void this() {
        this.patchTesselator = new PatchTesselator3();
    }

    public PovrayRenderer3() {
        this.this();
    }
}

