/*
 * Decompiled with CFR 0.152.
 */
package jpatch.renderer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import jpatch.entity.ControlPoint;
import jpatch.entity.JPatchMaterial;
import jpatch.entity.Model;
import jpatch.entity.Patch;
import jpatch.renderer.HashPatchSubdivision;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PatchTesselator3
implements HashPatchSubdivision.QuadDrain {
    private static final int GRID_SIZE = 1000;
    private static final int G2 = 1000000;
    private static final int G3 = 1000000000;
    private static final Vector3f v3_1 = new Vector3f();
    private static final Vector3f v3_2 = new Vector3f();
    static final double EPSILON = (double)1.0E-4f;
    private static boolean bExportNormals;
    private HashPatchSubdivision hashPatchSubdivision;
    private Model model;
    private JPatchMaterial material;
    private ArrayList matTriangleList;
    private ArrayList matQuadList;
    private ArrayList listAveragedNormals;
    private ArrayList listVertices;
    private Matrix4d matrix;
    private HashMap mapVertices;
    private ArrayList listQuads;
    private int iVertexNumber;

    public void tesselate(Model model, int n, Matrix4d matrix4d, boolean bl) {
        Point3f[] point3fArray;
        Point3f[] point3fArray2;
        Object object;
        bExportNormals = bl;
        this.matrix = matrix4d;
        this.hashPatchSubdivision = new HashPatchSubdivision(0.0f, n, this);
        model.computePatches();
        model.setReferenceGeometry();
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f[] vector3fArray = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f(), new Vector3f(), new Vector3f()};
        this.mapVertices.clear();
        this.listVertices.clear();
        this.listQuads.clear();
        this.listAveragedNormals.clear();
        this.iVertexNumber = 0;
        Iterator iterator = model.getMaterialList().iterator();
        while (iterator.hasNext()) {
            this.material = (JPatchMaterial)iterator.next();
            object = model.getFirstPatch();
            while (object != null) {
                if (((Patch)object).getMaterial() == this.material) {
                    point3fArray2 = ((Patch)object).coonsPatch();
                    point3fArray = ((Patch)object).referenceCoonsPatch();
                    ControlPoint[] controlPointArray = ((Patch)object).getControlPoints();
                    Point3d[][] point3dArray = new Point3d[((Patch)object).getType()][];
                    Point3d[][] point3dArray2 = new Point3d[((Patch)object).getType()][];
                    Vector3f[][] vector3fArray2 = new Vector3f[((Patch)object).getType()][];
                    int n2 = 0;
                    int n3 = ((Patch)object).getType();
                    int n4 = point3fArray2.length;
                    int n5 = n3 * 2;
                    while (n2 < n3) {
                        Vector3f vector3f3;
                        Tuple3f tuple3f;
                        Tuple3f tuple3f2;
                        Tuple3f tuple3f3;
                        Point3f point3f;
                        Point3f point3f2;
                        Point3f point3f3;
                        Point3f point3f4;
                        Object object2;
                        ControlPoint controlPoint;
                        Object object3;
                        Vector3f vector3f4;
                        Tuple3f tuple3f4;
                        Tuple3f tuple3f5;
                        Object object4;
                        boolean bl2 = false;
                        int n6 = n2 * 2;
                        ControlPoint controlPoint2 = null;
                        ControlPoint controlPoint3 = controlPointArray[n6].getStart().getParentHook();
                        if (controlPoint3 != null) {
                            if (controlPointArray[(n6 + n5 - 1) % n5].isTargetHook()) {
                                controlPoint2 = controlPointArray[(n6 + n5 - 1) % n5];
                            }
                            if (controlPointArray[(n6 + 2) % n5].isTargetHook()) {
                                controlPoint2 = controlPointArray[(n6 + 2) % n5];
                            }
                            object4 = new Vector3f();
                            tuple3f5 = controlPoint2.getRefPosition();
                            if (controlPoint2.getNext() != null) {
                                ((Tuple3f)object4).sub(controlPoint2.getNext().getRefPosition(), tuple3f5);
                            } else {
                                ((Tuple3f)object4).sub(controlPoint2.getPrev().getRefPosition(), tuple3f5);
                            }
                            tuple3f4 = new Vector3f((Vector3f)object4);
                            vector3f4 = new Vector3f((Vector3f)object4);
                            controlPoint2.computeTargetHookReferenceBorderTangents((Vector3f)object4, (Vector3f)tuple3f4, vector3f4);
                            object3 = controlPoint2.getHead().getStart().getParentHook();
                            controlPoint = ((ControlPoint)object3).getNext();
                            object2 = new Point3f(((ControlPoint)object3).getPosition());
                            point3f4 = new Point3f(((ControlPoint)object3).getOutTangent());
                            point3f3 = new Point3f(controlPoint.getInTangent());
                            point3f2 = new Point3f(controlPoint.getPosition());
                            point3dArray[n2] = this.hashPatchSubdivision.subdivCurve(new Point3d((Point3f)object2), new Point3d(point3f4), new Point3d(point3f3), new Point3d(point3f2));
                            point3f = new Point3f(((ControlPoint)object3).getRefPosition());
                            tuple3f3 = new Point3f(((ControlPoint)object3).getRefOutTangent());
                            tuple3f2 = new Point3f(controlPoint.getRefInTangent());
                            tuple3f = new Point3f(controlPoint.getRefPosition());
                            point3dArray2[n2] = this.hashPatchSubdivision.subdivCurve(new Point3d(point3f), new Point3d((Point3f)tuple3f3), new Point3d((Point3f)tuple3f2), new Point3d((Point3f)tuple3f));
                            vector3f3 = new Vector3f();
                            Vector3f vector3f5 = new Vector3f();
                            Vector3f vector3f6 = new Vector3f();
                            vector3f3.sub(tuple3f3, point3f);
                            vector3f5.cross(vector3f3, (Vector3f)tuple3f4);
                            vector3f5.normalize();
                            vector3f3.sub(tuple3f, tuple3f2);
                            vector3f6.cross(vector3f3, vector3f4);
                            vector3f6.normalize();
                            ControlPoint controlPoint4 = controlPoint2.getHead();
                            int n7 = 0;
                            while (n7 < controlPointArray.length) {
                                if (controlPointArray[n7] == controlPoint4) {
                                    int n8 = (n7 + 1) % controlPointArray.length;
                                    int n9 = (n7 + controlPointArray.length - 1) % controlPointArray.length;
                                    boolean bl3 = false;
                                    if (controlPointArray[n7].getNext() == controlPointArray[n8] || controlPointArray[n7].getPrev() == controlPointArray[n9]) {
                                        bl3 = true;
                                    }
                                    bl2 = bl3;
                                    break;
                                }
                                ++n7;
                            }
                            if (!bl2) {
                                vector3f5.scale(-1.0f);
                                vector3f6.scale(-1.0f);
                            }
                            vector3fArray2[n2] = this.hashPatchSubdivision.interpolateNormals(vector3f5, vector3f6);
                            controlPoint2 = null;
                        }
                        if (controlPointArray[n6].isTargetHook()) {
                            controlPoint2 = controlPointArray[n6];
                        }
                        if (controlPointArray[(n6 + n5 - 1) % n5].isTargetHook()) {
                            controlPoint2 = controlPointArray[(n6 + n5 - 1) % n5];
                        }
                        if (controlPoint2 == null) {
                            int n10 = n2 * 3;
                            if (point3fArray[n10].equals(point3fArray[(n10 + 3) % n4])) {
                                vector3f.sub(point3fArray[(n10 + 4) % n4], point3fArray[n10]);
                            } else {
                                vector3f.sub(point3fArray[(n10 + 1) % n4], point3fArray[n10]);
                            }
                            if (point3fArray[n10].equals(point3fArray[(n10 + n4 - 3) % n4])) {
                                vector3f2.sub(point3fArray[(n10 + n4 - 4) % n4], point3fArray[n10]);
                            } else {
                                vector3f2.sub(point3fArray[(n10 + n4 - 1) % n4], point3fArray[n10]);
                            }
                            vector3fArray[n2].cross(vector3f, vector3f2);
                            vector3fArray[n2].normalize();
                        } else {
                            object4 = controlPoint2.getHead();
                            int n11 = 0;
                            while (n11 < controlPointArray.length) {
                                if (controlPointArray[n11] == object4) {
                                    int n12 = (n11 + 1) % controlPointArray.length;
                                    int n13 = (n11 + controlPointArray.length - 1) % controlPointArray.length;
                                    boolean bl4 = false;
                                    if (controlPointArray[n11].getNext() == controlPointArray[n12] || controlPointArray[n11].getPrev() == controlPointArray[n13]) {
                                        bl4 = true;
                                    }
                                    bl2 = bl4;
                                    break;
                                }
                                ++n11;
                            }
                            tuple3f5 = new Vector3f();
                            tuple3f4 = controlPoint2.getRefPosition();
                            if (controlPoint2.getNext() != null) {
                                tuple3f5.sub(controlPoint2.getNext().getRefPosition(), tuple3f4);
                            } else {
                                tuple3f5.sub(controlPoint2.getPrev().getRefPosition(), tuple3f4);
                            }
                            vector3f4 = new Vector3f((Vector3f)tuple3f5);
                            object3 = new Vector3f((Vector3f)tuple3f5);
                            controlPoint2.computeTargetHookReferenceBorderTangents((Vector3f)tuple3f5, vector3f4, (Vector3f)object3);
                            controlPoint = controlPoint2.getHead().getStart().getParentHook();
                            object2 = controlPoint.getNext();
                            point3f4 = controlPoint.getRefPosition();
                            point3f3 = controlPoint.getRefOutTangent();
                            point3f2 = ((ControlPoint)object2).getRefInTangent();
                            point3f = ((ControlPoint)object2).getRefPosition();
                            tuple3f3 = new Vector3f();
                            tuple3f2 = new Vector3f();
                            tuple3f = new Vector3f();
                            tuple3f3.sub(point3f3, point3f4);
                            tuple3f2.cross((Vector3f)tuple3f3, vector3f4);
                            tuple3f2.normalize();
                            tuple3f3.sub(point3f, point3f2);
                            tuple3f.cross((Vector3f)tuple3f3, (Vector3f)object3);
                            tuple3f.normalize();
                            vector3f3 = this.hashPatchSubdivision.interpolateNormal((Vector3f)tuple3f2, (Vector3f)tuple3f);
                            float f = controlPoint2.getHead().getHookPos();
                            if (f == 0.5f) {
                                tuple3f3.set(vector3f3);
                            } else {
                                tuple3f3 = f == 0.25f ? this.hashPatchSubdivision.interpolateNormal((Vector3f)tuple3f2, vector3f3) : this.hashPatchSubdivision.interpolateNormal(vector3f3, (Vector3f)tuple3f);
                            }
                            ((Vector3f)tuple3f3).normalize();
                            vector3fArray[n2].set(tuple3f3);
                        }
                        ++n2;
                    }
                    this.hashPatchSubdivision.subdivHashPatch(point3fArray2, point3fArray, vector3fArray, point3dArray, point3dArray2, vector3fArray2);
                }
                object = ((Patch)object).getNext();
            }
        }
        if (bExportNormals) {
            iterator = this.listAveragedNormals.iterator();
            object = this.listVertices.iterator();
            while (object.hasNext()) {
                point3fArray2 = (Point3f[])object.next();
                point3fArray = (Point3f[])iterator.next();
                point3fArray.normalize();
                if (!(Float.isNaN(point3fArray.x) || Float.isNaN(point3fArray.y) || Float.isNaN(point3fArray.z))) {
                    point3fArray2.n = point3fArray;
                    continue;
                }
                point3fArray2.n.set(0.0f, 0.0f, 0.0f);
                System.out.println("NaN! at " + point3fArray2.p);
            }
        }
    }

    public Vertex[] getVertexArray() {
        return this.listVertices.toArray(new Vertex[0]);
    }

    public Vertex[] getPerMaterialVertexArray(JPatchMaterial jPatchMaterial) {
        Object object;
        int[] nArray = new int[this.listVertices.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n++] = -1;
        }
        this.matTriangleList.clear();
        this.matQuadList.clear();
        n = 0;
        Vertex[] vertexArray = this.listQuads.iterator();
        while (vertexArray.hasNext()) {
            int[] nArray2;
            Quad quad = (Quad)vertexArray.next();
            if (quad.material != jPatchMaterial) continue;
            if (nArray[quad.i0] == -1) {
                nArray[quad.i0] = n++;
            }
            if (nArray[quad.i1] == -1) {
                nArray[quad.i1] = n++;
            }
            if (nArray[quad.i2] == -1) {
                nArray[quad.i2] = n++;
            }
            if (nArray[quad.i3] == -1) {
                nArray[quad.i3] = n++;
            }
            if (!quad.isTriangle()) {
                nArray2 = quad.getTriangle1();
                this.matTriangleList.add(new int[]{nArray[nArray2[0]], nArray[nArray2[1]], nArray[nArray2[2]]});
                nArray2 = quad.getTriangle2();
                this.matTriangleList.add(new int[]{nArray[nArray2[0]], nArray[nArray2[1]], nArray[nArray2[2]]});
            } else {
                nArray2 = quad.getQuad();
                this.matTriangleList.add(new int[]{nArray[nArray2[0]], nArray[nArray2[1]], nArray[nArray2[2]]});
            }
            nArray2 = quad.getQuad();
            object = new int[nArray2.length];
            int n2 = 0;
            while (n2 < nArray2.length) {
                object[n2] = nArray[nArray2[n2++]];
            }
            this.matQuadList.add(object);
        }
        vertexArray = new Vertex[n];
        int n3 = 0;
        int n4 = this.listVertices.size();
        while (n3 < n4) {
            if (nArray[n3] != -1) {
                object = (Vertex)this.listVertices.get(n3);
                vertexArray[nArray[n3]] = new Vertex(((Vertex)object).p, ((Vertex)object).r, ((Vertex)object).n);
            }
            ++n3;
        }
        return vertexArray;
    }

    public int[][] getPerMaterialTriangleArray() {
        return (int[][])this.matTriangleList.toArray((T[])new int[0][0]);
    }

    public int[][] getPerMaterialQuadArray() {
        return (int[][])this.matQuadList.toArray((T[])new int[0][0]);
    }

    public int[][] getMaterialTriangleArray(JPatchMaterial jPatchMaterial) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        Iterator iterator = this.listQuads.iterator();
        while (iterator.hasNext()) {
            Quad quad = (Quad)iterator.next();
            if (quad.material != jPatchMaterial) continue;
            if (!quad.isTriangle()) {
                arrayList.add(quad.getTriangle1());
                arrayList.add(quad.getTriangle2());
                continue;
            }
            arrayList.add(quad.getQuad());
        }
        return (int[][])arrayList.toArray((T[])new int[0][0]);
    }

    public int[][] getMaterialQuadArray(JPatchMaterial jPatchMaterial) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        Iterator iterator = this.listQuads.iterator();
        while (iterator.hasNext()) {
            Quad quad = (Quad)iterator.next();
            if (quad.material != jPatchMaterial) continue;
            arrayList.add(quad.getQuad());
        }
        return (int[][])arrayList.toArray((T[])new int[0][0]);
    }

    public void addQuad(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, Point3d point3d5, Point3d point3d6, Point3d point3d7, Point3d point3d8, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        if (this.matrix != null) {
            this.matrix.transform(point3d);
            this.matrix.transform(point3d2);
            this.matrix.transform(point3d3);
            this.matrix.transform(point3d4);
            this.matrix.transform(point3d5);
            this.matrix.transform(point3d6);
            this.matrix.transform(point3d7);
            this.matrix.transform(point3d8);
            this.matrix.transform(vector3f);
            this.matrix.transform(vector3f2);
            this.matrix.transform(vector3f3);
            this.matrix.transform(vector3f4);
        }
        Vertex vertex = new Vertex(point3d, point3d5, vector3f);
        Vertex vertex2 = new Vertex(point3d2, point3d6, vector3f2);
        Vertex vertex3 = new Vertex(point3d3, point3d7, vector3f3);
        Vertex vertex4 = new Vertex(point3d4, point3d8, vector3f4);
        int n = this.getVertexNumber(vertex);
        int n2 = this.getVertexNumber(vertex2);
        int n3 = this.getVertexNumber(vertex3);
        int n4 = this.getVertexNumber(vertex4);
        if (n != n3 && n2 != n4) {
            if (bExportNormals) {
                Vector3f vector3f5 = (Vector3f)this.listAveragedNormals.get(n);
                Vector3f vector3f6 = (Vector3f)this.listAveragedNormals.get(n2);
                Vector3f vector3f7 = (Vector3f)this.listAveragedNormals.get(n3);
                Vector3f vector3f8 = (Vector3f)this.listAveragedNormals.get(n4);
                if (n == n2) {
                    this.addNormal(vector3f5, this.getCornerNormal(vertex.p, vertex3.p, vertex4.p));
                    this.addNormal(vector3f7, this.getCornerNormal(vertex3.p, vertex4.p, vertex2.p));
                    this.addNormal(vector3f8, this.getCornerNormal(vertex4.p, vertex.p, vertex3.p));
                } else if (n2 == n3) {
                    this.addNormal(vector3f5, this.getCornerNormal(vertex.p, vertex2.p, vertex4.p));
                    this.addNormal(vector3f6, this.getCornerNormal(vertex2.p, vertex4.p, vertex.p));
                    this.addNormal(vector3f8, this.getCornerNormal(vertex4.p, vertex.p, vertex3.p));
                } else if (n3 == n4) {
                    this.addNormal(vector3f5, this.getCornerNormal(vertex.p, vertex2.p, vertex4.p));
                    this.addNormal(vector3f6, this.getCornerNormal(vertex2.p, vertex3.p, vertex.p));
                    this.addNormal(vector3f7, this.getCornerNormal(vertex3.p, vertex.p, vertex2.p));
                } else if (n4 == n) {
                    this.addNormal(vector3f6, this.getCornerNormal(vertex2.p, vertex3.p, vertex.p));
                    this.addNormal(vector3f7, this.getCornerNormal(vertex3.p, vertex.p, vertex2.p));
                    this.addNormal(vector3f8, this.getCornerNormal(vertex4.p, vertex2.p, vertex3.p));
                } else {
                    this.addNormal(vector3f5, this.getCornerNormal(vertex.p, vertex2.p, vertex4.p));
                    this.addNormal(vector3f6, this.getCornerNormal(vertex2.p, vertex3.p, vertex.p));
                    this.addNormal(vector3f7, this.getCornerNormal(vertex3.p, vertex4.p, vertex2.p));
                    this.addNormal(vector3f8, this.getCornerNormal(vertex4.p, vertex.p, vertex3.p));
                }
            }
            if (vertex2.p.distanceSquared(vertex4.p) < vertex.p.distanceSquared(vertex3.p)) {
                this.listQuads.add(new Quad(n, n2, n3, n4, this.material));
            } else {
                this.listQuads.add(new Quad(n2, n3, n4, n, this.material));
            }
        }
    }

    private final int getVertexNumber(Vertex vertex) {
        Integer n = (Integer)this.mapVertices.get(vertex);
        if (n == null) {
            this.mapVertices.put(vertex, new Integer(this.iVertexNumber));
            this.listVertices.add(vertex);
            if (bExportNormals) {
                this.listAveragedNormals.add(new Vector3f());
            }
            return this.iVertexNumber++;
        }
        return n;
    }

    private final Vector3f getCornerNormal(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        v3_1.set((float)point3d2.x - (float)point3d.x, (float)point3d2.y - (float)point3d.y, (float)point3d2.z - (float)point3d.z);
        v3_2.set((float)point3d3.x - (float)point3d.x, (float)point3d3.y - (float)point3d.y, (float)point3d3.z - (float)point3d.z);
        Vector3f vector3f = new Vector3f();
        vector3f.cross(v3_1, v3_2);
        vector3f.normalize();
        return vector3f;
    }

    private final void addNormal(Vector3f vector3f, Vector3f vector3f2) {
        vector3f.add(vector3f2);
    }

    private static final float vDistSq(Vector3f vector3f, float f, float f2, float f3) {
        float f4 = vector3f.x - f;
        float f5 = vector3f.y - f2;
        float f6 = vector3f.z - f3;
        return f4 * f4 + f5 * f5 + f6 * f6;
    }

    private final /* synthetic */ void this() {
        this.matTriangleList = new ArrayList();
        this.matQuadList = new ArrayList();
        this.listAveragedNormals = new ArrayList();
        this.listVertices = new ArrayList();
        this.mapVertices = new HashMap();
        this.listQuads = new ArrayList();
    }

    public PatchTesselator3() {
        this.this();
    }

    public static class Vertex {
        public Point3d p;
        public Point3d r;
        public Vector3f n;

        public int hashCode() {
            return this.r.hashCode();
        }

        public boolean equals(Object object) {
            Vertex vertex = (Vertex)object;
            if (this.r.equals(vertex.r)) {
                if ((double)PatchTesselator3.vDistSq(vertex.n, this.n.x, this.n.y, this.n.z) < (double)1.0E-4f) {
                    return true;
                }
                if (!bExportNormals && (double)PatchTesselator3.vDistSq(vertex.n, -this.n.x, -this.n.y, -this.n.z) < (double)1.0E-4f) {
                    return true;
                }
            }
            return false;
        }

        Vertex(Point3d point3d, Point3d point3d2, Vector3f vector3f) {
            this.p = point3d;
            this.r = point3d2;
            this.n = vector3f;
        }
    }

    public static class Quad {
        public int i0;
        public int i1;
        public int i2;
        public int i3;
        public JPatchMaterial material;

        public boolean isTriangle() {
            boolean bl = false;
            if (this.i0 == this.i1 || this.i1 == this.i2 || this.i2 == this.i3 || this.i3 == this.i0) {
                bl = true;
            }
            return bl;
        }

        public int[] getTriangle() {
            if (this.i0 == this.i1) {
                return new int[]{this.i0, this.i2, this.i3};
            }
            if (this.i1 == this.i2) {
                return new int[]{this.i0, this.i1, this.i3};
            }
            if (this.i2 == this.i3) {
                return new int[]{this.i0, this.i1, this.i2};
            }
            if (this.i3 == this.i0) {
                return new int[]{this.i3, this.i1, this.i2};
            }
            throw new IllegalStateException();
        }

        public int[] getQuad() {
            int[] nArray;
            if (this.isTriangle()) {
                nArray = this.getTriangle();
            } else {
                int[] nArray2 = new int[4];
                nArray2[0] = this.i0;
                nArray2[1] = this.i1;
                nArray2[2] = this.i2;
                nArray = nArray2;
                nArray2[3] = this.i3;
            }
            return nArray;
        }

        public int[] getTriangle1() {
            return new int[]{this.i0, this.i1, this.i2};
        }

        public int[] getTriangle2() {
            return new int[]{this.i2, this.i3, this.i0};
        }

        public Quad(int n, int n2, int n3, int n4, JPatchMaterial jPatchMaterial) {
            this.i0 = n4;
            this.i1 = n3;
            this.i2 = n2;
            this.i3 = n;
            this.material = jPatchMaterial;
        }
    }
}

