/*
 * Decompiled with CFR 0.152.
 */
package jpatch.renderer;

import inyo.InyoJPatchInterface;
import inyo.RtInterface;
import java.awt.Image;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import jpatch.boundary.JPatchSettings;
import jpatch.entity.AnimLight;
import jpatch.entity.AnimModel;
import jpatch.entity.AnimObject;
import jpatch.entity.Camera;
import jpatch.entity.JPatchMaterial;
import jpatch.entity.MaterialProperties;
import jpatch.entity.Model;
import jpatch.renderer.PatchTesselator3;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class InyoRenderer2
implements InyoJPatchInterface {
    private List animModels;
    private List matrices;
    private List lights;
    private Camera camera;
    private PatchTesselator3 patchTesselator;
    private volatile Image image;

    public Image render() {
        Cloneable cloneable;
        Object object;
        AnimObject animObject;
        JPatchSettings jPatchSettings = JPatchSettings.getInstance();
        RtInterface rtInterface = new RtInterface();
        rtInterface.setImageSize(jPatchSettings.iRenderHeight, jPatchSettings.iRenderWidth, 1.0);
        Matrix4d matrix4d = new Matrix4d(this.camera.getTransform());
        matrix4d.invert();
        rtInterface.setCamera(matrix4d);
        rtInterface.setCameraFocalLength(this.camera.getFocalLength());
        rtInterface.setMaxRecursionDepth(jPatchSettings.inyoSettings.iRecursion);
        rtInterface.setSoftShadowSamples(jPatchSettings.inyoSettings.iShadowSamples);
        rtInterface.setTransparentShadows(jPatchSettings.inyoSettings.bTransparentShadows);
        rtInterface.setCaustics(jPatchSettings.inyoSettings.bEnableCaustics, jPatchSettings.inyoSettings.bOversampleCaustics);
        rtInterface.setUseAmbientOcclusion(jPatchSettings.inyoSettings.bEnableAmbientOcclusion);
        rtInterface.setAmbientOcclusion(jPatchSettings.inyoSettings.fAmbientOcclusionDistance);
        rtInterface.setAmbientOcclusionSamples(jPatchSettings.inyoSettings.iAmbientOcclusionSamples);
        rtInterface.ambientOcclusionColorBleed(jPatchSettings.inyoSettings.fAmbientOcclusionColorbleed);
        int n = jPatchSettings.inyoSettings.iSupersample;
        boolean bl = false;
        if (jPatchSettings.inyoSettings.iSamplingMode == 1) {
            bl = true;
        }
        rtInterface.setOversample(n, bl);
        rtInterface.setShowStats(false);
        float[] fArray = new float[3];
        jPatchSettings.cBackgroundColor.getRGBColorComponents(fArray);
        rtInterface.setSkyColor(fArray[0], fArray[1], fArray[2]);
        Iterator iterator = this.lights.iterator();
        while (iterator.hasNext()) {
            animObject = (AnimLight)iterator.next();
            object = animObject.getPosition();
            rtInterface.addLight(((Point3d)object).x, ((Point3d)object).y, ((Point3d)object).z, ((AnimLight)animObject).getIntensity());
            cloneable = ((AnimLight)animObject).getColor();
            rtInterface.setLightColor(((Color3f)cloneable).x, ((Color3f)cloneable).y, ((Color3f)cloneable).z);
            rtInterface.setLightRadius(((AnimLight)animObject).getSize());
        }
        iterator = this.animModels.iterator();
        while (iterator.hasNext()) {
            animObject = (AnimModel)iterator.next();
            object = ((AnimModel)animObject).getModel();
            cloneable = animObject.getTransform();
            this.patchTesselator.tesselate((Model)object, jPatchSettings.inyoSettings.iSubdivMode, (Matrix4d)cloneable, true);
            Iterator iterator2 = ((Model)object).getMaterialList().iterator();
            while (iterator2.hasNext()) {
                JPatchMaterial jPatchMaterial = (JPatchMaterial)iterator2.next();
                PatchTesselator3.Vertex[] vertexArray = this.patchTesselator.getPerMaterialVertexArray(jPatchMaterial);
                int[][] nArray = this.patchTesselator.getPerMaterialTriangleArray();
                if (nArray.length <= 0) continue;
                rtInterface.objectBegin();
                MaterialProperties materialProperties = jPatchMaterial.getMaterialProperties();
                rtInterface.addMaterial(materialProperties.red, materialProperties.green, materialProperties.blue);
                rtInterface.setMaterialFilter(materialProperties.filter);
                rtInterface.setMaterialTransmit(materialProperties.transmit);
                rtInterface.setMaterialAmbient(materialProperties.ambient);
                rtInterface.setMaterialDiffuse(materialProperties.diffuse);
                rtInterface.setMaterialBrilliance(materialProperties.brilliance);
                rtInterface.setMaterialSpecular(materialProperties.specular);
                rtInterface.setMaterialRoughness(materialProperties.roughness);
                rtInterface.setMaterialMetallic(materialProperties.metallic);
                rtInterface.setMaterialReflection(materialProperties.reflectionMin, materialProperties.reflectionMax, materialProperties.reflectionFalloff);
                rtInterface.setMaterialRefraction(materialProperties.refraction);
                rtInterface.setMaterialConserveEnergy(materialProperties.conserveEnergy);
                String string = jPatchMaterial.getRenderString("inyo", "");
                int n2 = 0;
                while (n2 < vertexArray.length) {
                    PatchTesselator3.Vertex vertex = vertexArray[n2];
                    rtInterface.addVertex(vertex.p.x, vertex.p.y, vertex.p.z, vertex.r.x, vertex.r.y, vertex.r.z, vertex.n.x, vertex.n.y, vertex.n.z);
                    ++n2;
                }
                n2 = 0;
                while (n2 < nArray.length) {
                    rtInterface.addTriangle(nArray[n2][0], nArray[n2][1], nArray[n2][2]);
                    ++n2;
                }
                rtInterface.objectEnd();
            }
        }
        rtInterface.startRendering(this);
        try {
            while (this.image == null) {
                Thread.sleep(50L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.image;
    }

    public synchronized void progress(double d) {
        System.out.println("progress: " + d);
    }

    public synchronized void renderingDone(Image image) {
        this.image = image;
    }

    private final /* synthetic */ void this() {
        this.patchTesselator = new PatchTesselator3();
        this.image = null;
    }

    public InyoRenderer2(List list, Camera camera, List list2) {
        this.this();
        this.animModels = list;
        this.camera = camera;
        this.lights = list2;
    }
}

