/*
 * Decompiled with CFR 0.152.
 */
package jpatch.entity;

import jpatch.auxilary.XMLutils;
import jpatch.entity.ControlPoint;
import jpatch.entity.Model;

public final class Curve {
    private Model model;
    private ControlPoint cpStart;
    private Curve crvNext;
    private Curve crvPrev;

    public final ControlPoint getStart() {
        return this.cpStart;
    }

    public final void setStart(ControlPoint controlPoint) {
        this.cpStart = controlPoint;
    }

    public final Model getModel() {
        return this.model;
    }

    public final void setModel(Model model) {
        this.model = model;
    }

    public final Curve getNext() {
        return this.crvNext;
    }

    public final void setNext(Curve curve) {
        this.crvNext = curve;
    }

    public final Curve getPrev() {
        return this.crvPrev;
    }

    public final void setPrev(Curve curve) {
        this.crvPrev = curve;
    }

    public final void remove() {
        if (this.crvPrev != null) {
            this.crvPrev.crvNext = this.crvNext;
        }
        if (this.crvNext != null) {
            this.crvNext.crvPrev = this.crvPrev;
        }
        if (this.model != null && this.model.getLastCurve() == this) {
            this.model.setLastCurve(this.crvPrev);
        }
        if (this.model != null && this.model.getFirstCurve() == this) {
            this.model.setFirstCurve(this.crvNext);
        }
        this.model = null;
    }

    public final int getLength() {
        int n = 0;
        ControlPoint controlPoint = this.cpStart;
        while (controlPoint != null) {
            ++n;
            controlPoint = controlPoint.getNextCheckNextLoop();
        }
        return n;
    }

    public final boolean isClosed() {
        return this.cpStart.getLoop();
    }

    public final ControlPoint[] getControlPointArray() {
        int n = this.getLength();
        if (n > 0) {
            ControlPoint[] controlPointArray = new ControlPoint[n];
            int n2 = 0;
            ControlPoint controlPoint = this.cpStart;
            while (controlPoint != null) {
                controlPointArray[n2++] = controlPoint;
                controlPoint = controlPoint.getNextCheckNextLoop();
            }
            return controlPointArray;
        }
        return null;
    }

    public final void reverse() {
        int n = this.getLength();
        ControlPoint controlPoint = this.cpStart.getEnd();
        while (controlPoint != null) {
            if (controlPoint.getHookPos() != -1.0f) {
                controlPoint.setHookPos(1.0f - controlPoint.getHookPos());
            }
            if (controlPoint.getChildHook() != null) {
                controlPoint.getNext().setChildHook(controlPoint.getChildHook().getEnd());
                controlPoint.getChildHook().getCurve().reverse();
                controlPoint.setChildHook(null);
            }
            ControlPoint controlPoint2 = controlPoint.getNext();
            controlPoint.setNext(controlPoint.getPrev());
            controlPoint.setPrev(controlPoint2);
            controlPoint.setTangentsValid(false);
            controlPoint = controlPoint.getNext();
        }
        this.cpStart = this.cpStart.getStart();
    }

    public final void validate() {
        ControlPoint controlPoint = this.cpStart;
        while (controlPoint != null) {
            controlPoint.setCurve(this);
            controlPoint = controlPoint.getNextCheckNextLoop();
        }
    }

    public final String toString() {
        return "" + this.hashCode();
    }

    public final StringBuffer xml(int n) {
        StringBuffer stringBuffer = XMLutils.indent(n);
        StringBuffer stringBuffer2 = XMLutils.lineBreak();
        StringBuffer stringBuffer3 = new StringBuffer();
        if (this.isClosed()) {
            stringBuffer3.append(stringBuffer).append("<curve closed=\"true\">").append(stringBuffer2);
        } else {
            stringBuffer3.append(stringBuffer).append("<curve>").append(stringBuffer2);
        }
        ControlPoint controlPoint = this.getStart();
        while (controlPoint != null) {
            stringBuffer3.append(controlPoint.xml(n + 1));
            controlPoint = controlPoint.getNextCheckNextLoop();
        }
        stringBuffer3.append(stringBuffer).append("</curve>").append(stringBuffer2);
        return stringBuffer3;
    }

    public Curve(ControlPoint controlPoint) {
        this.cpStart = controlPoint;
    }

    public Curve(ControlPoint controlPoint, Model model) {
        this.model = model;
        this.cpStart = controlPoint;
    }
}

