/*
 * Decompiled with CFR 0.152.
 */
package jpatch.entity;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3d;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AnimObject {
    static final double MIN_ROLL = 1.0E-7;
    protected Matrix4d m4Transform;
    protected String strName;

    public void setTransform(Matrix4d matrix4d) {
        this.m4Transform.set(matrix4d);
    }

    public void setPosition(Point3d point3d) {
        this.m4Transform.setTranslation(new Vector3d(point3d));
    }

    public void setOrientation(Quat4f quat4f) {
        Quat4d quat4d = new Quat4d(quat4f);
        quat4d.normalize();
        this.setOrientation(quat4d);
    }

    public void setOrientation(Quat4d quat4d) {
        this.m4Transform.setRotation(quat4d);
    }

    public void setOrientation(double d, double d2, double d3) {
        if (d != this.getRoll() || d2 != this.getPitch() || d3 != this.getYaw()) {
            if (d >= 0.0 && d <= 1.0E-7) {
                d = 1.0E-7;
            } else if (d <= 0.0 && d >= -1.0E-7) {
                d = -1.0E-7;
            }
            this.m4Transform.m00 = Math.sin(-d) * Math.sin(-d2) * Math.sin(d3) + Math.cos(-d) * Math.cos(d3);
            this.m4Transform.m01 = Math.cos(-d) * Math.sin(-d2) * Math.sin(d3) - Math.sin(-d) * Math.cos(d3);
            this.m4Transform.m02 = Math.cos(-d2) * Math.sin(d3);
            this.m4Transform.m10 = Math.sin(-d) * Math.cos(-d2);
            this.m4Transform.m11 = Math.cos(-d) * Math.cos(-d2);
            this.m4Transform.m12 = -Math.sin(-d2);
            this.m4Transform.m20 = Math.sin(-d) * Math.sin(-d2) * Math.cos(d3) - Math.cos(-d) * Math.sin(d3);
            this.m4Transform.m21 = Math.cos(-d) * Math.sin(-d2) * Math.cos(d3) + Math.sin(-d) * Math.sin(d3);
            this.m4Transform.m22 = Math.cos(-d2) * Math.cos(d3);
        }
    }

    public void setScale(float f) {
        this.m4Transform.setScale(f);
    }

    public void setName(String string) {
        this.strName = string;
    }

    public Matrix4d getTransform() {
        return this.m4Transform;
    }

    public Point3d getPosition() {
        Vector3d vector3d = new Vector3d();
        this.m4Transform.get(vector3d);
        return new Point3d(vector3d);
    }

    public Quat4f getOrientation() {
        Quat4f quat4f = new Quat4f();
        this.m4Transform.get(quat4f);
        return quat4f;
    }

    public double getRoll() {
        double d = Math.atan(this.m4Transform.m11 / this.m4Transform.m10) - 1.5707963267948966;
        if (this.m4Transform.m10 < 0.0) {
            d -= Math.PI;
        }
        if (d < -Math.PI) {
            d += Math.PI * 2;
        }
        return d;
    }

    public double getPitch() {
        return -Math.asin(-this.m4Transform.m12);
    }

    public double getYaw() {
        double d = 1.5707963267948966 - Math.atan(this.m4Transform.m22 / this.m4Transform.m02);
        if (this.m4Transform.m02 < 0.0) {
            d += Math.PI;
        }
        return d;
    }

    public float getScale() {
        return (float)this.m4Transform.getScale();
    }

    public String getName() {
        return this.strName;
    }

    public String toString() {
        return this.strName;
    }

    private final /* synthetic */ void this() {
        this.m4Transform = new Matrix4d();
        this.strName = "(new object)";
    }

    public AnimObject() {
        this.this();
        this.m4Transform.setIdentity();
    }
}

