/*
 * Decompiled with CFR 0.152.
 */
package jpatch.control.edit;

import java.util.ArrayList;
import java.util.Iterator;
import javax.vecmath.Vector3f;
import jpatch.control.edit.JPatchAbstractUndoableEdit;
import jpatch.entity.ControlPoint;
import jpatch.entity.Model;
import jpatch.entity.Morph;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RemoveControlPointFromMorphsEdit
extends JPatchAbstractUndoableEdit {
    private ControlPoint cp;
    private Model model;
    private ArrayList listMorphs;
    private ArrayList listVectors;

    public String name() {
        return "remove cp from morphs";
    }

    public void undo() {
        int n = 0;
        int n2 = this.listMorphs.size();
        while (n < n2) {
            Morph morph = (Morph)this.listMorphs.get(n);
            Vector3f vector3f = (Vector3f)this.listVectors.get(n);
            morph.add(this.cp, vector3f);
            ++n;
        }
    }

    public void redo() {
        int n = 0;
        int n2 = this.listMorphs.size();
        while (n < n2) {
            Morph morph = (Morph)this.listMorphs.get(n);
            morph.removePoint(this.cp);
            ++n;
        }
    }

    private final /* synthetic */ void this() {
        this.listMorphs = new ArrayList();
        this.listVectors = new ArrayList();
    }

    public RemoveControlPointFromMorphsEdit(ControlPoint controlPoint, Model model) {
        this.this();
        this.cp = controlPoint;
        this.model = model;
        Iterator iterator = model.getMorphIterator();
        while (iterator.hasNext()) {
            Morph morph = (Morph)iterator.next();
            Vector3f vector3f = morph.removePoint(controlPoint);
            if (vector3f == null) continue;
            this.listMorphs.add(morph);
            this.listVectors.add(vector3f);
        }
    }
}

