/*
 * Decompiled with CFR 0.152.
 */
package jpatch.control.edit;

import jpatch.control.edit.ChangeCPChildHookEdit;
import jpatch.control.edit.ChangeCPParentHookEdit;
import jpatch.control.edit.ChangeControlPointLoopEdit;
import jpatch.control.edit.JPatchCompoundEdit;
import jpatch.control.edit.RemoveControlPointFromSelectionsEdit;
import jpatch.control.edit.RemoveCurveFromModelEdit;
import jpatch.control.edit.ReverseCurveEdit;
import jpatch.control.edit.SimpleAppendControlPointsEdit;
import jpatch.control.edit.ValidateCurveEdit;
import jpatch.entity.ControlPoint;
import jpatch.entity.JPatchException;

public class ComplexAppendControlPointsEdit
extends JPatchCompoundEdit {
    private ControlPoint cpA;
    private ControlPoint cpB;

    public ComplexAppendControlPointsEdit(ControlPoint controlPoint, ControlPoint controlPoint2) {
        super("append");
        this.cpA = controlPoint;
        this.cpB = controlPoint2;
        this.addEdit(new RemoveControlPointFromSelectionsEdit(this.cpA));
        if (this.cpA.getNext() != null && this.cpA.getPrev() != null || this.cpB.getNext() != null && this.cpB.getPrev() != null) {
            throw new JPatchException("can't append - cp's are no curve ends");
        }
        if (this.cpA.getCurve() != this.cpB.getCurve()) {
            if (this.cpB.getNext() != null) {
                this.addEdit(new ReverseCurveEdit(this.cpB.getCurve()));
            }
            if (this.cpA.getPrev() != null) {
                this.addEdit(new ReverseCurveEdit(this.cpA.getCurve()));
            }
            if (this.cpA.getChildHook() != null) {
                this.addEdit(new ChangeCPChildHookEdit(this.cpB, this.cpA.getChildHook()));
                this.addEdit(new ChangeCPParentHookEdit(this.cpA.getChildHook(), this.cpB));
            }
            this.addEdit(new RemoveCurveFromModelEdit(this.cpA.getCurve()));
            this.addEdit(new SimpleAppendControlPointsEdit(this.cpA.getNext(), this.cpB));
            this.addEdit(new ValidateCurveEdit(this.cpB.getCurve()));
        } else if (this.cpA.getPrev() != null) {
            this.addEdit(new SimpleAppendControlPointsEdit(this.cpB, this.cpA.getPrev()));
            this.addEdit(new ChangeControlPointLoopEdit(this.cpB, true));
        } else {
            this.addEdit(new SimpleAppendControlPointsEdit(this.cpA, this.cpB.getPrev()));
            this.addEdit(new ChangeControlPointLoopEdit(this.cpA, true));
        }
    }
}

