/*
 * Decompiled with CFR 0.152.
 */
package jpatch.control.edit;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import jpatch.boundary.MainFrame;
import jpatch.control.edit.FlipPatchEdit;
import jpatch.control.edit.JPatchCompoundEdit;
import jpatch.entity.ControlPoint;
import jpatch.entity.Patch;

public class AlignPatchesEdit
extends JPatchCompoundEdit {
    private HashSet patches;

    private final void alignPatches() {
        Iterator iterator = new HashSet(this.patches).iterator();
        while (iterator.hasNext()) {
            Patch patch = (Patch)iterator.next();
            if (!this.patches.contains(patch)) continue;
            this.processPatch(patch);
        }
    }

    private final void processPatch(Patch patch) {
        this.patches.remove(patch);
        Iterator iterator = new HashSet(this.patches).iterator();
        while (iterator.hasNext()) {
            Patch patch2 = (Patch)iterator.next();
            if (!this.patches.contains(patch2)) continue;
            int n = this.comparePatches(patch, patch2);
            if (n < 0) {
                this.addEdit(new FlipPatchEdit(patch2));
                this.processPatch(patch2);
                continue;
            }
            if (n <= 0) continue;
            this.processPatch(patch2);
        }
    }

    private final int comparePatches(Patch patch, Patch patch2) {
        ControlPoint[] controlPointArray = patch.getControlPoints();
        int n = controlPointArray.length;
        ControlPoint[] controlPointArray2 = patch2.getControlPoints();
        int n2 = controlPointArray2.length;
        int n3 = 0;
        while (n3 < controlPointArray.length) {
            int n4 = 0;
            while (n4 < controlPointArray2.length) {
                ControlPoint controlPoint;
                ControlPoint controlPoint2;
                if (controlPointArray[n3] == controlPointArray2[n4] && controlPointArray[n3 + 1] == controlPointArray2[n4 + 1] && controlPointArray[(n3 - 1 + n) % n] == controlPointArray2[(n4 - 1 + n2) % n2] && controlPointArray[(n3 + 2) % n] == controlPointArray2[(n4 + 2) % n2]) {
                    return -1;
                }
                if (controlPointArray[n3] == controlPointArray2[n4 + 1] && controlPointArray[n3 + 1] == controlPointArray2[n4] && controlPointArray[(n3 - 1 + n) % n] == controlPointArray2[(n4 + 2) % n2] && controlPointArray[(n3 + 2) % n] == controlPointArray2[(n4 - 1 + n2) % n2]) {
                    return 1;
                }
                if (controlPointArray[n3].isStartHook()) {
                    controlPoint2 = controlPointArray[n3].getParentHook();
                    controlPoint = controlPointArray[n3].getEnd().getParentHook();
                    if (controlPoint2 == controlPointArray2[n4] && controlPoint == controlPointArray2[n4 + 1]) {
                        return -1;
                    }
                    if (controlPoint2 == controlPointArray2[n4 + 1] && controlPoint == controlPointArray2[n4]) {
                        return 1;
                    }
                } else if (controlPointArray[n3 + 1].isStartHook()) {
                    controlPoint2 = controlPointArray[n3 + 1].getParentHook();
                    controlPoint = controlPointArray[n3 + 1].getEnd().getParentHook();
                    if (controlPoint2 == controlPointArray2[n4] && controlPoint == controlPointArray2[n4 + 1]) {
                        return 1;
                    }
                    if (controlPoint2 == controlPointArray2[n4 + 1] && controlPoint == controlPointArray2[n4]) {
                        return -1;
                    }
                } else if (controlPointArray2[n4].isStartHook()) {
                    controlPoint2 = controlPointArray2[n4].getParentHook();
                    controlPoint = controlPointArray2[n4].getEnd().getParentHook();
                    if (controlPoint2 == controlPointArray[n3] && controlPoint == controlPointArray[n3 + 1]) {
                        return -1;
                    }
                    if (controlPoint2 == controlPointArray[n3 + 1] && controlPoint == controlPointArray[n3]) {
                        return 1;
                    }
                } else if (controlPointArray2[n4 + 1].isStartHook()) {
                    controlPoint2 = controlPointArray2[n4 + 1].getParentHook();
                    controlPoint = controlPointArray2[n4 + 1].getEnd().getParentHook();
                    if (controlPoint2 == controlPointArray[n3] && controlPoint == controlPointArray[n3 + 1]) {
                        return 1;
                    }
                    if (controlPoint2 == controlPointArray[n3 + 1] && controlPoint == controlPointArray[n3]) {
                        return -1;
                    }
                }
                n4 += 2;
            }
            n3 += 2;
        }
        return 0;
    }

    public AlignPatchesEdit() {
        this.patches = new HashSet();
        Patch patch = MainFrame.getInstance().getModel().getFirstPatch();
        while (patch != null) {
            this.patches.add(patch);
            patch = patch.getNext();
        }
        this.alignPatches();
    }

    public AlignPatchesEdit(Collection collection) {
        this.patches = new HashSet(collection);
        this.alignPatches();
    }
}

