/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary.tools;

import java.awt.Component;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import jpatch.boundary.JPatchCanvas;
import jpatch.boundary.JPatchDrawable;
import jpatch.boundary.JPatchSettings;
import jpatch.boundary.MainFrame;
import jpatch.boundary.Viewport;
import jpatch.boundary.mouse.SelectMouseMotionListener;
import jpatch.boundary.selection.PointSelection;
import jpatch.boundary.selection.Selection;
import jpatch.boundary.tools.DefaultHandle;
import jpatch.boundary.tools.Handle;
import jpatch.boundary.tools.HandleZOrderComparator;
import jpatch.boundary.tools.JPatchTool;
import jpatch.boundary.tools.PivotHandle2;
import jpatch.boundary.tools.TangentHandle;
import jpatch.boundary.tools.TangentTool;
import jpatch.control.edit.AddControlPointsToSelectionEdit;
import jpatch.control.edit.ChangeControlPointMagnitudeEdit;
import jpatch.control.edit.ChangeSelectionCPHotEdit;
import jpatch.control.edit.ChangeSelectionEdit;
import jpatch.control.edit.ChangeSelectionPivotEdit;
import jpatch.control.edit.HookEdit;
import jpatch.control.edit.JPatchCompoundEdit;
import jpatch.control.edit.NewMoveControlPointsEdit;
import jpatch.control.edit.RemoveControlPointsFromSelectionEdit;
import jpatch.control.edit.WeldControlPointsEdit;
import jpatch.entity.ControlPoint;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultTool
extends JPatchTool {
    private static final int GHOST_FACTOR = JPatchSettings.getInstance().iGhost;
    private static final int IDLE = 0;
    private static final int DRAW_SELECTION = 1;
    private static final int MOVE_SINGLE_POINT = 2;
    private static final int MOVE_GROUP = 3;
    private static final int SCALE_GROUP = 4;
    private static final int PIVOT = 5;
    private static final int ADD_MODIFY_SELECTION = 6;
    private static final int XOR_MODIFY_SELECTION = 7;
    private static final int TANGENT = 8;
    private Handle[] aHandle;
    private int iMouseX;
    private int iMouseY;
    private HandleZOrderComparator comparator;
    private Handle activeHandle;
    private Point3f[] ap3;
    private PivotHandle2 pivotHandle;
    private ControlPoint cpHot;
    private JPatchCompoundEdit compoundEdit;
    private Point3f p3Pivot;
    private Vector3f v3Move;
    private int iState;
    private SelectMouseMotionListener selectMouseMotionListener;
    private Viewport viewport;
    private boolean bMoveZ;
    private TangentTool tangentTool;
    private TangentHandle tangentHandle;
    private float fMagnitude;

    public int getButton() {
        return 0;
    }

    private final void setActiveHelpText() {
        switch (this.iState) {
            case 2: {
                MainFrame.getInstance().setHelpText("Drag to move point. Press right mousebutton to weld to closest point");
                break;
            }
            case 3: {
                if (MainFrame.getInstance().getPointSelection().getHotCp() != null) {
                    MainFrame.getInstance().setHelpText("Drag to move selection. Press right mousebutton to weld to closest point");
                    break;
                }
                MainFrame.getInstance().setHelpText("Drag to move selection.");
                break;
            }
            case 1: {
                MainFrame.getInstance().setHelpText("Drag to select points");
                break;
            }
            case 6: {
                MainFrame.getInstance().setHelpText("Drag to select points to be added to current selection");
                break;
            }
            case 7: {
                MainFrame.getInstance().setHelpText("Drag to select points to be removed from current selection");
                break;
            }
            case 5: {
                MainFrame.getInstance().setHelpText("Drag to move pivot");
                break;
            }
            case 4: {
                MainFrame.getInstance().setHelpText("Drag to scale selected points");
                break;
            }
        }
    }

    protected boolean isHit(int n, int n2, Matrix4f matrix4f) {
        PointSelection pointSelection = MainFrame.getInstance().getPointSelection();
        Point3f point3f = new Point3f(pointSelection.getCornerA());
        Point3f point3f2 = new Point3f(pointSelection.getCornerB());
        float f = 12.0f / matrix4f.getScale();
        Vector3f vector3f = new Vector3f(f, f, f);
        point3f.sub(vector3f);
        point3f2.add(vector3f);
        Point3f[] point3fArray = new Point3f[]{new Point3f(point3f.x, point3f.y, point3f.z), new Point3f(point3f.x, point3f.y, point3f2.z), new Point3f(point3f2.x, point3f.y, point3f2.z), new Point3f(point3f2.x, point3f.y, point3f.z), new Point3f(point3f.x, point3f2.y, point3f.z), new Point3f(point3f.x, point3f2.y, point3f2.z), new Point3f(point3f2.x, point3f2.y, point3f2.z), new Point3f(point3f2.x, point3f2.y, point3f.z)};
        int n3 = 0;
        while (n3 < 8) {
            pointSelection.getRotation().transform(point3fArray[n3]);
            matrix4f.transform(point3fArray[n3]);
            ++n3;
        }
        Polygon polygon = new Polygon();
        polygon.reset();
        polygon.addPoint((int)point3fArray[0].x, (int)point3fArray[0].y);
        polygon.addPoint((int)point3fArray[1].x, (int)point3fArray[1].y);
        polygon.addPoint((int)point3fArray[2].x, (int)point3fArray[2].y);
        polygon.addPoint((int)point3fArray[3].x, (int)point3fArray[3].y);
        if (polygon.contains(n, n2)) {
            return true;
        }
        polygon.reset();
        polygon.addPoint((int)point3fArray[4].x, (int)point3fArray[4].y);
        polygon.addPoint((int)point3fArray[5].x, (int)point3fArray[5].y);
        polygon.addPoint((int)point3fArray[6].x, (int)point3fArray[6].y);
        polygon.addPoint((int)point3fArray[7].x, (int)point3fArray[7].y);
        if (polygon.contains(n, n2)) {
            return true;
        }
        polygon.reset();
        polygon.addPoint((int)point3fArray[0].x, (int)point3fArray[0].y);
        polygon.addPoint((int)point3fArray[1].x, (int)point3fArray[1].y);
        polygon.addPoint((int)point3fArray[5].x, (int)point3fArray[5].y);
        polygon.addPoint((int)point3fArray[4].x, (int)point3fArray[4].y);
        if (polygon.contains(n, n2)) {
            return true;
        }
        polygon.reset();
        polygon.addPoint((int)point3fArray[3].x, (int)point3fArray[3].y);
        polygon.addPoint((int)point3fArray[2].x, (int)point3fArray[2].y);
        polygon.addPoint((int)point3fArray[6].x, (int)point3fArray[6].y);
        polygon.addPoint((int)point3fArray[7].x, (int)point3fArray[7].y);
        if (polygon.contains(n, n2)) {
            return true;
        }
        polygon.reset();
        polygon.addPoint((int)point3fArray[1].x, (int)point3fArray[1].y);
        polygon.addPoint((int)point3fArray[2].x, (int)point3fArray[2].y);
        polygon.addPoint((int)point3fArray[6].x, (int)point3fArray[6].y);
        polygon.addPoint((int)point3fArray[5].x, (int)point3fArray[5].y);
        if (polygon.contains(n, n2)) {
            return true;
        }
        polygon.reset();
        polygon.addPoint((int)point3fArray[0].x, (int)point3fArray[0].y);
        polygon.addPoint((int)point3fArray[3].x, (int)point3fArray[3].y);
        polygon.addPoint((int)point3fArray[7].x, (int)point3fArray[7].y);
        polygon.addPoint((int)point3fArray[4].x, (int)point3fArray[4].y);
        return polygon.contains(n, n2);
    }

    public void paint(Viewport viewport, JPatchDrawable jPatchDrawable) {
        PointSelection pointSelection = MainFrame.getInstance().getPointSelection();
        if (MainFrame.getInstance().getJPatchScreen().showTangents() && this.tangentTool != null) {
            this.tangentTool.paint(viewport, jPatchDrawable);
        }
        if (pointSelection != null && pointSelection.getSize() > 1) {
            Matrix4f matrix4f = viewport.getViewDefinition().getMatrix();
            Point3f point3f = new Point3f(pointSelection.getCornerA());
            Point3f point3f2 = new Point3f(pointSelection.getCornerB());
            float f = 12.0f / matrix4f.getScale();
            Vector3f vector3f = new Vector3f(f, f, f);
            point3f.sub(vector3f);
            point3f2.add(vector3f);
            Point3f[] point3fArray = new Point3f[]{new Point3f(point3f.x, point3f.y, point3f.z), new Point3f(point3f.x, point3f.y, point3f2.z), new Point3f(point3f2.x, point3f.y, point3f2.z), new Point3f(point3f2.x, point3f.y, point3f.z), new Point3f(point3f.x, point3f2.y, point3f.z), new Point3f(point3f.x, point3f2.y, point3f2.z), new Point3f(point3f2.x, point3f2.y, point3f2.z), new Point3f(point3f2.x, point3f2.y, point3f.z)};
            int n = 0;
            while (n < 8) {
                pointSelection.getRotation().transform(point3fArray[n]);
                this.aHandle[n].getPosition().set(point3fArray[n]);
                matrix4f.transform(point3fArray[n]);
                ++n;
            }
            jPatchDrawable.setColor(this.settings.cSelection);
            jPatchDrawable.drawGhostLine3D(point3fArray[0], point3fArray[1], GHOST_FACTOR);
            jPatchDrawable.drawGhostLine3D(point3fArray[1], point3fArray[2], GHOST_FACTOR);
            jPatchDrawable.drawGhostLine3D(point3fArray[2], point3fArray[3], GHOST_FACTOR);
            jPatchDrawable.drawGhostLine3D(point3fArray[3], point3fArray[0], GHOST_FACTOR);
            jPatchDrawable.drawGhostLine3D(point3fArray[4], point3fArray[5], GHOST_FACTOR);
            jPatchDrawable.drawGhostLine3D(point3fArray[5], point3fArray[6], GHOST_FACTOR);
            jPatchDrawable.drawGhostLine3D(point3fArray[6], point3fArray[7], GHOST_FACTOR);
            jPatchDrawable.drawGhostLine3D(point3fArray[7], point3fArray[4], GHOST_FACTOR);
            jPatchDrawable.drawGhostLine3D(point3fArray[0], point3fArray[4], GHOST_FACTOR);
            jPatchDrawable.drawGhostLine3D(point3fArray[1], point3fArray[5], GHOST_FACTOR);
            jPatchDrawable.drawGhostLine3D(point3fArray[2], point3fArray[6], GHOST_FACTOR);
            jPatchDrawable.drawGhostLine3D(point3fArray[3], point3fArray[7], GHOST_FACTOR);
            this.comparator.setMatrix(matrix4f);
            Handle[] handleArray = (Handle[])this.aHandle.clone();
            Arrays.sort(handleArray, this.comparator);
            int n2 = handleArray.length - 1;
            while (n2 >= 0) {
                handleArray[n2].paint(viewport, jPatchDrawable);
                --n2;
            }
        }
    }

    private final void setPassive() {
        int n = 0;
        while (n < this.aHandle.length) {
            this.aHandle[n].setActive(false);
            ++n;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            Cloneable cloneable;
            MainFrame.getInstance().getJPatchScreen().enablePopupMenu(false);
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            PointSelection pointSelection = MainFrame.getInstance().getPointSelection();
            this.viewport = (Viewport)mouseEvent.getSource();
            if (MainFrame.getInstance().getJPatchScreen().showTangents()) {
                this.tangentHandle = this.tangentTool.isHit(this.viewport, n, n2);
                if (this.tangentHandle != null) {
                    if (mouseEvent.getClickCount() == 2) {
                        this.fMagnitude = this.tangentHandle.getMagnitude();
                        this.tangentHandle.getCp().setMagnitude(1.0f);
                        this.tangentHandle.getCp().invalidateTangents();
                        MainFrame.getInstance().getUndoManager().addEdit(new ChangeControlPointMagnitudeEdit(this.tangentHandle.getCp(), this.fMagnitude));
                        MainFrame.getInstance().getJPatchScreen().update_all();
                        return;
                    }
                    this.fMagnitude = this.tangentHandle.getMagnitude();
                    this.tangentHandle.setFactor(mouseEvent);
                    ((Component)mouseEvent.getSource()).addMouseMotionListener(this.tangentHandle);
                    this.iState = 8;
                    return;
                }
            }
            this.paint(this.viewport, ((JPatchCanvas)mouseEvent.getSource()).getDrawable());
            this.compoundEdit = new JPatchCompoundEdit();
            boolean bl = false;
            this.activeHandle = null;
            this.setPassive();
            this.iState = 0;
            if (pointSelection != null) {
                this.p3Pivot.set(pointSelection.getPivot());
            }
            if (pointSelection != null && pointSelection.getSize() > 1) {
                this.ap3 = pointSelection.getPointArray();
                float f = Float.MAX_VALUE;
                cloneable = new Point3f();
                int n3 = 0;
                while (n3 < this.aHandle.length) {
                    if (this.aHandle[n3].isHit(this.viewport, n, n2, (Point3f)cloneable) && (this.activeHandle == null || ((Point3f)cloneable).z < f)) {
                        f = ((Point3f)cloneable).z;
                        this.activeHandle = this.aHandle[n3];
                    }
                    ++n3;
                }
                if (mouseEvent.getClickCount() == 2 && this.activeHandle == this.pivotHandle) {
                    pointSelection.resetPivotToCenter();
                    MainFrame.getInstance().getUndoManager().addEdit(new ChangeSelectionPivotEdit(pointSelection, this.p3Pivot, null));
                    ((Component)mouseEvent.getSource()).removeMouseMotionListener(this.activeHandle);
                    this.activeHandle = null;
                    return;
                }
            }
            if (this.activeHandle != null) {
                this.activeHandle.setActive(true);
                this.activeHandle.setMouse(n, n2);
                ((Component)mouseEvent.getSource()).addMouseMotionListener(this.activeHandle);
                bl = true;
                this.iState = 5;
                if (this.activeHandle != this.pivotHandle) {
                    ((DefaultHandle)this.activeHandle).setOldPosition();
                    this.iState = 4;
                    this.compoundEdit.addEdit(new NewMoveControlPointsEdit(pointSelection.getControlPointArray()));
                }
            } else {
                Matrix4f matrix4f = this.viewport.getViewDefinition().getMatrix();
                this.cpHot = this.viewport.getViewDefinition().getClosestControlPoint(new Point2D.Float(n, n2), null, null, true, false, this.cpHot);
                if (this.cpHot != null) {
                    if (!mouseEvent.isControlDown() && !mouseEvent.isShiftDown() || pointSelection == null) {
                        if (pointSelection != null && pointSelection.getSize() > 1 && this.isHit(n, n2, matrix4f)) {
                            if (pointSelection.contains(this.cpHot)) {
                                this.compoundEdit.addEdit(new ChangeSelectionCPHotEdit(pointSelection, this.cpHot));
                                bl = true;
                            }
                            this.iState = 3;
                            this.compoundEdit.addEdit(new NewMoveControlPointsEdit(pointSelection.getControlPointArray()));
                            ((Component)mouseEvent.getSource()).addMouseMotionListener(this);
                            this.iMouseX = n;
                            this.iMouseY = n2;
                            this.bMoveZ = mouseEvent.isAltDown();
                        } else {
                            this.compoundEdit.addEdit(new ChangeSelectionEdit(new PointSelection(this.cpHot)));
                            this.iState = 2;
                            this.compoundEdit.addEdit(new NewMoveControlPointsEdit(new ControlPoint[]{this.cpHot}));
                            bl = true;
                            this.iMouseX = n;
                            this.iMouseY = n2;
                            ((Component)mouseEvent.getSource()).addMouseMotionListener(this);
                            this.bMoveZ = mouseEvent.isAltDown();
                        }
                    } else if (mouseEvent.isControlDown() && pointSelection.contains(this.cpHot)) {
                        cloneable = new ArrayList();
                        cloneable.add(this.cpHot);
                        this.compoundEdit.addEdit(new RemoveControlPointsFromSelectionEdit(pointSelection, (Collection)((Object)cloneable)));
                        this.compoundEdit.addEdit(new ChangeSelectionCPHotEdit(pointSelection, null));
                        MainFrame.getInstance().getUndoManager().addEdit(this.compoundEdit);
                        this.iState = 0;
                        bl = true;
                    } else if (mouseEvent.isShiftDown() || mouseEvent.isControlDown() && !pointSelection.contains(this.cpHot)) {
                        cloneable = new ArrayList();
                        cloneable.add(this.cpHot);
                        this.compoundEdit.addEdit(new AddControlPointsToSelectionEdit(pointSelection, (Collection)((Object)cloneable)));
                        this.compoundEdit.addEdit(new ChangeSelectionCPHotEdit(pointSelection, this.cpHot));
                        MainFrame.getInstance().getUndoManager().addEdit(this.compoundEdit);
                        this.iState = 0;
                        bl = true;
                    }
                } else {
                    if (pointSelection != null) {
                        this.compoundEdit.addEdit(new ChangeSelectionCPHotEdit(pointSelection, null));
                        bl = true;
                    }
                    if (mouseEvent.isShiftDown() && pointSelection != null) {
                        this.iState = 6;
                        this.iMouseX = n;
                        this.iMouseY = n2;
                    } else if (mouseEvent.isControlDown() && pointSelection != null) {
                        this.iState = 7;
                        this.iMouseX = n;
                        this.iMouseY = n2;
                    } else if (pointSelection != null && pointSelection.getSize() > 1 && this.isHit(n, n2, matrix4f)) {
                        this.iState = 3;
                        this.compoundEdit.addEdit(new NewMoveControlPointsEdit(pointSelection.getControlPointArray()));
                        ((Component)mouseEvent.getSource()).addMouseMotionListener(this);
                        this.iMouseX = n;
                        this.iMouseY = n2;
                        this.bMoveZ = mouseEvent.isAltDown();
                    } else {
                        this.iState = 1;
                        this.iMouseX = n;
                        this.iMouseY = n2;
                    }
                }
                if (this.iState == 1 || this.iState == 6 || this.iState == 7) {
                    this.selectMouseMotionListener = new SelectMouseMotionListener(n, n2);
                    ((Component)mouseEvent.getSource()).addMouseMotionListener(this.selectMouseMotionListener);
                }
            }
            if (bl) {
                MainFrame.getInstance().getJPatchScreen().single_update((Component)mouseEvent.getSource());
            }
        } else if (mouseEvent.getButton() == 3 && (this.iState == 2 || this.cpHot != null && this.iState == 3)) {
            Viewport viewport = (Viewport)mouseEvent.getSource();
            float[] fArray = new float[1];
            ControlPoint controlPoint = viewport.getViewDefinition().getClosestControlPoint(new Point2D.Float(mouseEvent.getX(), mouseEvent.getY()), this.cpHot, fArray, false, true);
            PointSelection pointSelection = MainFrame.getInstance().getPointSelection();
            if (controlPoint != null && controlPoint != this.cpHot.getPrev() && controlPoint != this.cpHot.getNext()) {
                if (fArray[0] == -1.0f) {
                    if (controlPoint.isSingle() || this.cpHot.isSingle()) {
                        this.compoundEdit.addEdit(new WeldControlPointsEdit(this.cpHot, controlPoint));
                        ArrayList<ControlPoint> arrayList = new ArrayList<ControlPoint>();
                        arrayList.add(this.cpHot);
                        this.compoundEdit.addEdit(new RemoveControlPointsFromSelectionEdit(pointSelection, arrayList));
                        arrayList.clear();
                        arrayList.add(controlPoint);
                        this.compoundEdit.addEdit(new AddControlPointsToSelectionEdit(pointSelection, arrayList));
                        this.compoundEdit.addEdit(new ChangeSelectionCPHotEdit(pointSelection, controlPoint));
                        MainFrame.getInstance().getJPatchScreen().full_update();
                        ((Component)mouseEvent.getSource()).removeMouseMotionListener(this);
                        MainFrame.getInstance().getUndoManager().addEdit(this.compoundEdit);
                        MainFrame.getInstance().getJPatchScreen().update_all();
                        this.iState = 0;
                    }
                } else if (this.iState == 2 && this.cpHot.isSingle()) {
                    if (!(this.cpHot.getPrev() != null && this.cpHot.getNext() != null || (this.cpHot.getPrev() == null || this.cpHot.getPrev().getNextAttached() != null && this.cpHot.getPrev().getNextAttached().isHook()) && this.cpHot.getNext().getNextAttached() != null && this.cpHot.getNext().getNextAttached().isHook() || this.cpHot.getChildHook() != null || this.cpHot.getPrev() != null && this.cpHot.getPrev().getChildHook() != null || controlPoint.getNext().getHead().isHook() || controlPoint.getHead().isHook() || controlPoint.hasHookAt(fArray[0]))) {
                        this.compoundEdit.addEdit(new HookEdit(this.cpHot, controlPoint, fArray[0]));
                        MainFrame.getInstance().getJPatchScreen().full_update();
                        ((Component)mouseEvent.getSource()).removeMouseMotionListener(this);
                        MainFrame.getInstance().getUndoManager().addEdit(this.compoundEdit);
                        MainFrame.getInstance().getJPatchScreen().update_all();
                    }
                    this.iState = 0;
                }
            }
        }
        if (this.iState == 0) {
            MainFrame.getInstance().getJPatchScreen().enablePopupMenu(true);
        } else {
            this.setActiveHelpText();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            PointSelection pointSelection = MainFrame.getInstance().getPointSelection();
            if ((this.iState == 1 || this.iState == 6 || this.iState == 7) && pointSelection != null) {
                if (mouseEvent.isControlDown()) {
                    this.iState = 7;
                }
                if (mouseEvent.isShiftDown()) {
                    this.iState = 6;
                }
            }
            switch (this.iState) {
                case 2: 
                case 3: {
                    this.compoundEdit.addEdit(new ChangeSelectionPivotEdit(pointSelection, this.p3Pivot, null));
                    MainFrame.getInstance().getUndoManager().addEdit(this.compoundEdit);
                    break;
                }
                case 4: {
                    MainFrame.getInstance().getUndoManager().addEdit(this.compoundEdit);
                    ((Component)mouseEvent.getSource()).removeMouseMotionListener(this.activeHandle);
                    break;
                }
                case 1: {
                    Selection selection = this.selectMouseMotionListener.getSelection(this.viewport.getViewDefinition());
                    if (selection != null || pointSelection != null) {
                        ChangeSelectionEdit changeSelectionEdit = new ChangeSelectionEdit(selection);
                        MainFrame.getInstance().getUndoManager().addEdit(changeSelectionEdit);
                    }
                    ((Component)mouseEvent.getSource()).removeMouseMotionListener(this.selectMouseMotionListener);
                    break;
                }
                case 6: {
                    PointSelection pointSelection2 = (PointSelection)this.selectMouseMotionListener.getSelection(this.viewport.getViewDefinition());
                    if (pointSelection2 != null) {
                        Collection collection = pointSelection2.getSelectedControlPoints();
                        if (pointSelection != null) {
                            collection.removeAll(pointSelection.getSelectedControlPoints());
                        }
                        this.compoundEdit.addEdit(new AddControlPointsToSelectionEdit(pointSelection, collection));
                        MainFrame.getInstance().getUndoManager().addEdit(this.compoundEdit);
                    }
                    ((Component)mouseEvent.getSource()).removeMouseMotionListener(this.selectMouseMotionListener);
                    break;
                }
                case 7: {
                    PointSelection pointSelection3 = (PointSelection)this.selectMouseMotionListener.getSelection(this.viewport.getViewDefinition());
                    if (pointSelection3 != null) {
                        Collection collection = pointSelection3.getSelectedControlPoints();
                        ArrayList arrayList = new ArrayList();
                        ArrayList<ControlPoint> arrayList2 = new ArrayList<ControlPoint>();
                        Collection collection2 = pointSelection.getSelectedControlPoints();
                        Iterator iterator = collection.iterator();
                        while (iterator.hasNext()) {
                            ControlPoint controlPoint = (ControlPoint)iterator.next();
                            arrayList2.add(controlPoint);
                        }
                        this.compoundEdit.addEdit(new AddControlPointsToSelectionEdit(pointSelection, arrayList));
                        this.compoundEdit.addEdit(new RemoveControlPointsFromSelectionEdit(pointSelection, arrayList2));
                        MainFrame.getInstance().getUndoManager().addEdit(this.compoundEdit);
                    }
                    ((Component)mouseEvent.getSource()).removeMouseMotionListener(this.selectMouseMotionListener);
                    break;
                }
                case 5: {
                    if (pointSelection.getPivot().equals(this.p3Pivot)) break;
                    MainFrame.getInstance().getUndoManager().addEdit(new ChangeSelectionPivotEdit(pointSelection, this.p3Pivot, null));
                    ((Component)mouseEvent.getSource()).removeMouseMotionListener(this.activeHandle);
                    break;
                }
                case 8: {
                    if (this.tangentHandle.getCp().getInMagnitude() != this.fMagnitude) {
                        MainFrame.getInstance().getUndoManager().addEdit(new ChangeControlPointMagnitudeEdit(this.tangentHandle.getCp(), this.fMagnitude));
                    }
                    ((Component)mouseEvent.getSource()).removeMouseMotionListener(this.tangentHandle);
                    break;
                }
            }
            ((Component)mouseEvent.getSource()).removeMouseMotionListener(this);
            MainFrame.getInstance().getJPatchScreen().update_all();
            this.iState = 0;
            if (MainFrame.getInstance().getPointSelection() == null) {
                MainFrame.getInstance().setHelpText("Drag to move or select points. Use ATL to move perpendicular to screen plane.");
            } else if (MainFrame.getInstance().getPointSelection().isSingle()) {
                MainFrame.getInstance().setHelpText("Use SHIFT or CTRL to modify selection. Use ATL to move perpendicular to screen plane. Press TAB to cycle through curve segments.");
            } else {
                MainFrame.getInstance().setHelpText("Drag inside box to move selection. Drag handles to scale. Use SHIFT or CTRL to modify selection, ATL to move perpendicular. Doubleclick pivot to reset.");
            }
        }
        if (this.iState == 0) {
            MainFrame.getInstance().getJPatchScreen().enablePopupMenu(true);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Viewport viewport = (Viewport)mouseEvent.getSource();
        int n = mouseEvent.getX() - this.iMouseX;
        int n2 = mouseEvent.getY() - this.iMouseY;
        Matrix4f matrix4f = new Matrix4f(viewport.getViewDefinition().getMatrix());
        matrix4f.invert();
        switch (this.iState) {
            case 3: {
                Vector3f vector3f = this.bMoveZ ? new Vector3f(0.0f, 0.0f, n2 - n) : new Vector3f(n, n2, 0.0f);
                matrix4f.transform(vector3f);
                this.translate(vector3f, viewport);
                break;
            }
            case 2: {
                Point3f point3f;
                Point3f point3f2 = this.cpHot.getPosition();
                viewport.getViewDefinition().setZ(point3f2);
                if (this.bMoveZ) {
                    point3f = new Point3f(this.cpHot.getPosition());
                    Vector3f vector3f = new Vector3f(0.0f, 0.0f, n2 - n);
                    matrix4f.transform(vector3f);
                    point3f.add(vector3f);
                } else {
                    point3f = viewport.getViewDefinition().get3DPosition(mouseEvent.getX(), mouseEvent.getY());
                }
                if ((!this.bMoveZ || !viewport.getGrid().correctZPosition(point3f2, point3f)) && !viewport.getGrid().correctPosition(point3f2, point3f)) break;
                MainFrame.getInstance().getConstraints().setControlPointPosition(this.cpHot, point3f);
                if (this.bMoveZ) {
                    MainFrame.getInstance().getJPatchScreen().update_all();
                    break;
                }
                MainFrame.getInstance().getJPatchScreen().single_update((Component)((Object)viewport));
                break;
            }
        }
    }

    protected void translate(Vector3f vector3f, Viewport viewport) {
        PointSelection pointSelection = MainFrame.getInstance().getPointSelection();
        Point3f point3f = new Point3f();
        ControlPoint[] controlPointArray = pointSelection.getControlPointArray();
        Vector3f vector3f2 = new Vector3f(vector3f);
        if (this.bMoveZ) {
            viewport.getGrid().correctZVector(vector3f2);
        } else {
            viewport.getGrid().correctVector(vector3f2);
        }
        if (this.cpHot != null) {
            if (this.bMoveZ) {
                vector3f2.add(viewport.getGrid().getZCorrectionVector(this.cpHot.getPosition()));
            } else {
                vector3f2.add(viewport.getGrid().getCorrectionVector(this.cpHot.getPosition()));
            }
        }
        if (!vector3f2.equals(this.v3Move)) {
            this.v3Move.set(vector3f2);
            int n = 0;
            while (n < controlPointArray.length) {
                point3f.add(this.ap3[n], vector3f2);
                MainFrame.getInstance().getConstraints().setControlPointPosition(controlPointArray[n], point3f);
                ++n;
            }
            Point3f point3f2 = new Point3f(this.p3Pivot);
            point3f2.add(vector3f2);
            MainFrame.getInstance().getConstraints().setPointPosition(pointSelection.getPivot(), point3f2);
            if (this.bMoveZ) {
                MainFrame.getInstance().getJPatchScreen().update_all();
            } else {
                MainFrame.getInstance().getJPatchScreen().single_update((Component)((Object)viewport));
            }
        }
    }

    protected void scale(float f, Viewport viewport) {
        PointSelection pointSelection = MainFrame.getInstance().getPointSelection();
        Point3f point3f = new Point3f();
        ControlPoint[] controlPointArray = pointSelection.getControlPointArray();
        int n = 0;
        while (n < controlPointArray.length) {
            point3f.sub(this.ap3[n], pointSelection.getPivot());
            point3f.scale(f);
            point3f.add(pointSelection.getPivot());
            MainFrame.getInstance().getConstraints().setControlPointPosition(controlPointArray[n], point3f);
            ++n;
        }
        MainFrame.getInstance().getJPatchScreen().single_update((Component)((Object)viewport));
    }

    private final /* synthetic */ void this() {
        this.comparator = new HandleZOrderComparator();
        this.p3Pivot = new Point3f();
        this.v3Move = new Vector3f();
        this.tangentTool = MainFrame.getInstance().getJPatchScreen().getTangentTool();
    }

    public DefaultTool() {
        this.this();
        this.pivotHandle = new PivotHandle2(this.settings.cSelection);
        this.aHandle = new Handle[]{new DefaultHandle(this, new Point3f(), this.settings.cSelection), new DefaultHandle(this, new Point3f(), this.settings.cSelection), new DefaultHandle(this, new Point3f(), this.settings.cSelection), new DefaultHandle(this, new Point3f(), this.settings.cSelection), new DefaultHandle(this, new Point3f(), this.settings.cSelection), new DefaultHandle(this, new Point3f(), this.settings.cSelection), new DefaultHandle(this, new Point3f(), this.settings.cSelection), new DefaultHandle(this, new Point3f(), this.settings.cSelection), this.pivotHandle};
        if (MainFrame.getInstance().getPointSelection() == null) {
            MainFrame.getInstance().setHelpText("Drag to move or select points. Use ATL to move perpendicular to screen plane.");
        } else if (MainFrame.getInstance().getPointSelection().isSingle()) {
            MainFrame.getInstance().setHelpText("Use SHIFT or CTRL to modify selection. Use ATL to move perpendicular to screen plane. Press TAB to cycle through curve segments.");
        } else {
            MainFrame.getInstance().setHelpText("Drag inside box to move selection. Drag handles to scale. Use SHIFT or CTRL to modify selection, ATL to move perpendiclar. Doubleclick pivot to reset.");
        }
    }
}

