/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary.mouse;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import jpatch.boundary.Viewport;
import jpatch.boundary.mouse.JPatchMouseAdapter;

public class MoveZoomRotateMouseAdapter
extends JPatchMouseAdapter {
    private static final int MOVE = 1;
    private static final int ROTATE = 2;
    private int iMouseX;
    private int iMouseY;
    private float fMin;
    private int iState;

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 2) {
            ((Component)mouseEvent.getSource()).addMouseMotionListener(this);
            this.iMouseX = mouseEvent.getX();
            this.iMouseY = mouseEvent.getY();
            int n = this.iMouseX - 40;
            int n2 = this.iMouseY - ((Component)mouseEvent.getSource()).getHeight() + 40;
            this.iState = n * n + n2 * n2 > 2500 && !((Viewport)mouseEvent.getSource()).getViewDefinition().isLocked() ? 1 : 2;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 2) {
            ((Component)mouseEvent.getSource()).removeMouseMotionListener(this);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() - this.iMouseX;
        int n2 = mouseEvent.getY() - this.iMouseY;
        this.iMouseX = mouseEvent.getX();
        this.iMouseY = mouseEvent.getY();
        switch (this.iState) {
            case 1: {
                int n3 = ((Component)mouseEvent.getSource()).getWidth();
                int n4 = ((Component)mouseEvent.getSource()).getHeight();
                this.fMin = n3 / 2;
                ((Viewport)mouseEvent.getSource()).getViewDefinition().moveView((float)n / this.fMin, (float)n2 / this.fMin);
                break;
            }
            case 2: {
                ((Viewport)mouseEvent.getSource()).getViewDefinition().rotateView((float)n / 200.0f, (float)n2 / 200.0f);
                break;
            }
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        float f = 1.0f - (float)n / 10.0f;
        if ((double)f < 0.2) {
            f = 0.2f;
        }
        if (f > (float)5) {
            f = 5;
        }
        ((Viewport)mouseWheelEvent.getSource()).getViewDefinition().scaleView(f);
    }
}

