/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary.mouse;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.vecmath.Point3f;
import jpatch.boundary.MainFrame;
import jpatch.boundary.ViewDefinition;
import jpatch.boundary.Viewport;
import jpatch.boundary.mouse.JPatchMouseAdapter;
import jpatch.boundary.selection.PointSelection;
import jpatch.boundary.selection.Selection;
import jpatch.control.edit.ComplexAppendControlPointsEdit;
import jpatch.control.edit.CreateCurveEdit;
import jpatch.control.edit.HookEdit;
import jpatch.control.edit.JPatchCompoundEdit;
import jpatch.control.edit.WeldControlPointsEdit;
import jpatch.entity.ControlPoint;
import jpatch.entity.Curve;
import jpatch.entity.JPatchException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AddControlPointMouseAdapter
extends JPatchMouseAdapter {
    private static int IDLE = 0;
    private static int ACTIVE = 1;
    private int iMouseX;
    private int iMouseY;
    private JPatchCompoundEdit compoundEdit;
    private ControlPoint cpHot;
    private int iState;
    private boolean bMulti;
    private Component compSource;
    private Viewport viewport;

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.compSource = (Component)mouseEvent.getSource();
            this.viewport = (Viewport)((Object)this.compSource);
            this.viewport.getViewDefinition().setZ(0.0f);
            this.iMouseX = mouseEvent.getX();
            this.iMouseY = mouseEvent.getY();
            this.compoundEdit = new JPatchCompoundEdit("add");
            ControlPoint controlPoint = this.viewport.getViewDefinition().getClosestControlPoint(new Point2D.Float(this.iMouseX, this.iMouseY), null, null, false, true);
            if (controlPoint == null || controlPoint.getLooseEnd() != null) {
                if (controlPoint != null) {
                    this.viewport.getViewDefinition().setZ(controlPoint.getPosition());
                }
                Point3f point3f = this.viewport.getViewDefinition().get3DPosition(this.iMouseX, this.iMouseY);
                this.viewport.getGrid().correctVector(point3f);
                ControlPoint controlPoint2 = new ControlPoint(point3f);
                ControlPoint controlPoint3 = new ControlPoint(point3f);
                controlPoint2.setNext(controlPoint3);
                controlPoint3.setPrev(controlPoint2);
                Curve curve = new Curve(controlPoint2, MainFrame.getInstance().getModel());
                curve.validate();
                this.compoundEdit.addEdit(new CreateCurveEdit(curve));
                if (controlPoint != null && controlPoint.getLooseEnd() != null) {
                    this.compoundEdit.addEdit(new ComplexAppendControlPointsEdit(controlPoint2, controlPoint.getLooseEnd()));
                }
                PointSelection pointSelection = new PointSelection(controlPoint3);
                MainFrame.getInstance().setSelection(pointSelection);
                MainFrame.getInstance().getJPatchScreen().single_update(this.compSource);
                this.cpHot = controlPoint3;
            } else {
                this.viewport.getViewDefinition().setZ(controlPoint.getPosition());
                ControlPoint controlPoint4 = new ControlPoint(controlPoint);
                ControlPoint controlPoint5 = new ControlPoint(controlPoint);
                controlPoint4.setNext(controlPoint5);
                controlPoint5.setPrev(controlPoint4);
                Curve curve = new Curve(controlPoint4, MainFrame.getInstance().getModel());
                curve.validate();
                this.compoundEdit.addEdit(new CreateCurveEdit(curve));
                this.compoundEdit.addEdit(new WeldControlPointsEdit(controlPoint4, controlPoint));
                PointSelection pointSelection = new PointSelection(controlPoint5);
                MainFrame.getInstance().setSelection(pointSelection);
                MainFrame.getInstance().getJPatchScreen().single_update(this.compSource);
                this.cpHot = controlPoint5;
            }
            this.setActiveState();
        } else if (this.iState == ACTIVE && mouseEvent.getButton() == 3) {
            this.compSource = (Component)mouseEvent.getSource();
            Viewport viewport = (Viewport)mouseEvent.getSource();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            float[] fArray = new float[1];
            ControlPoint controlPoint = viewport.getViewDefinition().getClosestControlPoint(new Point2D.Float(n, n2), this.cpHot, fArray, false, true);
            if (controlPoint != null && controlPoint != this.cpHot.getPrev()) {
                if (fArray[0] == -1.0f) {
                    this.compoundEdit.addEdit(new WeldControlPointsEdit(this.cpHot, controlPoint));
                    ((PointSelection)MainFrame.getInstance().getSelection()).removeControlPoint(this.cpHot);
                    MainFrame.getInstance().getJPatchScreen().full_update();
                    this.setIdleState();
                } else if (!(controlPoint.getNext().getHead().isHook() || controlPoint.getHead().isHook() || controlPoint.hasHookAt(fArray[0]))) {
                    this.compoundEdit.addEdit(new HookEdit(this.cpHot, controlPoint, fArray[0]));
                    ((PointSelection)MainFrame.getInstance().getSelection()).removeControlPoint(this.cpHot);
                    MainFrame.getInstance().getJPatchScreen().full_update();
                    this.setIdleState();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.iState == ACTIVE && mouseEvent.getButton() == 1) {
            Selection selection = MainFrame.getInstance().getSelection();
            Class clazz = PointSelection.getPointSelectionClass();
            if (selection != null && clazz.isAssignableFrom(selection.getClass())) {
                ControlPoint[] controlPointArray = new ControlPoint[]{this.cpHot};
            }
            MainFrame.getInstance().getJPatchScreen().full_update();
            this.setIdleState();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() - this.iMouseX;
        int n2 = mouseEvent.getY() - this.iMouseY;
        this.iMouseX = mouseEvent.getX();
        this.iMouseY = mouseEvent.getY();
        ViewDefinition viewDefinition = this.viewport.getViewDefinition();
        Point3f point3f = viewDefinition.get3DPosition(this.iMouseX, this.iMouseY);
        this.viewport.getGrid().correctVector(point3f);
        this.cpHot.setPosition(point3f);
        MainFrame.getInstance().getJPatchScreen().single_update(this.compSource);
    }

    private final void setActiveState() {
        if (this.iState != IDLE) {
            throw new JPatchException("setActiveState() called in active state");
        }
        this.compSource.addMouseMotionListener(this);
        MainFrame.getInstance().getJPatchScreen().enablePopupMenu(false);
        this.iState = ACTIVE;
        MainFrame.getInstance().setHelpText("Drag to move curve-end. Press right mouse button to weld to closest point");
    }

    private final void setIdleState() {
        if (this.iState != ACTIVE) {
            throw new JPatchException("setActiveState() called in active state");
        }
        this.compSource.removeMouseMotionListener(this);
        MainFrame.getInstance().getUndoManager().addEdit(this.compoundEdit);
        MainFrame.getInstance().getJPatchScreen().enablePopupMenu(true);
        this.iState = IDLE;
        MainFrame.getInstance().setHelpText("Click to add curve segment. Click near existing point to weld new curve segment to it");
        if (!this.bMulti) {
            MainFrame.getInstance().getMeshToolBar().reset();
        }
    }

    private final /* synthetic */ void this() {
        this.iState = IDLE;
        this.bMulti = false;
    }

    public AddControlPointMouseAdapter(boolean bl) {
        this();
        this.bMulti = bl;
    }

    public AddControlPointMouseAdapter() {
        this.this();
        MainFrame.getInstance().setHelpText("Click to add curve segment. Click near existing point to weld new curve segment to it");
    }
}

