/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary.action;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import jpatch.boundary.MainFrame;
import jpatch.boundary.ViewDefinition;
import jpatch.boundary.Viewport;
import jpatch.boundary.selection.PointSelection;
import jpatch.entity.ControlPoint;

public final class ZoomToFitAction
extends AbstractAction {
    public final void actionPerformed(ActionEvent actionEvent) {
        ZoomToFitAction.zoomToFit(MainFrame.getInstance().getJPatchScreen().getActiveViewport());
    }

    public static final void zoomToFit(Viewport viewport) {
        int n;
        ControlPoint[] controlPointArray;
        ViewDefinition viewDefinition = viewport.getViewDefinition();
        PointSelection pointSelection = MainFrame.getInstance().getPointSelection();
        float f = Float.MAX_VALUE;
        float f2 = -3.4028235E38f;
        float f3 = Float.MAX_VALUE;
        float f4 = -3.4028235E38f;
        Point3f point3f = new Point3f();
        Matrix4f matrix4f = viewDefinition.getMatrix();
        boolean bl = true;
        if (pointSelection != null && !pointSelection.isSingle()) {
            controlPointArray = pointSelection.getControlPointArray();
            n = 0;
            while (n < controlPointArray.length) {
                if (controlPointArray[n].isHead()) {
                    point3f.set(controlPointArray[n].getPosition());
                    matrix4f.transform(point3f);
                    if (point3f.x < f) {
                        f = point3f.x;
                    }
                    if (point3f.x > f2) {
                        f2 = point3f.x;
                    }
                    if (point3f.y < f3) {
                        f3 = point3f.y;
                    }
                    if (point3f.y > f4) {
                        f4 = point3f.y;
                    }
                }
                ++n;
            }
        } else {
            controlPointArray = MainFrame.getInstance().getModel().allHeads();
            n = 0;
            Iterator iterator = controlPointArray.iterator();
            while (iterator.hasNext()) {
                ControlPoint controlPoint = (ControlPoint)iterator.next();
                if (controlPoint.isHidden()) continue;
                point3f.set(controlPoint.getPosition());
                matrix4f.transform(point3f);
                if (point3f.x < f) {
                    f = point3f.x;
                }
                if (point3f.x > f2) {
                    f2 = point3f.x;
                }
                if (point3f.y < f3) {
                    f3 = point3f.y;
                }
                if (point3f.y > f4) {
                    f4 = point3f.y;
                }
                ++n;
            }
            boolean bl2 = false;
            if (n >= 2) {
                bl2 = bl = true;
            }
        }
        if (bl) {
            float f5 = (f + f2) / 2.0f;
            float f6 = (f4 + f3) / 2.0f;
            float f7 = viewDefinition.getWidth() / 2.0f;
            float f8 = viewDefinition.getHeight() / 2.0f;
            float f9 = f2 - f5;
            float f10 = f4 - f6;
            if (f9 > 0.0f || f10 > 0.0f) {
                float f11 = f7 / f9;
                float f12 = f8 / f10;
                float f13 = Math.min(f11, f12) * 0.9f;
                viewDefinition.setLock(null);
                viewDefinition.moveView(-f5 / f7 + 1.0f, (f8 - f6) / f7, false);
                viewDefinition.scaleView(f13);
            }
        }
    }

    public ZoomToFitAction() {
        super("", new ImageIcon(ClassLoader.getSystemResource("jpatch/images/zoomtofit.png")));
        this.putValue("ShortDescription", "Zoom to fit");
    }
}

