/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary.action;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import jpatch.boundary.MainFrame;
import jpatch.boundary.selection.PointSelection;
import jpatch.control.edit.ChangeControlPointTangentModeEdit;
import jpatch.control.edit.JPatchCompoundEdit;
import jpatch.entity.ControlPoint;

public final class RoundAction
extends AbstractAction {
    public final void actionPerformed(ActionEvent actionEvent) {
        PointSelection pointSelection = MainFrame.getInstance().getPointSelection();
        if (pointSelection != null && pointSelection.isCurve()) {
            MainFrame.getInstance().getUndoManager().addEdit(new ChangeControlPointTangentModeEdit(pointSelection.getControlPoint(), 4));
            MainFrame.getInstance().getJPatchScreen().update_all();
        } else if (pointSelection != null) {
            JPatchCompoundEdit jPatchCompoundEdit = new JPatchCompoundEdit();
            ControlPoint[] controlPointArray = pointSelection.getControlPointArray();
            int n = 0;
            while (n < controlPointArray.length) {
                ControlPoint[] controlPointArray2 = controlPointArray[n].getStack();
                int n2 = 0;
                while (n2 < controlPointArray2.length) {
                    jPatchCompoundEdit.addEdit(new ChangeControlPointTangentModeEdit(controlPointArray2[n2], 4));
                    ++n2;
                }
                ++n;
            }
            MainFrame.getInstance().getUndoManager().addEdit(jPatchCompoundEdit);
            MainFrame.getInstance().getJPatchScreen().update_all();
        }
        ControlPoint.setDefaultMode(4);
    }

    public RoundAction() {
        super("", new ImageIcon(ClassLoader.getSystemResource("jpatch/images/round.png")));
        this.putValue("ShortDescription", "Round");
    }
}

