/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.tree.DefaultTreeModel;
import jpatch.auxilary.JPatchUtils;
import jpatch.boundary.JPatchSettings;
import jpatch.boundary.MainFrame;
import jpatch.boundary.action.SaveAsAction;
import jpatch.boundary.filefilters.AMFilter;
import jpatch.boundary.filefilters.JPatchFilter;
import jpatch.boundary.filefilters.SPatchFilter;
import jpatch.boundary.selection.PointSelection;
import jpatch.control.ModelImporter;
import jpatch.control.importer.AnimationMasterImport;
import jpatch.control.importer.JPatchImport;
import jpatch.control.importer.SPatchImport;
import jpatch.entity.ControlPoint;
import jpatch.entity.Model;

public final class ImportJPatchAction
extends AbstractAction {
    private boolean bNewModel;

    public final void actionPerformed(ActionEvent actionEvent) {
        block6: {
            block5: {
                if (!this.bNewModel || !MainFrame.getInstance().getUndoManager().hasChanged()) break block5;
                int n = JPatchUtils.showSaveDialog();
                switch (n) {
                    case 0: {
                        SaveAsAction saveAsAction = new SaveAsAction(false);
                        if (saveAsAction.save()) {
                            this.load();
                            break;
                        }
                        break block6;
                    }
                    case 1: {
                        this.load();
                    }
                }
                break block6;
            }
            this.load();
        }
    }

    private final void load() {
        JFileChooser jFileChooser = new JFileChooser(JPatchSettings.getInstance().strJPatchPath);
        JPatchFilter jPatchFilter = new JPatchFilter();
        jFileChooser.addChoosableFileFilter(jPatchFilter);
        jFileChooser.addChoosableFileFilter(new AMFilter());
        jFileChooser.addChoosableFileFilter(new SPatchFilter());
        jFileChooser.setFileFilter(jPatchFilter);
        if (jFileChooser.showOpenDialog(MainFrame.getInstance()) == 0) {
            ModelImporter modelImporter;
            String string;
            File file = jFileChooser.getSelectedFile();
            String string2 = file.getPath();
            if (this.bNewModel) {
                MainFrame.getInstance().NEW();
            }
            if ((string = JPatchUtils.getFileExtension(string2)).equals("spt")) {
                modelImporter = new SPatchImport();
                JPatchSettings.getInstance().strJPatchPath = file.getParent();
            } else if (string.equals("mdl")) {
                modelImporter = new AnimationMasterImport();
                JPatchSettings.getInstance().strJPatchPath = file.getParent();
            } else {
                modelImporter = new JPatchImport();
                JPatchSettings.getInstance().strJPatchPath = file.getParent();
                JPatchSettings.getInstance().strJPatchFile = string2;
            }
            if (!this.bNewModel) {
                Model model = MainFrame.getInstance().getModel();
                String string3 = model.getName();
                ArrayList arrayList = model.allHeads();
                modelImporter.importModel(model, string2);
                PointSelection pointSelection = new PointSelection();
                Iterator iterator = model.allHeads().iterator();
                while (iterator.hasNext()) {
                    ControlPoint controlPoint = (ControlPoint)iterator.next();
                    if (arrayList.contains(controlPoint)) continue;
                    pointSelection.addControlPoint(controlPoint);
                }
                pointSelection.setName(file.getName());
                model.addSelection(pointSelection);
                model.setName(string3);
                MainFrame.getInstance().setSelection(pointSelection);
                MainFrame.getInstance().getUndoManager().clear();
            } else {
                modelImporter.importModel(MainFrame.getInstance().getModel(), string2);
            }
        }
        ((DefaultTreeModel)MainFrame.getInstance().getTree().getModel()).reload();
        MainFrame.getInstance().getJPatchScreen().zoomToFit_all();
    }

    public ImportJPatchAction() {
        this(true);
    }

    public ImportJPatchAction(boolean bl) {
        super("", new ImageIcon(ClassLoader.getSystemResource("jpatch/images/open.png")));
        this.bNewModel = bl;
        this.putValue("ShortDescription", this.bNewModel ? "Open a new model" : "Merge models");
    }
}

