/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import jpatch.boundary.KeyMapping;
import jpatch.boundary.MainFrame;
import jpatch.boundary.selection.PointSelection;
import jpatch.control.edit.ChangeSelectionEdit;
import jpatch.control.edit.DeleteControlPointEdit;
import jpatch.control.edit.JPatchCompoundEdit;
import jpatch.control.edit.RemovePatchFromModelEdit;
import jpatch.entity.ControlPoint;
import jpatch.entity.Patch;

public final class DeleteControlPointAction
extends AbstractAction {
    public final void actionPerformed(ActionEvent actionEvent) {
        PointSelection pointSelection = MainFrame.getInstance().getPointSelection();
        if (pointSelection != null) {
            JPatchCompoundEdit jPatchCompoundEdit = new JPatchCompoundEdit();
            if (pointSelection.isCurve()) {
                return;
            }
            ControlPoint[] controlPointArray = pointSelection.getControlPointArray();
            int n = 0;
            while (n < controlPointArray.length) {
                if (!controlPointArray[n].isHook()) {
                    ControlPoint[] controlPointArray2 = controlPointArray[n].getStack();
                    int n2 = 0;
                    while (n2 < controlPointArray2.length) {
                        if (controlPointArray2[n2].getCurve() != null) {
                            Patch patch;
                            Iterator iterator;
                            ArrayList arrayList;
                            ControlPoint controlPoint = controlPointArray2[n2].getChildHook();
                            while (controlPoint != null) {
                                arrayList = MainFrame.getInstance().getModel().getPatchesContaining(controlPoint);
                                iterator = arrayList.iterator();
                                while (iterator.hasNext()) {
                                    patch = (Patch)iterator.next();
                                    if (patch.getModel() == null) continue;
                                    jPatchCompoundEdit.addEdit(new RemovePatchFromModelEdit(patch));
                                }
                                controlPoint = controlPoint.getNext();
                            }
                            if (controlPointArray2[n2].getPrev() != null) {
                                controlPoint = controlPointArray2[n2].getPrev().getChildHook();
                                while (controlPoint != null) {
                                    arrayList = MainFrame.getInstance().getModel().getPatchesContaining(controlPoint);
                                    iterator = arrayList.iterator();
                                    while (iterator.hasNext()) {
                                        patch = (Patch)iterator.next();
                                        if (patch.getModel() == null) continue;
                                        jPatchCompoundEdit.addEdit(new RemovePatchFromModelEdit(patch));
                                    }
                                    controlPoint = controlPoint.getNext();
                                }
                            }
                            jPatchCompoundEdit.addEdit(new DeleteControlPointEdit(controlPointArray2[n2]));
                            arrayList = MainFrame.getInstance().getModel().getPatchesContaining(controlPointArray2[n2]);
                            iterator = arrayList.iterator();
                            while (iterator.hasNext()) {
                                patch = (Patch)iterator.next();
                                if (patch.getModel() == null) continue;
                                jPatchCompoundEdit.addEdit(new RemovePatchFromModelEdit(patch));
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            jPatchCompoundEdit.addEdit(new ChangeSelectionEdit(null));
            MainFrame.getInstance().getUndoManager().addEdit(jPatchCompoundEdit);
            MainFrame.getInstance().getJPatchScreen().update_all();
        }
    }

    public DeleteControlPointAction() {
        super("", new ImageIcon(ClassLoader.getSystemResource("jpatch/images/deletepoint.png")));
        this.putValue("ShortDescription", KeyMapping.getDescription("delete points"));
    }
}

