/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import jpatch.entity.MaterialProperties;

public class SimpleShape {
    Point3f[] ap3Points;
    Vector3f[] av3Normals;
    int[] aiTriangles;
    int[] aiNormalIndices;
    MaterialProperties mp;

    public Point3f[] getPoints() {
        Point3f[] point3fArray = new Point3f[this.ap3Points.length];
        int n = 0;
        while (n < this.ap3Points.length) {
            point3fArray[n] = new Point3f(this.ap3Points[n]);
            ++n;
        }
        return point3fArray;
    }

    public Vector3f[] getNormals() {
        Vector3f[] vector3fArray = new Vector3f[this.av3Normals.length];
        int n = 0;
        while (n < this.av3Normals.length) {
            vector3fArray[n] = new Vector3f(this.av3Normals[n]);
            ++n;
        }
        return vector3fArray;
    }

    public int[] getTriangles() {
        return this.aiTriangles;
    }

    public int[] getNormalIndices() {
        return this.aiNormalIndices;
    }

    public MaterialProperties getMaterialProperties() {
        return this.mp;
    }

    public void setPoints(Point3f[] point3fArray) {
        this.ap3Points = point3fArray;
    }

    public void setNormals(Vector3f[] vector3fArray) {
        this.av3Normals = vector3fArray;
    }

    public void setTriangles(int[] nArray) {
        this.aiTriangles = nArray;
    }

    public void setNormalIndices(int[] nArray) {
        this.aiNormalIndices = nArray;
    }

    public void setMaterialProperties(MaterialProperties materialProperties) {
        this.mp = materialProperties;
    }

    public void transform(Matrix4f matrix4f) {
        int n = 0;
        while (n < this.ap3Points.length) {
            matrix4f.transform(this.ap3Points[n]);
            ++n;
        }
        n = 0;
        while (n < this.av3Normals.length) {
            matrix4f.transform(this.av3Normals[n]);
            this.av3Normals[n].normalize();
            ++n;
        }
    }

    public void transform(Matrix3f matrix3f) {
        int n = 0;
        while (n < this.ap3Points.length) {
            matrix3f.transform(this.ap3Points[n]);
            ++n;
        }
        n = 0;
        while (n < this.av3Normals.length) {
            matrix3f.transform(this.av3Normals[n]);
            this.av3Normals[n].normalize();
            ++n;
        }
    }

    public void translate(Vector3f vector3f) {
        int n = 0;
        while (n < this.ap3Points.length) {
            this.ap3Points[n].add(vector3f);
            ++n;
        }
    }

    public void setColor(float f, float f2, float f3) {
        this.mp = new MaterialProperties();
        this.mp.red = f;
        this.mp.green = f2;
        this.mp.blue = f3;
        this.mp.ambient = 0.4f;
        this.mp.diffuse = 0.9f;
        this.mp.specular = 0.3f;
        this.mp.roughness = 0.01f;
    }

    public static SimpleShape createCube(float f, float f2, float f3, float f4) {
        SimpleShape simpleShape = new SimpleShape();
        simpleShape.setColor(f2, f3, f4);
        simpleShape.setCube(f);
        return simpleShape;
    }

    public static SimpleShape createArrow(float f, float f2, float f3, float f4, float f5) {
        SimpleShape simpleShape = new SimpleShape();
        simpleShape.setColor(f3, f4, f5);
        simpleShape.setArrow(f, f2);
        return simpleShape;
    }

    public void setArrow(float f, float f2) {
        this.ap3Points = new Point3f[]{new Point3f(-f2, -f2, f), new Point3f(f2, -f2, f), new Point3f(f2, f2, f), new Point3f(-f2, f2, f), new Point3f(0.0f, 0.0f, 0.0f)};
        this.av3Normals = new Vector3f[]{new Vector3f(0.0f, f, -f2), new Vector3f(-f, 0.0f, -f2), new Vector3f(0.0f, -f, -f2), new Vector3f(f, 0.0f, -f2), new Vector3f(0.0f, 0.0f, 1.0f)};
        int[] nArray = new int[18];
        nArray[0] = 4;
        nArray[1] = 2;
        nArray[2] = 3;
        nArray[3] = 4;
        nArray[4] = 3;
        nArray[6] = 4;
        nArray[8] = 1;
        nArray[9] = 4;
        nArray[10] = 1;
        nArray[11] = 2;
        nArray[12] = 2;
        nArray[13] = 1;
        nArray[16] = 3;
        nArray[17] = 2;
        this.aiTriangles = nArray;
        int[] nArray2 = new int[6];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 4;
        this.aiNormalIndices = nArray2;
    }

    public void setCube(float f) {
        this.ap3Points = new Point3f[]{new Point3f(-f, -f, -f), new Point3f(f, -f, -f), new Point3f(f, -f, f), new Point3f(-f, -f, f), new Point3f(-f, f, -f), new Point3f(f, f, -f), new Point3f(f, f, f), new Point3f(-f, f, f)};
        this.av3Normals = new Vector3f[]{new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f)};
        int[] nArray = new int[36];
        nArray[1] = 1;
        nArray[2] = 5;
        nArray[3] = 5;
        nArray[4] = 4;
        nArray[6] = 1;
        nArray[7] = 2;
        nArray[8] = 6;
        nArray[9] = 6;
        nArray[10] = 5;
        nArray[11] = 1;
        nArray[12] = 2;
        nArray[13] = 3;
        nArray[14] = 7;
        nArray[15] = 7;
        nArray[16] = 6;
        nArray[17] = 2;
        nArray[18] = 3;
        nArray[20] = 4;
        nArray[21] = 7;
        nArray[22] = 4;
        nArray[23] = 3;
        nArray[24] = 4;
        nArray[25] = 5;
        nArray[26] = 6;
        nArray[27] = 6;
        nArray[28] = 7;
        nArray[29] = 4;
        nArray[31] = 3;
        nArray[32] = 2;
        nArray[33] = 2;
        nArray[34] = 1;
        this.aiTriangles = nArray;
        int[] nArray2 = new int[12];
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[4] = 2;
        nArray2[5] = 2;
        nArray2[6] = 3;
        nArray2[7] = 3;
        nArray2[8] = 4;
        nArray2[9] = 4;
        nArray2[10] = 5;
        nArray2[11] = 5;
        this.aiNormalIndices = nArray2;
    }
}

