/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import jpatch.entity.MaterialProperties;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RealtimeRaytracer
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final float SQRT2INV = 1.0f / (float)Math.sqrt(2);
    private static final int MAX_TRACE_LEVEL = 2;
    private final Vector3f v3Camera;
    private final Vector3f v3SphereCenter;
    private final Vector3f v3Light;
    private final Color3f c3BackgroundColor;
    private final float fSphereRadius = 1.0f;
    private final float fSphereRadius2 = 1.0f;
    private MaterialProperties materialProperties;
    private Color3f c3Color;
    private Matrix4f m4Matrix;
    private Matrix4f m4View;
    private Vector3f v3Cam;
    private Vector3f v3Ray;
    private Color3f c3Pixel;
    private float fIor;
    private float fIor2;
    private float fInvIor;
    private float fInvIor2;
    private int iMouseX;
    private int iMouseY;
    private float fRotX;
    private float fRotY;
    private boolean bLoRes;

    public void setLoRes(boolean bl) {
        this.bLoRes = bl;
    }

    private final void filterColor(Color3f color3f, Color3f color3f2) {
        color3f.x *= color3f2.x;
        color3f.y *= color3f2.y;
        color3f.z *= color3f2.z;
    }

    private final Color3f rayPlaneIntersection(Vector3f vector3f, Vector3f vector3f2) {
        Color3f color3f = new Color3f(this.c3BackgroundColor);
        float f = (1.0f - vector3f.y) / vector3f2.y;
        if (f > 0.0f) {
            Point3f point3f = new Point3f(vector3f2);
            point3f.scale(f);
            point3f.add(vector3f);
            if (((float)Math.floor(point3f.x * 2.0f) + (float)Math.floor(point3f.z * 2.0f)) % 2.0f == 0.0f) {
                color3f.set(1.0f, 1.0f, 1.0f);
            } else {
                color3f.set(0.0f, 0.0f, 0.0f);
            }
            float f2 = point3f.x * SQRT2INV + SQRT2INV;
            float f3 = f2 * f2;
            float f4 = point3f.z * point3f.z;
            if (f3 + f4 < 1.0f) {
                Color3f color3f2 = new Color3f(color3f);
                color3f2.scale(this.materialProperties.transmit * 0.7f);
                Color3f color3f3 = new Color3f(color3f);
                color3f3.x *= this.c3Color.x * this.materialProperties.filter * 0.7f;
                color3f3.y *= this.c3Color.y * this.materialProperties.filter * 0.7f;
                color3f3.z *= this.c3Color.z * this.materialProperties.filter * 0.7f;
                color3f.scale(0.3f);
                color3f.add(color3f3);
                color3f.add(color3f2);
            }
            color3f.interpolate(this.c3BackgroundColor, 1.0f - 1.0f / (point3f.x * point3f.x * 0.1f + f4 * 0.1f + 1.0f));
        }
        return color3f;
    }

    private final Color3f raySphereIntersection(Vector3f vector3f, Vector3f vector3f2, int n, boolean bl) {
        float f;
        Tuple3f tuple3f;
        float f2;
        float f3;
        if (n++ > 2) {
            return new Color3f();
        }
        Color3f color3f = new Color3f();
        Vector3f vector3f3 = new Vector3f(vector3f);
        vector3f3.sub(this.v3SphereCenter);
        float f4 = vector3f2.dot(vector3f2);
        float f5 = vector3f2.dot(vector3f3);
        float f6 = vector3f3.dot(vector3f3);
        float f7 = f5 * f5 - f4 * (f6 - 1.0f);
        if (f7 < 0.0f) {
            return this.rayPlaneIntersection(vector3f, vector3f2);
        }
        Vector3f vector3f4 = new Vector3f();
        Vector3f vector3f5 = new Vector3f();
        float f8 = -f5 + (float)Math.sqrt(f7);
        float f9 = -f5 - (float)Math.sqrt(f7);
        float f10 = bl ? (f8 > f9 ? f8 / f4 : f9 / f4) : (f8 < f9 ? f8 / f4 : f9 / f4);
        vector3f4.scaleAdd(f10, vector3f2, vector3f);
        vector3f5.sub(vector3f4, this.v3SphereCenter);
        vector3f5.normalize();
        if (bl) {
            vector3f5.scale(-1.0f);
        }
        float f11 = (f3 = vector3f5.dot(this.v3Light)) > 0.0f ? (float)Math.pow(f3, this.materialProperties.brilliance) * this.materialProperties.diffuse + this.materialProperties.ambient : this.materialProperties.ambient;
        float f12 = 1.0f - this.materialProperties.transmit - this.materialProperties.filter;
        color3f.scale(f11 * f12, this.c3Color);
        Vector3f vector3f6 = new Vector3f(this.v3Light);
        vector3f6.sub(vector3f2);
        vector3f6.scale(1.0f / (float)Math.sqrt(vector3f6.dot(vector3f6)));
        vector3f6.normalize();
        float f13 = vector3f6.dot(vector3f5);
        float f14 = f13 > 0.0f ? (float)Math.pow(f13, 1.0f / this.materialProperties.roughness) * this.materialProperties.specular : 0.0f;
        Color3f color3f2 = new Color3f(1.0f, 1.0f, 1.0f);
        color3f2.interpolate(this.c3Color, this.materialProperties.metallic);
        color3f2.scale(f14);
        color3f.add(color3f2);
        float f15 = 0.0f;
        if (this.materialProperties.reflectionMax > 0.0f || this.materialProperties.reflectionMin > 0.0f) {
            f2 = 1.0f + vector3f2.dot(vector3f5);
            f15 = this.materialProperties.reflectionMin + (float)Math.pow(f2, this.materialProperties.reflectionFalloff) * (this.materialProperties.reflectionMax - this.materialProperties.reflectionMin);
            Vector3f vector3f7 = new Vector3f();
            vector3f7.scale(-2.0f * vector3f2.dot(vector3f5), vector3f5);
            vector3f7.add(vector3f2);
            tuple3f = bl ? this.raySphereIntersection(vector3f4, vector3f7, n, true) : this.rayPlaneIntersection(vector3f4, vector3f7);
            Color3f color3f3 = new Color3f((Color3f)tuple3f);
            this.filterColor(color3f3, this.c3Color);
            tuple3f.interpolate(color3f3, this.materialProperties.metallic);
            tuple3f.scale(f15);
            color3f.add(tuple3f);
        }
        if (this.materialProperties.conserveEnergy) {
            f2 = this.materialProperties.transmit * (1.0f - f15);
            f = this.materialProperties.filter * (1.0f - f15);
        } else {
            f2 = this.materialProperties.transmit;
            f = this.materialProperties.filter;
        }
        if (f2 > 0.0f || f > 0.0f) {
            tuple3f = new Vector3f();
            if (this.materialProperties.refraction > 0.0f) {
                tuple3f = new Vector3f();
                float f16 = -vector3f2.dot(vector3f5);
                float f17 = bl ? this.fIor : this.fInvIor;
                float f18 = bl ? this.fIor2 : this.fInvIor2;
                f7 = 1.0f - f18 * (1.0f - f16 * f16);
                if (f7 > 0.0f) {
                    float f19 = (float)Math.sqrt(f7);
                    tuple3f.set(vector3f2);
                    tuple3f.scale(f17);
                    Vector3f vector3f8 = new Vector3f(vector3f5);
                    vector3f8.scale(f17 * f16 - f19);
                    tuple3f.add(vector3f8);
                } else {
                    System.out.println(f7);
                    System.exit(-1);
                    tuple3f.scale(-2.0f * vector3f2.dot(vector3f5), vector3f5);
                    tuple3f.add(vector3f2);
                }
            } else {
                tuple3f.set(vector3f2);
            }
            Color3f color3f4 = new Color3f();
            color3f4 = bl ? this.rayPlaneIntersection(vector3f4, (Vector3f)tuple3f) : this.raySphereIntersection(vector3f4, (Vector3f)tuple3f, n, true);
            Color3f color3f5 = new Color3f(this.c3Color);
            color3f5.x *= color3f4.x * f;
            color3f5.y *= color3f4.y * f;
            color3f5.z *= color3f4.z * f;
            color3f4.scale(f2);
            color3f.add(color3f4);
            color3f.add(color3f5);
        }
        return color3f;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.v3Cam.set(this.v3Camera);
        this.m4View.rotY(this.fRotY);
        this.m4Matrix.rotX(this.fRotX);
        this.m4View.mul(this.m4Matrix);
        this.m4View.transform(this.v3Cam);
        this.fIor = this.materialProperties.refraction;
        this.fIor2 = this.fIor * this.fIor;
        this.fInvIor = 1.0f / this.fIor;
        this.fInvIor2 = this.fInvIor * this.fInvIor;
        this.c3Color.set(this.materialProperties.red, this.materialProperties.green, this.materialProperties.blue);
        if (this.bLoRes) {
            int n = 0;
            while (n < 80) {
                int n2 = 0;
                while (n2 < 80) {
                    float f = ((float)n2 - 40.0f) / 150.0f;
                    float f2 = ((float)n - 40.0f) / 150.0f;
                    this.v3Ray.set(f, f2, 1.0f);
                    this.m4View.transform(this.v3Ray);
                    this.v3Ray.normalize();
                    this.c3Pixel = this.raySphereIntersection(this.v3Cam, this.v3Ray, 0, false);
                    this.c3Pixel.clamp(0.0f, 1.0f);
                    graphics.setColor(this.c3Pixel.get());
                    graphics.fillRect(n2 + n2, n + n, 2, 2);
                    ++n2;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < 160) {
                int n3 = 0;
                while (n3 < 160) {
                    float f = ((float)n3 - 80.0f) / 300.0f;
                    float f3 = ((float)n - 80.0f) / 300.0f;
                    this.v3Ray.set(f, f3, 1.0f);
                    this.m4View.transform(this.v3Ray);
                    this.v3Ray.normalize();
                    this.c3Pixel = this.raySphereIntersection(this.v3Cam, this.v3Ray, 0, false);
                    this.c3Pixel.clamp(0.0f, 1.0f);
                    graphics.setColor(this.c3Pixel.get());
                    graphics.drawLine(n3, n, n3, n);
                    ++n3;
                }
                ++n;
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.iMouseX = mouseEvent.getX();
        this.iMouseY = mouseEvent.getY();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() - this.iMouseX;
        int n2 = mouseEvent.getY() - this.iMouseY;
        this.iMouseX = mouseEvent.getX();
        this.iMouseY = mouseEvent.getY();
        this.fRotX -= (float)n2 / 150.0f;
        this.fRotY += (float)n / 150.0f;
        this.fRotX = Math.min(0.15f, this.fRotX);
        this.fRotX = (float)Math.max(-1.5707963267948966, (double)this.fRotX);
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private final /* synthetic */ void this() {
        this.v3Camera = new Vector3f(0.0f, 0.0f, -5.0f);
        this.v3SphereCenter = new Vector3f(0.0f, 0.0f, 0.0f);
        this.v3Light = new Vector3f(1.0f, -1.0f, 0.0f);
        this.c3BackgroundColor = new Color3f(0.5f, 0.5f, 0.5f);
        this.c3Color = new Color3f();
        this.m4Matrix = new Matrix4f();
        this.m4View = new Matrix4f();
        this.v3Cam = new Vector3f();
        this.v3Ray = new Vector3f();
        this.c3Pixel = new Color3f();
        this.fRotX = -0.2f;
        this.fRotY = -2.3561945f;
        this.bLoRes = true;
    }

    public RealtimeRaytracer(MaterialProperties materialProperties) {
        this.this();
        this.materialProperties = materialProperties;
        this.v3Light.normalize();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        Dimension dimension = new Dimension(160, 160);
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
    }
}

