/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JPatchSlider
extends JComponent
implements ChangeListener,
ActionListener,
FocusListener {
    public static final int LINEAR = 1;
    public static final int EXPONENTIAL = 2;
    private static final Color RED = new Color(255, 0, 0);
    private static final Color WHITE = new Color(255, 255, 255);
    private static NumberFormat defaultNumberFormat = new DecimalFormat("##0.00");
    private static int LABEL = 90;
    private static int HEIGHT = 20;
    private static int SLIDER = 100;
    private static int TEXT = 50;
    private static Dimension dimLabel = new Dimension(LABEL, HEIGHT);
    private static Dimension dimSlider = new Dimension(SLIDER, HEIGHT);
    private static Dimension dimText = new Dimension(TEXT, HEIGHT);
    private String strLabel;
    private float fMin;
    private float fMax;
    private float fSliderMin;
    private float fSliderMax;
    private float fValue;
    private int iScaling;
    private JLabel label;
    private JSlider slider;
    private JTextField textField;
    private boolean bUpdate;
    private NumberFormat numberFormat;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public static void setNumberFormat(NumberFormat numberFormat) {
        defaultNumberFormat = numberFormat;
    }

    public static void setDimensions(int n, int n2, int n3, int n4) {
        LABEL = n;
        SLIDER = n2;
        TEXT = n3;
        HEIGHT = n4;
        dimLabel = new Dimension(LABEL, HEIGHT);
        dimSlider = new Dimension(SLIDER, HEIGHT);
        dimText = new Dimension(TEXT, HEIGHT);
    }

    public void setRange(float f, float f2) {
        this.fMin = f;
        this.fMax = f2;
        this.fSliderMin = f;
        this.fSliderMax = f2;
        this.updateSlider();
    }

    public void setEnabled(boolean bl) {
        this.label.setEnabled(bl);
        this.slider.setEnabled(bl);
        this.textField.setEnabled(bl);
    }

    public void addChangeListener(ChangeListener changeListener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JPatchSlider.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.add(clazz, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JPatchSlider.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.remove(clazz, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JPatchSlider.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        return (ChangeListener[])this.listenerList.getListeners(clazz);
    }

    public float getValue() {
        return this.fValue;
    }

    public void setValue(float f) {
        this.fValue = f;
        this.updateSlider();
        this.updateTextField();
    }

    protected void updateSlider() {
        this.bUpdate = false;
        this.slider.setValue(this.sliderPosition());
        this.bUpdate = true;
    }

    protected void updateTextField() {
        this.textField.setText(this.numberFormat.format(this.fValue));
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            Object object = objectArray[n];
            Class clazz = class$javax$swing$event$ChangeListener;
            if (clazz == null) {
                clazz = JPatchSlider.class("[Ljavax.swing.event.ChangeListener;", false);
            }
            if (object == clazz) {
                ChangeEvent changeEvent = new ChangeEvent(this);
                ((ChangeListener)objectArray[n + 1]).stateChanged(changeEvent);
            }
            n -= 2;
        }
    }

    protected int sliderPosition() {
        int n = 0;
        switch (this.iScaling) {
            case 1: {
                n = (int)((this.fValue - this.fSliderMin) / (this.fSliderMax - this.fSliderMin) * (float)SLIDER);
                break;
            }
            case 2: {
                n = (int)(Math.log(this.fValue / this.fMin) / Math.log(this.fMax / this.fMin) * (double)SLIDER);
                break;
            }
        }
        if (n < 0) {
            n = 0;
        } else if (n > SLIDER) {
            n = SLIDER;
        }
        return n;
    }

    protected float sliderValue() {
        switch (this.iScaling) {
            case 1: {
                return this.fMin + (float)this.slider.getValue() * (this.fMax - this.fMin) / (float)SLIDER;
            }
            case 2: {
                return (float)(Math.exp((double)((float)this.slider.getValue() / (float)SLIDER) * Math.log(this.fMax / this.fMin)) * (double)this.fMin);
            }
        }
        return -1.0f;
    }

    protected void clampValue() {
        if (this.fValue < this.fMin) {
            this.fValue = this.fMin;
        } else if (this.fValue > this.fMax) {
            this.fValue = this.fMax;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.fValue = this.numberFormat.parse(this.textField.getText()).floatValue();
            this.textField.setBackground(WHITE);
        }
        catch (ParseException parseException) {
            this.fValue = 0.0f;
            this.textField.setBackground(RED);
        }
        this.updateTextField();
        this.updateSlider();
        this.fireStateChanged();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.bUpdate) {
            this.fValue = this.sliderValue();
            this.updateTextField();
            this.fireStateChanged();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.actionPerformed(new ActionEvent(this, 1001, ""));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.bUpdate = true;
        this.numberFormat = defaultNumberFormat;
    }

    public JPatchSlider(String string, float f, float f2, float f3) {
        this(string, f, f2, f3, 1);
    }

    public JPatchSlider(String string, float f, float f2, float f3, int n) {
        this.this();
        this.strLabel = string;
        this.fMin = f;
        this.fMax = f2;
        this.fSliderMin = f;
        this.fSliderMax = f2;
        this.fValue = f3;
        this.iScaling = n;
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        this.label = new JLabel(this.strLabel);
        this.slider = new JSlider(0, SLIDER);
        this.slider.setFocusable(false);
        this.textField = new JTextField();
        springLayout.putConstraint("West", (Component)this.label, 0, "West", (Component)this);
        springLayout.putConstraint("West", (Component)this.slider, 0, "East", (Component)this.label);
        springLayout.putConstraint("West", (Component)this.textField, 0, "East", (Component)this.slider);
        springLayout.putConstraint("East", (Component)this.textField, 0, "East", (Component)this);
        this.updateTextField();
        this.updateSlider();
        this.slider.addChangeListener(this);
        this.textField.addActionListener(this);
        this.textField.addFocusListener(this);
        this.add(this.label);
        this.add(this.slider);
        this.add(this.textField);
        this.label.setPreferredSize(dimLabel);
        this.slider.setPreferredSize(dimSlider);
        this.textField.setPreferredSize(dimText);
    }
}

