/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.image.VolatileImage;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import jpatch.boundary.JPatchDrawable;
import jpatch.boundary.JPatchSettings;
import jpatch.boundary.Lighting;
import jpatch.boundary.SimpleShape;
import jpatch.entity.ControlPoint;
import jpatch.entity.Curve;
import jpatch.entity.MaterialProperties;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class JPatchDrawableJava2D
implements JPatchDrawable {
    private Graphics2D g2;
    private VolatileImage volatileImage;
    private Lighting lighting;
    private JPatchSettings settings;

    public final void setLighting(Lighting lighting) {
        this.lighting = lighting;
    }

    public final Lighting getLighting() {
        return this.lighting;
    }

    public final Graphics getGraphics() {
        return this.g2;
    }

    public final Image getImage() {
        return this.volatileImage;
    }

    public final void clear() {
        this.g2.setBackground(this.settings.cBackground);
        this.g2.clearRect(0, 0, this.volatileImage.getWidth(), this.volatileImage.getHeight());
    }

    public final void clearZBuffer() {
    }

    public final void setColor(Color color) {
        this.g2.setColor(color);
    }

    public final void setColor(int n) {
        this.g2.setColor(new Color(n));
    }

    public final void drawRect(int n, int n2, int n3, int n4) {
        this.g2.drawLine(n, n2, n3, n2);
        this.g2.drawLine(n3, n2, n3, n4);
        this.g2.drawLine(n3, n4, n, n4);
        this.g2.drawLine(n, n4, n, n2);
    }

    public final void drawLine(int n, int n2, int n3, int n4) {
        this.g2.drawLine(n, n2, n3, n4);
    }

    public final void drawLine3D(Point3f point3f, Point3f point3f2) {
        this.g2.drawLine((int)point3f.x, (int)point3f.y, (int)point3f2.x, (int)point3f2.y);
    }

    public final void drawGhostLine3D(Point3f point3f, Point3f point3f2, int n) {
        this.g2.drawLine((int)point3f.x, (int)point3f.y, (int)point3f2.x, (int)point3f2.y);
    }

    public final void drawPoint3D(Point3f point3f, int n) {
        this.g2.fillRect((int)point3f.x - n, (int)point3f.y - n, n * 2 + 1, n * 2 + 1);
    }

    public final void drawXPoint3D(Point3f point3f) {
        int n = (int)point3f.x;
        int n2 = (int)point3f.y;
        int[] nArray = new int[]{n, n + 3, n, n - 2};
        int[] nArray2 = new int[]{n2 - 3, n2, n2 + 3, n2};
        this.g2.fillPolygon(nArray, nArray2, 4);
    }

    public final void drawSimpleShape(SimpleShape simpleShape, Matrix4f matrix4f) {
        int n;
        Point3f[] point3fArray = simpleShape.getPoints();
        Vector3f[] vector3fArray = simpleShape.getNormals();
        int[] nArray = simpleShape.getTriangles();
        int[] nArray2 = simpleShape.getNormalIndices();
        MaterialProperties materialProperties = simpleShape.getMaterialProperties();
        int n2 = nArray.length / 3;
        if (matrix4f != null) {
            n = 0;
            while (n < point3fArray.length) {
                matrix4f.transform(point3fArray[n]);
                ++n;
            }
            n = 0;
            while (n < vector3fArray.length) {
                matrix4f.transform(vector3fArray[n]);
                vector3fArray[n].normalize();
                ++n;
            }
        }
        n = 0;
        int n3 = 0;
        while (n3 < n2) {
            Vector3f vector3f = vector3fArray[nArray2[n3]];
            if (vector3f.z < 0.0f) {
                this.g2.setColor(new Color(this.lighting.shade(null, vector3f, materialProperties)));
                this.g2.fillPolygon(this.setPoly(point3fArray[nArray[n++]], point3fArray[nArray[n++]], point3fArray[nArray[n++]]));
            } else {
                n += 3;
            }
            ++n3;
        }
    }

    private final Polygon setPoly(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        nArray[0] = (int)point3f.x;
        nArray[1] = (int)point3f2.x;
        nArray[2] = (int)point3f3.x;
        nArray2[0] = (int)point3f.y;
        nArray2[1] = (int)point3f2.y;
        nArray2[2] = (int)point3f3.y;
        return new Polygon(nArray, nArray2, 3);
    }

    public final void drawCurveSegment(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
        this.g2.draw(new CubicCurve2D.Float(point3f.x, point3f.y, point3f2.x, point3f2.y, point3f3.x, point3f3.y, point3f4.x, point3f4.y));
    }

    public final void drawJPatchCurve3D(Curve curve, Matrix4f matrix4f) {
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f();
        Point3f point3f3 = new Point3f();
        Point3f point3f4 = new Point3f();
        GeneralPath generalPath = new GeneralPath();
        ControlPoint controlPoint = curve.getStart();
        while (controlPoint != null && controlPoint.isHidden()) {
            controlPoint = controlPoint.getNextCheckNextLoop();
        }
        if (controlPoint != null && controlPoint.getNext() != null) {
            point3f.set(controlPoint.getPosition());
            point3f2.set(controlPoint.getOutTangent());
            matrix4f.transform(point3f);
            matrix4f.transform(point3f2);
            generalPath.moveTo(point3f.x, point3f.y);
            controlPoint = controlPoint.getNext();
            while (controlPoint != null) {
                if (controlPoint.isHidden()) {
                    while (controlPoint != null && controlPoint.isHidden()) {
                        controlPoint = controlPoint.getNextCheckLoop();
                    }
                    if (controlPoint == null) break;
                    point3f4.set(controlPoint.getPosition());
                    matrix4f.transform(point3f4);
                    generalPath.moveTo(point3f4.x, point3f4.y);
                } else {
                    point3f3.set(controlPoint.getInTangent());
                    point3f4.set(controlPoint.getPosition());
                    matrix4f.transform(point3f3);
                    matrix4f.transform(point3f4);
                    generalPath.curveTo(point3f2.x, point3f2.y, point3f3.x, point3f3.y, point3f4.x, point3f4.y);
                }
                ControlPoint controlPoint2 = controlPoint.getNextCheckLoop();
                if (controlPoint2 != null) {
                    point3f2.set(controlPoint.getOutTangent());
                    matrix4f.transform(point3f2);
                }
                controlPoint = controlPoint2;
            }
            this.g2.draw(generalPath);
        }
    }

    public final void drawBicubicPatchPhong(Point3f[] point3fArray, MaterialProperties materialProperties) {
    }

    public final void drawBicubicPatchGourad(Point3f[] point3fArray, MaterialProperties materialProperties) {
    }

    public final void drawBicubicPatchFlat(Point3f[] point3fArray, MaterialProperties materialProperties) {
    }

    public final void drawHashPatchGourad(Point3f[] point3fArray, Vector3f[] vector3fArray, int[] nArray, MaterialProperties materialProperties) {
    }

    public final void drawHashPatchFlat(Point3f[] point3fArray, int[] nArray, MaterialProperties materialProperties) {
    }

    private final /* synthetic */ void this() {
        this.settings = JPatchSettings.getInstance();
    }

    public JPatchDrawableJava2D(VolatileImage volatileImage, Lighting lighting) {
        this.this();
        this.volatileImage = volatileImage;
        this.g2 = (Graphics2D)volatileImage.getGraphics();
        this.g2.setBackground(this.settings.cBackground);
        this.lighting = lighting;
    }
}

