/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.BScrollPane;
import buoy.widget.BSlider;
import buoy.widget.BTabbedPane;
import buoy.widget.BTextArea;
import buoy.widget.BTextField;
import buoy.widget.ColumnContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.TextWidget;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Font;
import java.awt.Window;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import jpatch.boundary.Animator;
import jpatch.boundary.BuoyUtils;
import jpatch.entity.AnimLight;
import jpatch.entity.AnimModel;
import jpatch.entity.AnimObject;
import jpatch.entity.Camera;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AnimObjectEditor
extends BDialog {
    private AnimObject animObject;
    private BTextField textName;
    private BTextField textPosX;
    private BTextField textPosY;
    private BTextField textPosZ;
    private BTextField textRoll;
    private BTextField textPitch;
    private BTextField textYaw;
    private BTextField textScale;
    private BTextField textFocalLength;
    private BTextField textIntensity;
    private BTextField textSize;
    private BSlider sliderSubdiv;
    private BCheckBox cbActive;
    private BuoyUtils.ColorSelector colorSelector;
    private FormContainer form;
    private BTextArea textRib;
    private BTextArea textPov;
    static /* synthetic */ Class class$buoy$event$WindowClosingEvent;
    static /* synthetic */ Class class$buoy$event$CommandEvent;

    private final void set() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        try {
            d = Double.parseDouble(this.textPosX.getText());
            d2 = Double.parseDouble(this.textPosY.getText());
            d3 = Double.parseDouble(this.textPosZ.getText());
            d4 = Double.parseDouble(this.textRoll.getText()) / 180.0 * Math.PI;
            d5 = Double.parseDouble(this.textPitch.getText()) / 180.0 * Math.PI;
            d6 = Double.parseDouble(this.textYaw.getText()) / 180.0 * Math.PI;
            if (this.animObject instanceof Camera) {
                f4 = Float.parseFloat(this.textFocalLength.getText());
                Camera camera = (Camera)this.animObject;
                camera.setName(this.textName.getText());
                camera.setPosition(new Point3d(d, d2, d3));
                camera.setOrientation(d4, d5, d6);
                camera.setFocalLength(f4);
            } else if (this.animObject instanceof AnimModel) {
                AnimModel animModel = (AnimModel)this.animObject;
                f = Float.parseFloat(this.textScale.getText());
                animModel.setName(this.textName.getText());
                animModel.setPosition(new Point3d(d, d2, d3));
                animModel.setOrientation(d4, d5, d6);
                animModel.setScale(f);
                animModel.setRenderString("povray", "", this.textPov.getText());
                animModel.setRenderString("renderman", "", this.textRib.getText());
                animModel.setSubdivisionOffset(this.sliderSubdiv.getValue());
            } else if (this.animObject instanceof AnimLight) {
                AnimLight animLight = (AnimLight)this.animObject;
                f2 = Float.parseFloat(this.textSize.getText());
                f3 = Float.parseFloat(this.textIntensity.getText());
                animLight.setName(this.textName.getText());
                animLight.setPosition(new Point3d(d, d2, d3));
                animLight.setOrientation(d4, d5, d6);
                animLight.setSize(f2);
                animLight.setIntensity(f3);
                animLight.setActive(this.cbActive.getState());
                if (!animLight.getColor().get().equals(this.colorSelector.getColor())) {
                    animLight.setColor(new Color3f(this.colorSelector.getColor()));
                }
                animLight.setRenderString("povray", "", this.textPov.getText());
                animLight.setRenderString("renderman", "", this.textRib.getText());
            }
            Animator.getInstance().updateCurvesFor(this.animObject);
            this.dispose();
            Animator.getInstance().rerenderViewports();
        }
        catch (Exception exception) {}
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public AnimObjectEditor(AnimObject animObject, WindowWidget windowWidget) {
        super(windowWidget, "Edit " + animObject.getName() + " at frame " + (Animator.getInstance().getPosition() + 1.0f), true);
        Widget widget;
        Cloneable cloneable;
        Object object;
        this.animObject = animObject;
        BTabbedPane bTabbedPane = null;
        this.textName = new BTextField(this.animObject.getName(), 20);
        this.textPosX = new BTextField("" + this.animObject.getPosition().x, 20);
        this.textPosY = new BTextField("" + this.animObject.getPosition().y, 20);
        this.textPosZ = new BTextField("" + this.animObject.getPosition().z, 20);
        this.textRoll = new BTextField("" + this.animObject.getRoll() * 180.0 / Math.PI, 20);
        this.textPitch = new BTextField("" + this.animObject.getPitch() * 180.0 / Math.PI, 20);
        this.textYaw = new BTextField("" + this.animObject.getYaw() * 180.0 / Math.PI, 20);
        if (this.animObject instanceof Camera) {
            this.form = new FormContainer(2, 9);
            object = (Camera)this.animObject;
            this.textFocalLength = new BTextField("" + ((Camera)object).getFocalLength(), 20);
        } else if (this.animObject instanceof AnimModel) {
            this.form = new FormContainer(2, 10);
            object = (AnimModel)this.animObject;
            this.sliderSubdiv = new BSlider(((AnimModel)object).getSubdivisionOffset(), -2, 2, BSlider.HORIZONTAL);
            this.sliderSubdiv.setSnapToTicks(true);
            this.sliderSubdiv.setMinorTickSpacing(1);
            this.sliderSubdiv.setMajorTickSpacing(1);
            this.sliderSubdiv.setShowTicks(true);
            this.sliderSubdiv.setShowLabels(true);
            cloneable = new Hashtable();
            ((Dictionary)((Object)cloneable)).put(new Integer(-2), new JLabel("-2"));
            ((Dictionary)((Object)cloneable)).put(new Integer(-1), new JLabel("-1"));
            ((Dictionary)((Object)cloneable)).put(new Integer(0), new JLabel("0"));
            ((Dictionary)((Object)cloneable)).put(new Integer(1), new JLabel("+1"));
            ((Dictionary)((Object)cloneable)).put(new Integer(2), new JLabel("+2"));
            ((JSlider)this.sliderSubdiv.getComponent()).setLabelTable((Dictionary)((Object)cloneable));
            this.textScale = new BTextField("" + ((AnimObject)object).getScale(), 20);
            this.textRib = new BTextArea(((AnimModel)object).getRenderString("renderman", ""), 10, 80);
            this.textPov = new BTextArea(((AnimModel)object).getRenderString("povray", ""), 10, 80);
            this.textRib.setFont(new Font("Monospaced", 0, 12));
            this.textPov.setFont(new Font("Monospaced", 0, 12));
            bTabbedPane = new BTabbedPane();
            bTabbedPane.add(new BScrollPane(this.textPov), "POV-Ray");
            bTabbedPane.add(new BScrollPane(this.textRib), "RenderMan");
        } else if (this.animObject instanceof AnimLight) {
            this.form = new FormContainer(2, 12);
            object = (AnimLight)this.animObject;
            this.cbActive = new BCheckBox("", ((AnimLight)object).isActive());
            this.textIntensity = new BTextField("" + ((AnimLight)object).getIntensity(), 20);
            this.textSize = new BTextField("" + ((AnimLight)object).getSize(), 20);
            this.colorSelector = new BuoyUtils.ColorSelector(((AnimLight)object).getColor().get(), this);
            this.textRib = new BTextArea(((AnimLight)object).getRenderString("renderman", ""), 10, 80);
            this.textPov = new BTextArea(((AnimLight)object).getRenderString("povray", ""), 10, 80);
            this.textRib.setFont(new Font("Monospaced", 0, 12));
            this.textPov.setFont(new Font("Monospaced", 0, 12));
            bTabbedPane = new BTabbedPane();
            bTabbedPane.add(new BScrollPane(this.textPov), "POV-Ray");
            bTabbedPane.add(new BScrollPane(this.textRib), "RenderMan");
        }
        object = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE);
        cloneable = new LayoutInfo(LayoutInfo.NORTHWEST, LayoutInfo.NONE);
        int n = 0;
        this.form.add(new BLabel("Name:    "), 0, n, (LayoutInfo)object);
        this.form.add(this.textName, 1, n++, (LayoutInfo)cloneable);
        if (this.animObject instanceof AnimLight) {
            this.form.add(new BLabel("Number:    "), 0, n, (LayoutInfo)object);
            widget = new BTextField("" + ((AnimLight)this.animObject).getNumber(), 20);
            ((TextWidget)widget).setEditable(false);
            this.form.add(widget, 1, n++, (LayoutInfo)cloneable);
        }
        this.form.add(new BLabel("Position X:    "), 0, n, (LayoutInfo)object);
        this.form.add(this.textPosX, 1, n++, (LayoutInfo)cloneable);
        this.form.add(new BLabel("Position Y:    "), 0, n, (LayoutInfo)object);
        this.form.add(this.textPosY, 1, n++, (LayoutInfo)cloneable);
        this.form.add(new BLabel("Position Z:    "), 0, n, (LayoutInfo)object);
        this.form.add(this.textPosZ, 1, n++, (LayoutInfo)cloneable);
        this.form.add(new BLabel("Roll:    "), 0, n, (LayoutInfo)object);
        this.form.add(this.textRoll, 1, n++, (LayoutInfo)cloneable);
        this.form.add(new BLabel("Pitch:    "), 0, n, (LayoutInfo)object);
        this.form.add(this.textPitch, 1, n++, (LayoutInfo)cloneable);
        this.form.add(new BLabel("Yaw:    "), 0, n, (LayoutInfo)object);
        this.form.add(this.textYaw, 1, n++, (LayoutInfo)cloneable);
        if (this.animObject instanceof Camera) {
            this.form.add(new BLabel("Focal Length:    "), 0, n, (LayoutInfo)object);
            this.form.add(this.textFocalLength, 1, n++, (LayoutInfo)cloneable);
        } else if (this.animObject instanceof AnimModel) {
            this.form.add(new BLabel("Scale:    "), 0, n, (LayoutInfo)object);
            this.form.add(this.textScale, 1, n++, (LayoutInfo)cloneable);
            this.form.add(new BLabel("Subdivision offset:    "), 0, n, (LayoutInfo)object);
            this.form.add(this.sliderSubdiv, 1, n++, (LayoutInfo)cloneable);
        } else if (this.animObject instanceof AnimLight) {
            this.form.add(new BLabel("Size:    "), 0, n, (LayoutInfo)object);
            this.form.add(this.textSize, 1, n++, (LayoutInfo)cloneable);
            this.form.add(new BLabel("Intensity:    "), 0, n, (LayoutInfo)object);
            this.form.add(this.textIntensity, 1, n++, (LayoutInfo)cloneable);
            this.form.add(new BLabel("Color:    "), 0, n, (LayoutInfo)object);
            this.form.add(this.colorSelector, 1, n++, (LayoutInfo)cloneable);
            this.form.add(new BLabel("Turned on:    "), 0, n, (LayoutInfo)object);
            this.form.add(this.cbActive, 1, n++, (LayoutInfo)cloneable);
        }
        widget = new RowContainer();
        BButton bButton = new BButton("OK");
        BButton bButton2 = new BButton("Cancel");
        ((RowContainer)widget).add(bButton);
        ((RowContainer)widget).add(bButton2);
        ColumnContainer columnContainer = new ColumnContainer();
        columnContainer.add(this.form);
        if (bTabbedPane != null) {
            columnContainer.add(bTabbedPane);
        }
        columnContainer.add(widget);
        this.setContent(columnContainer);
        this.pack();
        ((Window)this.getComponent()).setLocationRelativeTo(windowWidget.getComponent());
        Class clazz = class$buoy$event$WindowClosingEvent;
        if (clazz == null) {
            clazz = class$buoy$event$WindowClosingEvent = AnimObjectEditor.class("[Lbuoy.event.WindowClosingEvent;", false);
        }
        this.addEventLink(clazz, (Object)this, "dispose");
        Class clazz2 = class$buoy$event$CommandEvent;
        if (clazz2 == null) {
            clazz2 = class$buoy$event$CommandEvent = AnimObjectEditor.class("[Lbuoy.event.CommandEvent;", false);
        }
        bButton2.addEventLink(clazz2, (Object)this, "dispose");
        Class clazz3 = class$buoy$event$CommandEvent;
        if (clazz3 == null) {
            clazz3 = class$buoy$event$CommandEvent = AnimObjectEditor.class("[Lbuoy.event.CommandEvent;", false);
        }
        bButton.addEventLink(clazz3, (Object)this, "set");
        this.setResizable(false);
        this.setVisible(true);
    }
}

