/*
 * Decompiled with CFR 0.152.
 */
package jpatch.auxilary;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ReadTiff {
    private static final int BYTE = 1;
    private static final int ASCII = 2;
    private static final int SHORT = 3;
    private static final int LONG = 4;
    private static final int RATIONAL = 5;
    private static final int LSB_TAG = 18761;
    private static final int MSB_TAG = 19789;
    private static final int NEW_SUBFILE_TYPE = 254;
    private static final int SUBFILE_TYPE = 255;
    private static final int IMAGE_WIDTH = 256;
    private static final int IMAGE_LENGTH = 257;
    private static final int BITS_PER_SAMPLE = 258;
    private static final int COMPRESSION = 259;
    private static final int UNCOMPRESSED = 1;
    private static final int CCITT_1D = 2;
    private static final int GROUP_3_FAX = 3;
    private static final int GROUP_4_FAX = 4;
    private static final int LZW = 5;
    private static final int JPEG = 6;
    private static final int PACKBITS = 32773;
    private static final int PHOTOMETRIC = 262;
    private static final int WHITEISZERO = 0;
    private static final int BLACKISZERO = 1;
    private static final int RGB = 2;
    private static final int RGB_PALETTE = 3;
    private static final int TRANSPARENCY_MASK = 4;
    private static final int CYMK = 5;
    private static final int YCBCR = 6;
    private static final int CIELAB = 8;
    private static final int THRESHOLDING = 263;
    private static final int CELL_WIDTH = 264;
    private static final int CELL_LENGTH = 265;
    private static final int FILL_ORDER = 266;
    private static final int DOCUMENT_NAME = 269;
    private static final int IMAGE_DESCRIPTION = 270;
    private static final int MAKE = 271;
    private static final int MODEL = 272;
    private static final int STRIP_OFFSETS = 273;
    private static final int ORIENTATION = 274;
    private static final int SAMPLES_PER_PIXEL = 277;
    private static final int ROWS_PER_STRIP = 278;
    private static final int STRIP_BYTE_COUNTS = 279;
    private static final int MIN_SAMPLE_VALUE = 280;
    private static final int MAX_SAMPLE_VALUE = 281;
    private static final int X_RESOLUTION = 282;
    private static final int Y_RESOLUTION = 283;
    private static final int PLANAR_CONFIGURATION = 284;
    private static final int PAGE_NAME = 285;
    private static final int X_POSITION = 286;
    private static final int Y_POSITION = 287;
    private static final int FREE_OFFSETS = 288;
    private static final int FREE_BYTE_COUNTS = 289;
    private static final int GRAY_RESPONSE_UNIT = 290;
    private static final int GRAY_RESPONSE_CURVE = 291;
    private static final int T4_OPTIONS = 292;
    private static final int T6_OPTIONS = 293;
    private static final int RESOLUTION_UNIT = 296;
    private static final int PAGE_NUMBER = 297;
    private static final int TRANSFER_FUNCTION = 301;
    private static final int SOFTWARE = 305;
    private static final int DATE_TIME = 306;
    private static final int ARTIST = 307;
    private static final int PREDICTOR = 317;
    private static final int COLOR_MAP = 320;
    private int[] buffer;
    private int bufferAt;
    private boolean lsb;
    private int imageLength;
    private int imageWidth;
    private int stripOffsets;
    private int[] stripOffsetsTable;
    private int stripByteCounts;
    private int[] stripByteCountsTable;
    private int rowsPerStrip;
    private int strips;

    public final Image loadImage(File file) throws Exception {
        this.readFileToBuffer(file);
        this.readHeader();
        this.readDirEntries();
        this.readStripOffsets();
        this.readStripByteCounts();
        return this.createImage();
    }

    private final Image createImage() {
        BufferedImage bufferedImage = new BufferedImage(this.imageWidth, this.imageLength, 1);
        Graphics graphics = bufferedImage.getGraphics();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.strips) {
            n2 = 0;
            int n4 = this.stripOffsetsTable[n3];
            int n5 = n4 + this.stripByteCountsTable[n3] + 1;
            int n6 = n4;
            while (n6 < n5) {
                graphics.setColor(new Color(this.buffer[n6], this.buffer[n6 + 1], this.buffer[n6 + 2]));
                graphics.drawRect(n2, n, 1, 1);
                if (++n2 >= this.imageWidth) {
                    n2 = 0;
                    if (++n > this.imageLength) break;
                }
                n6 += 3;
            }
            ++n3;
        }
        return bufferedImage;
    }

    private final void readFileToBuffer(String string) throws Exception {
        this.readFileToBuffer(new File(string));
    }

    private final void readFileToBuffer(File file) throws Exception {
        int n = (int)file.length();
        this.buffer = new int[n];
        FileInputStream fileInputStream = new FileInputStream(file);
        int n2 = 0;
        while (n2 < n) {
            this.buffer[n2] = fileInputStream.read();
            ++n2;
        }
        fileInputStream.close();
    }

    private final void readHeader() throws Exception {
        switch (this.readWord()) {
            case 18761: {
                this.lsb = true;
                break;
            }
            case 19789: {
                this.lsb = false;
                break;
            }
            default: {
                throw new Exception("Error in header LSB/MSB flag");
            }
        }
        if (this.readWord() != 42) {
            throw new Exception("Error in version number");
        }
        this.bufferAt = this.readDouble();
    }

    private final void readDirEntries() throws Exception {
        int n = this.readWord();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.readWord();
            int n4 = this.readWord();
            int n5 = this.readDouble();
            int n6 = this.readDouble();
            switch (n3) {
                case 256: {
                    this.imageWidth = n6;
                    break;
                }
                case 257: {
                    this.imageLength = n6;
                    break;
                }
                case 259: {
                    if (n6 == 1) break;
                    throw new Exception("File is compressed");
                }
                case 262: {
                    if (n6 == 2) break;
                    throw new Exception("File does not use RGB format");
                }
                case 273: {
                    this.stripOffsets = n6;
                    break;
                }
                case 278: {
                    this.rowsPerStrip = n6;
                    break;
                }
                case 279: {
                    this.stripByteCounts = n6;
                    break;
                }
            }
            ++n2;
        }
        this.strips = this.imageLength / this.rowsPerStrip;
    }

    private final void readStripOffsets() throws Exception {
        this.stripOffsetsTable = new int[this.strips];
        this.bufferAt = this.stripOffsets;
        int n = 0;
        while (n < this.strips) {
            this.stripOffsetsTable[n] = this.readDouble();
            ++n;
        }
    }

    private final void readStripByteCounts() throws Exception {
        this.stripByteCountsTable = new int[this.strips];
        this.bufferAt = this.stripByteCounts;
        int n = 0;
        while (n < this.strips) {
            this.stripByteCountsTable[n] = this.readDouble();
            ++n;
        }
    }

    private final int readByte() {
        return this.buffer[this.bufferAt++];
    }

    private final int readWord() {
        int n = 0;
        n = this.lsb ? this.buffer[this.bufferAt] | this.buffer[this.bufferAt + 1] << 8 : this.buffer[this.bufferAt + 1] | this.buffer[this.bufferAt] << 8;
        this.bufferAt += 2;
        return n;
    }

    private final int readDouble() {
        int n = 0;
        n = this.lsb ? this.buffer[this.bufferAt] | this.buffer[this.bufferAt + 1] << 8 | this.buffer[this.bufferAt + 2] << 16 | this.buffer[this.bufferAt + 3] << 24 : this.buffer[this.bufferAt + 3] | this.buffer[this.bufferAt + 2] << 8 | this.buffer[this.bufferAt + 1] << 16 | this.buffer[this.bufferAt] << 24;
        this.bufferAt += 4;
        return n;
    }

    private final /* synthetic */ void this() {
        this.bufferAt = 0;
        this.lsb = false;
        this.imageLength = 0;
        this.imageWidth = 0;
        this.rowsPerStrip = 0;
        this.strips = 0;
    }

    public ReadTiff() {
        this.this();
    }
}

