/*
 * Decompiled with CFR 0.152.
 */
package jpatch.auxilary;

import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;

public final class Bezier {
    private static Point3f p0;
    private static Point3f p1;
    private static Point3f p2;
    private static Point3f p3;

    public static final Point3f[] deCasteljau(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4, float f) {
        Point3f[] point3fArray = new Point3f[7];
        Point3f point3f5 = new Point3f(point3f2);
        point3f5.interpolate(point3f3, f);
        point3fArray[0] = new Point3f(point3f);
        point3fArray[1] = new Point3f(point3f);
        point3fArray[1].interpolate(point3f2, f);
        point3fArray[2] = new Point3f(point3fArray[1]);
        point3fArray[2].interpolate(point3f5, f);
        point3fArray[6] = new Point3f(point3f4);
        point3fArray[5] = new Point3f(point3f3);
        point3fArray[5].interpolate(point3f4, f);
        point3fArray[4] = point3f5;
        point3fArray[4].interpolate(point3fArray[5], f);
        point3fArray[3] = new Point3f(point3fArray[2]);
        point3fArray[3].interpolate(point3fArray[4], f);
        return point3fArray;
    }

    public static final Point3d[] deCasteljau(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, double d) {
        Point3d[] point3dArray = new Point3d[7];
        Point3d point3d5 = new Point3d(point3d2);
        point3d5.interpolate((Tuple3d)point3d3, d);
        point3dArray[0] = new Point3d(point3d);
        point3dArray[1] = new Point3d(point3d);
        point3dArray[1].interpolate((Tuple3d)point3d2, d);
        point3dArray[2] = new Point3d(point3dArray[1]);
        point3dArray[2].interpolate((Tuple3d)point3d5, d);
        point3dArray[6] = new Point3d(point3d4);
        point3dArray[5] = new Point3d(point3d3);
        point3dArray[5].interpolate((Tuple3d)point3d4, d);
        point3dArray[4] = point3d5;
        point3dArray[4].interpolate((Tuple3d)point3dArray[5], d);
        point3dArray[3] = new Point3d(point3dArray[2]);
        point3dArray[3].interpolate((Tuple3d)point3dArray[4], d);
        return point3dArray;
    }

    public static final void deCasteljau(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4, float f, Point3f[] point3fArray, int n) {
        Point3f[] point3fArray2 = Bezier.deCasteljau(point3f, point3f2, point3f3, point3f4, f);
        int n2 = 0;
        while (n2 < 7) {
            point3fArray[n + n2] = point3fArray2[n2];
            ++n2;
        }
    }

    public static final void prepare(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
        p0 = point3f;
        p1 = point3f2;
        p2 = point3f3;
        p3 = point3f4;
    }

    public static final Point3f evaluate(float f) {
        float f2 = 1.0f - f;
        float f3 = f2 * f2;
        float f4 = f * f;
        float f5 = f3 * f2;
        float f6 = (float)3 * f * f3;
        float f7 = (float)3 * f4 * f2;
        float f8 = f4 * f;
        return new Point3f(f5 * Bezier.p0.x + f6 * Bezier.p1.x + f7 * Bezier.p2.x + f8 * Bezier.p3.x, f5 * Bezier.p0.y + f6 * Bezier.p1.y + f7 * Bezier.p2.y + f8 * Bezier.p3.y, f5 * Bezier.p0.z + f6 * Bezier.p1.z + f7 * Bezier.p2.z + f8 * Bezier.p3.z);
    }

    public static final void evaluate(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4, Point3f[] point3fArray) {
        int n = point3fArray.length - 1;
        int n2 = 1;
        while (n2 < n) {
            float f = (float)n2 / (float)n;
            float f2 = 1.0f - f;
            float f3 = f2 * f2;
            float f4 = f * f;
            float f5 = f3 * f2;
            float f6 = (float)3 * f * f3;
            float f7 = (float)3 * f4 * f2;
            float f8 = f4 * f;
            point3fArray[n2].set(f5 * point3f.x + f6 * point3f2.x + f7 * point3f3.x + f8 * point3f4.x, f5 * point3f.y + f6 * point3f2.y + f7 * point3f3.y + f8 * point3f4.y, f5 * point3f.z + f6 * point3f2.z + f7 * point3f3.z + f8 * point3f4.z);
            ++n2;
        }
        point3fArray[0].set(point3f);
        point3fArray[n].set(point3f4);
    }

    public static final void evaluate(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, Point3d[] point3dArray) {
        int n = point3dArray.length - 1;
        int n2 = 1;
        while (n2 < n) {
            double d = (double)n2 / (double)n;
            double d2 = 1.0 - d;
            double d3 = d2 * d2;
            double d4 = d * d;
            double d5 = d3 * d2;
            double d6 = (double)3 * d * d3;
            double d7 = (double)3 * d4 * d2;
            double d8 = d4 * d;
            point3dArray[n2].set(d5 * point3d.x + d6 * point3d2.x + d7 * point3d3.x + d8 * point3d4.x, d5 * point3d.y + d6 * point3d2.y + d7 * point3d3.y + d8 * point3d4.y, d5 * point3d.z + d6 * point3d2.z + d7 * point3d3.z + d8 * point3d4.z);
            ++n2;
        }
        point3dArray[0].set(point3d);
        point3dArray[n].set(point3d4);
    }

    public static final Point3f evaluate(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4, float f) {
        if (f == 0.5f) {
            return new Point3f(0.125f * point3f.x + 0.375f * point3f2.x + 0.375f * point3f3.x + 0.125f * point3f4.x, 0.125f * point3f.y + 0.375f * point3f2.y + 0.375f * point3f3.y + 0.125f * point3f4.y, 0.125f * point3f.z + 0.375f * point3f2.z + 0.375f * point3f3.z + 0.125f * point3f4.z);
        }
        float f2 = 1.0f - f;
        float f3 = f2 * f2;
        float f4 = f * f;
        float f5 = f3 * f2;
        float f6 = (float)3 * f * f3;
        float f7 = (float)3 * f4 * f2;
        float f8 = f4 * f;
        return new Point3f(f5 * point3f.x + f6 * point3f2.x + f7 * point3f3.x + f8 * point3f4.x, f5 * point3f.y + f6 * point3f2.y + f7 * point3f3.y + f8 * point3f4.y, f5 * point3f.z + f6 * point3f2.z + f7 * point3f3.z + f8 * point3f4.z);
    }

    public static final Point3f[] elevateDegree(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
        return new Point3f[]{new Point3f(point3f), new Point3f(point3f.x * 0.25f + point3f2.x * 0.75f, point3f.y * 0.25f + point3f2.y * 0.75f, point3f.z * 0.25f + point3f2.z * 0.75f), new Point3f(point3f2.x * 0.5f + point3f3.x * 0.5f, point3f2.y * 0.5f + point3f3.y * 0.5f, point3f2.z * 0.5f + point3f3.z * 0.5f), new Point3f(point3f3.x * 0.75f + point3f4.x * 0.25f, point3f3.y * 0.75f + point3f4.y * 0.25f, point3f3.z * 0.75f + point3f4.z * 0.25f), new Point3f(point3f4)};
    }
}

