/*
 * Decompiled with CFR 0.152.
 */
package inyo;

import inyo.RtCanvas;
import inyo.RtIrradianceCache;
import inyo.RtKdTree;
import inyo.RtLensFlare;
import inyo.RtLight;
import inyo.RtMaterial;
import inyo.RtModel;
import inyo.RtPathNode;
import inyo.RtWorld;
import inyo.RtZBuffer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.vecmath.Point3d;

class RtRayTracer {
    BufferedImage image;

    public void renderImageToFile(RtWorld rtWorld, String string) {
        Image image = this.renderImage(rtWorld);
        rtWorld.jitter = 1;
        rtWorld.scale = 0.25;
        File file = new File(string);
        try {
            ImageIO.write((RenderedImage)((Object)image), rtWorld.outputFormat, file);
        }
        catch (IOException iOException) {
            System.out.println("Error creating file:\n " + iOException);
        }
        file = null;
    }

    public Image renderImage(RtWorld rtWorld) {
        rtWorld.height = (int)((double)rtWorld.height * rtWorld.scale);
        rtWorld.width = (int)((double)rtWorld.width * rtWorld.scale);
        rtWorld.fov *= rtWorld.scale;
        if (rtWorld.jitter == 0) {
            rtWorld.jitter = 1;
        }
        RtPathNode rtPathNode = rtWorld.getPathNode();
        double d = System.currentTimeMillis();
        if (rtWorld.subdivisionMethod == RtWorld.OCTREE) {
            System.out.println("Creating octree...");
            int n = 0;
            while (n < rtWorld.modelList.size()) {
                RtModel rtModel = (RtModel)rtWorld.modelList.get(n);
                rtModel.buildOctree(rtWorld.maxOctreeDepth, rtWorld.maxOctreeItems);
                ++n;
            }
        } else {
            System.out.println("Creating Kd tree...");
            rtWorld.kdTree = new RtKdTree(rtWorld, 0, rtWorld.triangleCount - 1);
        }
        RtCanvas rtCanvas = new RtCanvas(rtWorld.width, rtWorld.height);
        if (rtWorld.useIrradianceCache) {
            rtWorld.irradianceCache = new RtIrradianceCache(rtWorld);
        }
        if (rtWorld.useZBuffer) {
            System.out.println("Rendering zBuffer...");
        } else {
            System.out.println("Raytracing...");
            this.trace(rtWorld, rtPathNode, rtCanvas);
        }
        this.drawLensFlare(rtWorld, rtCanvas);
        double d2 = System.currentTimeMillis();
        System.out.println("Writing the file");
        BufferedImage bufferedImage = rtCanvas.getImage();
        if (rtWorld.showStats) {
            Graphics graphics = ((Image)bufferedImage).getGraphics();
            graphics.setColor(Color.white);
            graphics.drawString((d2 - d) / 1000.0 + " seconds", 4, rtWorld.height - 28);
            if (rtWorld.useZBuffer) {
                graphics.drawString(rtWorld.triangleCount + " triangles, zbuffer buckets =" + rtWorld.jitter + " FOV=" + rtWorld.fov, 4, rtWorld.height - 16);
            } else {
                graphics.drawString(rtWorld.triangleCount + " triangles, jitter=" + rtWorld.jitter, 4, rtWorld.height - 16);
            }
            if (rtWorld.pathTracing == 2) {
                graphics.drawString("" + rtWorld.pathTracingThetaSamples + 'x' + rtWorld.pathTracingPhiSamples + " hemisphere samples, max depth " + rtWorld.pathTracingMaxBounces, 4, rtWorld.height - 4);
            } else if (rtWorld.useAmbientOcclusion) {
                graphics.drawString(rtWorld.ambientOcclusionSamples + " AO samples", 4, rtWorld.height - 4);
            }
        }
        System.out.println((d2 - d) / 1000.0 + " seconds");
        return bufferedImage;
    }

    void drawLensFlare(RtWorld rtWorld, RtCanvas rtCanvas) {
        Point3d point3d = new Point3d(0.0, 0.0, 1.0);
        int n = 0;
        while (n < rtWorld.lightList.size()) {
            RtLight rtLight = (RtLight)rtWorld.lightList.get(n);
            if (rtLight.lensFlare) {
                RtPathNode rtPathNode = rtLight.getShadowRay(rtWorld, point3d, null, true);
                rtPathNode.stopAtFirstHit = true;
                rtPathNode.hitTest(rtWorld);
                if (!rtPathNode.hit) {
                    int n2 = (int)(rtLight.position.x / rtLight.position.z * rtWorld.fov);
                    int n3 = (int)(rtLight.position.y / rtLight.position.z * rtWorld.fov);
                    int n4 = rtCanvas.high / 4;
                    RtLensFlare.drawFlare(rtCanvas, n2, n3, n4);
                }
                rtPathNode.inUse = false;
            }
            ++n;
        }
    }

    void traceBuffer(RtWorld rtWorld, RtZBuffer rtZBuffer, RtCanvas rtCanvas) {
        RtPathNode rtPathNode = rtWorld.getPathNode();
        rtPathNode.origin.set(0.0, 0.0, 1.0);
        int n = 0;
        int n2 = rtZBuffer.top;
        while (n2 >= rtZBuffer.bottom) {
            int n3 = 0;
            int n4 = rtZBuffer.left;
            while (n4 <= rtZBuffer.right) {
                rtPathNode.hitTriangle = rtZBuffer.getTriangle(n4, n2);
                boolean bl = false;
                if (rtPathNode.hitTriangle != null) {
                    bl = rtPathNode.hit = true;
                }
                if (rtPathNode.hit) {
                    rtPathNode.lookAt(n4, n2, rtWorld.fov);
                    rtPathNode.hit = false;
                    rtPathNode.hitTriangle.hitTest(rtPathNode);
                    if (!rtPathNode.hit) {
                        rtPathNode.hit = false;
                        rtPathNode.ignoreTriangle = null;
                        rtWorld.irradianceSampled = false;
                        rtPathNode.hitTest(rtWorld);
                    }
                }
                rtPathNode.calcColor(rtWorld, 0, 0);
                rtCanvas.setPixelScaled(1, n3, n, rtPathNode.red, rtPathNode.green, rtPathNode.blue);
                ++n3;
                ++n4;
            }
            ++n;
            --n2;
        }
        rtPathNode.inUse = false;
    }

    void singleSamplePixel(RtWorld rtWorld, RtPathNode rtPathNode, RtCanvas rtCanvas, int n, int n2) {
        rtPathNode.origin.set(0.0, 0.0, 0.0);
        rtPathNode.lookAt(n, n2, rtWorld.fov);
        rtPathNode.hit = false;
        rtPathNode.ignoreTriangle = null;
        rtPathNode.rayId = rtWorld.nextRayId++;
        rtPathNode.stopAtFirstHit = false;
        rtWorld.irradianceSampled = false;
        rtPathNode.hitTest(rtWorld);
        rtPathNode.calcColor(rtWorld, 0, 0);
        rtCanvas.setPixelScaled(0, n, n2, rtPathNode.red, rtPathNode.green, rtPathNode.blue);
    }

    void multiSamplePixel(RtWorld rtWorld, RtPathNode rtPathNode, RtCanvas rtCanvas, int n, int n2) {
        double d = 1.0 / (double)rtWorld.jitter;
        double d2 = d / (double)2;
        double d3 = rtWorld.jitter * rtWorld.jitter;
        rtPathNode.origin.set(0.0, 0.0, 0.0);
        int n3 = rtCanvas.getRGB(0, n, n2);
        double d4 = (float)rtCanvas.redByte(n3) / 255.0f;
        double d5 = (float)rtCanvas.greenByte(n3) / 255.0f;
        double d6 = (float)rtCanvas.blueByte(n3) / 255.0f;
        double d7 = 0.0;
        while (d7 < 1.0) {
            double d8 = 0.0;
            while (d8 < 1.0) {
                double d9 = n;
                double d10 = n2;
                if (rtWorld.jitter > 1) {
                    d9 += d7 + Math.random() * d - d2;
                    d10 += d8 + Math.random() * d - d2;
                }
                rtPathNode.lookAt(d9, d10, rtWorld.fov);
                rtPathNode.hit = false;
                rtPathNode.ignoreTriangle = null;
                rtPathNode.stopAtFirstHit = false;
                ++rtWorld.nextRayId;
                rtPathNode.rayId = rtPathNode.rayId;
                rtWorld.irradianceSampled = false;
                rtPathNode.hitTest(rtWorld);
                rtPathNode.calcColor(rtWorld, 0, 0);
                d4 += rtPathNode.red;
                d5 += rtPathNode.green;
                d6 += rtPathNode.blue;
                d8 += d;
            }
            d7 += d;
        }
        rtCanvas.setPixelScaled(0, n, n2, d4 /= d3 + 1.0, d5 /= d3 + 1.0, d6 /= d3 + 1.0);
    }

    void focalBlurSamplePixel(RtWorld rtWorld, RtPathNode rtPathNode, RtCanvas rtCanvas, int n, int n2) {
        rtWorld.jitter = 1;
        rtPathNode.origin.set(0.0, 0.0, 0.0);
        double d = (double)n / rtWorld.fov * (rtWorld.fov + rtWorld.focalDepth);
        double d2 = (double)n2 / rtWorld.fov * (rtWorld.fov + rtWorld.focalDepth);
        double d3 = rtWorld.fov + rtWorld.focalDepth;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = rtWorld.aperture / (double)2;
        int n3 = 0;
        while (n3 < rtWorld.blurSamples) {
            rtPathNode.origin.x = Math.random() * rtWorld.aperture - d7;
            rtPathNode.origin.y = Math.random() * rtWorld.aperture - d7;
            rtPathNode.origin.z = 0.0;
            rtPathNode.lookAt(d, d2, d3);
            rtPathNode.hit = false;
            rtPathNode.ignoreTriangle = null;
            rtPathNode.stopAtFirstHit = false;
            rtWorld.irradianceSampled = false;
            ++rtWorld.nextRayId;
            rtPathNode.rayId = rtPathNode.rayId;
            rtPathNode.hitTest(rtWorld);
            rtPathNode.calcColor(rtWorld, 0, 0);
            d4 += rtPathNode.red;
            d5 += rtPathNode.green;
            d6 += rtPathNode.blue;
            ++n3;
        }
        rtCanvas.setPixelScaled(0, n, n2, d4 / (double)rtWorld.blurSamples, d5 / (double)rtWorld.blurSamples, d6 / (double)rtWorld.blurSamples);
    }

    void trace(RtWorld rtWorld, RtPathNode rtPathNode, RtCanvas rtCanvas) {
        int n;
        int n2;
        RtCanvas rtCanvas2 = null;
        int n3 = rtWorld.height;
        if (rtWorld.jitter > 1 && !rtWorld.multisample) {
            n3 *= 2;
        }
        int n4 = n3;
        RtMaterial[][] rtMaterialArray = new RtMaterial[rtCanvas.wide + 1][rtCanvas.high + 1];
        RtMaterial[][] rtMaterialArray2 = new RtMaterial[rtCanvas.wide + 1][rtCanvas.high + 1];
        boolean[][] blArray = new boolean[rtCanvas.wide + 1][rtCanvas.high + 1];
        int[][] nArray = new int[rtCanvas.wide + 1][rtCanvas.high + 1];
        if (!rtWorld.multisample) {
            n2 = 0;
            int n5 = rtCanvas.halfHigh;
            while (n5 >= -rtCanvas.halfHigh) {
                if (rtWorld.stopRendering) {
                    return;
                }
                System.out.println("y=" + n5);
                n = 0;
                int n6 = -rtCanvas.halfWide;
                while (n6 <= rtCanvas.halfWide) {
                    rtWorld.irradianceSampled = false;
                    rtPathNode.needsOversampling = false;
                    if (rtWorld.useFocalBlur) {
                        this.focalBlurSamplePixel(rtWorld, rtPathNode, rtCanvas, n6, n5);
                    } else {
                        this.singleSamplePixel(rtWorld, rtPathNode, rtCanvas, n6, n5);
                    }
                    rtMaterialArray2[n][n2] = rtPathNode.reflectedMaterial;
                    blArray[n][n2] = rtPathNode.needsOversampling;
                    rtMaterialArray[n][n2] = rtPathNode.visibleMaterial;
                    if (rtWorld.useSoftShadows) {
                        nArray[n][n2] = rtPathNode.lightCount;
                    }
                    ++n;
                    ++n6;
                }
                ++n2;
                rtWorld.progress = 1 - --n4 / n3;
                --n5;
            }
            if (rtWorld.jitter < 2) {
                return;
            }
        }
        n2 = 1;
        while (n2 < rtCanvas.high) {
            n = 1;
            while (n < rtCanvas.wide) {
                RtMaterial rtMaterial = rtMaterialArray[n][n2];
                RtMaterial rtMaterial2 = rtMaterialArray2[n][n2];
                if (rtMaterialArray[n][n2] != rtMaterialArray[n - 1][n2 - 1] || rtMaterialArray[n][n2] != rtMaterialArray[n][n2 - 1] || rtMaterialArray[n][n2] != rtMaterialArray[n + 1][n2 - 1] || rtMaterialArray[n][n2] != rtMaterialArray[n - 1][n2] || rtMaterialArray[n][n2] != rtMaterialArray[n + 1][n2] || rtMaterialArray[n][n2] != rtMaterialArray[n - 1][n2 + 1] || rtMaterialArray[n][n2] != rtMaterialArray[n][n2 + 1] || rtMaterialArray[n][n2] != rtMaterialArray[n + 1][n2 + 1] || rtMaterialArray2[n][n2] != rtMaterialArray2[n - 1][n2 - 1] || rtMaterialArray2[n][n2] != rtMaterialArray2[n][n2 - 1] || rtMaterialArray2[n][n2] != rtMaterialArray2[n + 1][n2 - 1] || rtMaterialArray2[n][n2] != rtMaterialArray2[n - 1][n2] || rtMaterialArray2[n][n2] != rtMaterialArray2[n + 1][n2] || rtMaterialArray2[n][n2] != rtMaterialArray2[n - 1][n2 + 1] || rtMaterialArray2[n][n2] != rtMaterialArray2[n][n2 + 1] || rtMaterialArray2[n][n2] != rtMaterialArray2[n + 1][n2 + 1] || nArray[n][n2] != nArray[n - 1][n2 - 1] || nArray[n][n2] != nArray[n][n2 - 1] || nArray[n][n2] != nArray[n + 1][n2 - 1] || nArray[n][n2] != nArray[n - 1][n2] || nArray[n][n2] != nArray[n + 1][n2] || nArray[n][n2] != nArray[n - 1][n2 + 1] || nArray[n][n2] != nArray[n][n2 + 1] || nArray[n][n2] != nArray[n + 1][n2 + 1] || rtMaterial != null && rtMaterial.hasPigment() || rtMaterial2 != null && rtMaterial2.hasPigment()) {
                    blArray[n][n2] = true;
                }
                ++n;
            }
            ++n2;
        }
        int n7 = rtWorld.ambientOcclusionSamples;
        rtWorld.ambientOcclusionSamples = 1;
        if (rtWorld.useFakeOversampling) {
            rtCanvas2 = new RtCanvas(rtCanvas);
        }
        n2 = 1;
        int n8 = rtCanvas.halfHigh - 1;
        while (n8 >= -rtCanvas.halfHigh + 1) {
            System.out.println("y=" + n8);
            n = 1;
            int n9 = -rtCanvas.halfWide + 1;
            while (n9 <= rtCanvas.halfWide - 1) {
                if (rtWorld.stopRendering) {
                    return;
                }
                if (blArray[n][n2]) {
                    blArray[n][n2] = rtCanvas.needsResampling(1, n, n2, rtWorld.colorTolerance);
                    if (blArray[n][n2] && !rtWorld.debugOversampling) {
                        if (rtWorld.useFakeOversampling) {
                            rtCanvas.averagePixel(1, rtCanvas2, n, n2);
                        } else {
                            this.multiSamplePixel(rtWorld, rtPathNode, rtCanvas, n9, n8);
                        }
                    }
                }
                ++n;
                ++n9;
            }
            ++n2;
            rtWorld.progress = 1 - --n4 / n3;
            --n8;
        }
        rtWorld.ambientOcclusionSamples = n7;
        if (rtWorld.debugOversampling) {
            n2 = 1;
            while (n2 < rtCanvas.high) {
                n = 1;
                while (n < rtCanvas.wide) {
                    if (blArray[n][n2]) {
                        rtCanvas.setPixel(1, n, n2, 255, 0, 0);
                    }
                    ++n;
                }
                ++n2;
            }
        }
    }

    RtRayTracer() {
    }
}

