/*
 * Decompiled with CFR 0.152.
 */
package inyo;

import inyo.RtLight;
import inyo.RtMaterial;
import inyo.RtModel;
import inyo.RtTriangle;
import inyo.RtWorld;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class RtPathNode {
    public Point3d origin;
    public Vector3d direction;
    public boolean inUse;
    public boolean hit;
    public RtTriangle hitTriangle;
    public Point3d hitPoint;
    public Point3d hitPointWorld;
    public Vector3d normal;
    public double distance;
    public double red;
    public double green;
    public double blue;
    public boolean stopAtFirstHit;
    public double maxDistance;
    RtTriangle ignoreTriangle;
    public int lightCount;
    RtMaterial reflectedMaterial;
    boolean needsOversampling;
    public RtMaterial visibleMaterial;
    public int rayId;
    public boolean inside;

    final void lookAt(double d, double d2, double d3) {
        this.direction.sub(this.origin);
        this.direction.x = d - this.origin.x;
        this.direction.y = d2 - this.origin.y;
        this.direction.z = d3 - this.origin.z;
        this.direction.normalize();
    }

    final void lookAt(Point3d point3d) {
        this.direction.x = point3d.x - this.origin.x;
        this.direction.y = point3d.y - this.origin.y;
        this.direction.z = point3d.z - this.origin.z;
        this.direction.normalize();
    }

    final void calcHitFromOrigin(double d) {
        this.hitPoint.x = this.origin.x + this.direction.x * d;
        this.hitPoint.y = this.origin.y + this.direction.y * d;
        this.hitPoint.z = this.origin.z + this.direction.z * d;
    }

    final void hitTest(RtWorld rtWorld) {
        this.hit = false;
        if (rtWorld.subdivisionMethod == RtWorld.OCTREE) {
            int n = 0;
            while (n < rtWorld.modelList.size()) {
                RtModel rtModel = (RtModel)rtWorld.modelList.get(n);
                rtModel.hitTest(this);
                if (!this.hit || !this.stopAtFirstHit) {
                    ++n;
                    continue;
                }
                break;
            }
        } else {
            rtWorld.kdTree.hitTest(rtWorld, this);
        }
        if (this.hit) {
            this.hitPointWorld.set(this.hitPoint.x, this.hitPoint.y, this.hitPoint.z);
            rtWorld.m4Cam2World.transform(this.hitPointWorld);
            this.calcHitFromOrigin(this.distance);
        }
    }

    final Color3f ambientOcclusion(RtWorld rtWorld) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        double d = rtWorld.colorBleed;
        RtPathNode rtPathNode = rtWorld.getPathNode();
        rtPathNode.origin = this.hitPoint;
        rtPathNode.ignoreTriangle = this.hitTriangle;
        rtPathNode.stopAtFirstHit = true;
        rtPathNode.maxDistance = rtWorld.ambientOcclusionDistance;
        RtTriangle rtTriangle = this.hitTriangle;
        this.normal = rtTriangle.calcAverageNormal(rtWorld, this.hitPoint, this.direction, this.inside);
        int n = 0;
        int n2 = 0;
        double d2 = 0.0;
        int n3 = 0;
        while (n3 < rtWorld.ambientOcclusionSamples) {
            rtPathNode.direction = this.sampleRandomly(this.normal);
            rtPathNode.hit = false;
            rtPathNode.blue = rtWorld.nextRayId++;
            rtPathNode.hitTest(rtWorld);
            if (rtPathNode.hit) {
                if (d > 0.0) {
                    RtMaterial rtMaterial = rtPathNode.hitTriangle.material;
                    f = (float)((double)f + (double)((float)rtMaterial.red) * d);
                    f2 = (float)((double)f2 + (double)((float)rtMaterial.green) * d);
                    f3 = (float)((double)f3 + (double)((float)rtMaterial.blue) * d);
                }
            } else {
                ++n;
                f += rtWorld.skyLightColor.x;
                f2 += rtWorld.skyLightColor.y;
                f3 += rtWorld.skyLightColor.z;
            }
            ++n2;
            ++n3;
        }
        d2 = (double)n / (double)n2;
        rtPathNode.inUse = false;
        return new Color3f(f /= (float)n2, f2 /= (float)n2, f3 /= (float)n2);
    }

    final void calcLights(RtWorld rtWorld) {
        double d;
        double d2;
        double d3;
        if (rtWorld.lightList.size() == 0) {
            return;
        }
        RtMaterial rtMaterial = this.hitTriangle.material;
        Point3d point3d = this.hitTriangle.getReferencePosition();
        float f = (float)point3d.x;
        float f2 = (float)point3d.y;
        float f3 = (float)point3d.z;
        if (rtMaterial.texture != null && rtMaterial.texture.getPigment() != null) {
            Color3f color3f = rtMaterial.texture.getPigment().colorAt(f, f2, f3);
            d3 = color3f.x;
            d2 = color3f.y;
            d = color3f.z;
        } else {
            d3 = rtMaterial.red;
            d2 = rtMaterial.green;
            d = rtMaterial.blue;
        }
        double d4 = rtMaterial.specular;
        double d5 = rtMaterial.diffuse;
        double d6 = rtMaterial.brilliance;
        int n = 0;
        while (n < rtWorld.lightList.size()) {
            double d7;
            RtLight rtLight = (RtLight)rtWorld.lightList.get(n);
            int n2 = 1;
            if (rtWorld.useSoftShadows && rtLight.radius > 0.0 && rtWorld.jitter == 1) {
                n2 = rtWorld.softShadowSamples;
            }
            double d8 = 0.0;
            double d9 = 0.0;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            double d10 = 0.0;
            if (rtLight.facesLight(this.normal, this.hitPoint)) {
                d10 = rtLight.calcIntensity(rtWorld, this.hitPoint);
            }
            if (d10 > 0.0 && rtLight.castsShadow) {
                int n3 = 0;
                int n4 = 0;
                while (n4 < n2) {
                    RtPathNode rtPathNode = rtLight.calcLightColor(rtWorld, this.hitPoint, this.hitTriangle);
                    if (rtPathNode.hit) {
                        if (!rtWorld.useBlackShadows && rtWorld.useFakeCaustics && (rtPathNode.hitTriangle.material.filter > 0.0 || rtPathNode.hitTriangle.material.transmit > 0.0) && this.hitTriangle.material.filter == 0.0) {
                            ++n3;
                            this.needsOversampling = rtWorld.useOversampledCaustics;
                            Vector3d vector3d = this.hitTriangle.calcAverageNormal(rtWorld, rtPathNode.hitPoint, null, this.inside);
                            d7 = this.normal.dot(rtPathNode.hitTriangle.normal);
                            rtPathNode.red *= d7;
                            rtPathNode.green *= d7;
                            rtPathNode.blue *= d7;
                        }
                    } else {
                        ++n3;
                    }
                    f4 = (float)((double)f4 + rtPathNode.red);
                    f5 = (float)((double)f5 + rtPathNode.green);
                    f6 = (float)((double)f6 + rtPathNode.blue);
                    rtPathNode.inUse = false;
                    ++n4;
                }
                if (n3 == n2) {
                    ++this.lightCount;
                }
            }
            if (!rtLight.castsShadow) {
                n2 = 1;
                f4 = rtLight.color.x;
                f5 = rtLight.color.y;
                f6 = rtLight.color.z;
            }
            if (n2 > 1) {
                f4 /= (float)n2;
                f5 /= (float)n2;
                f6 /= (float)n2;
            }
            if (d10 > 0.0) {
                RtPathNode rtPathNode = rtLight.getShadowRay(rtWorld, this.hitPoint, this.hitTriangle, false);
                d9 = rtMaterial.getDiffuse(this.normal, rtPathNode.direction, this.direction);
                d8 = rtLight.hasSpecular ? rtMaterial.getSpecular(this.normal, rtPathNode.direction, this.direction) : 0.0;
                rtPathNode.inUse = false;
            }
            double d11 = 0.0;
            double d12 = 0.0;
            d7 = 0.0;
            if (d8 > 0.0) {
                double d13 = (float)rtMaterial.metallic;
                double d14 = 1.0 - d13;
                d11 = d8 * (d14 + d13 * d3);
                d12 = d8 * (d14 + d13 * d2);
                d7 = d8 * (d14 + d13 * d);
            }
            this.red += (d3 * (double)f4 * d9 + d11) * d10;
            this.green += (d2 * (double)f5 * d9 + d12) * d10;
            this.blue += (d * (double)f6 * d9 + d7) * d10;
            ++n;
        }
    }

    void calcSkyColor(RtWorld rtWorld, int n) {
        if (n == 0) {
            if (rtWorld.skyTexture != null) {
                Vector3d vector3d = new Vector3d(this.direction);
                rtWorld.m4Cam2World.transform(vector3d);
                vector3d.normalize();
                Color3f color3f = rtWorld.skyTexture.getPigment().colorAt((float)vector3d.x, (float)vector3d.y, (float)vector3d.z);
                this.red = color3f.x;
                this.green = color3f.y;
                this.blue = color3f.z;
            } else {
                this.red = rtWorld.skyColor.x;
                this.green = rtWorld.skyColor.y;
                this.blue = rtWorld.skyColor.z;
            }
        } else if (rtWorld.skyTexture != null) {
            Vector3d vector3d = new Vector3d(this.direction);
            rtWorld.m4Cam2World.transform(vector3d);
            vector3d.normalize();
            Color3f color3f = rtWorld.skyTexture.getPigment().colorAt((float)vector3d.x, (float)vector3d.y, (float)vector3d.z);
            this.red = (double)color3f.x * rtWorld.skyPower;
            this.green = (double)color3f.y * rtWorld.skyPower;
            this.blue = (double)color3f.z * rtWorld.skyPower;
        } else {
            this.red = (double)rtWorld.skyLightColor.x * rtWorld.skyPower;
            this.green = (double)rtWorld.skyLightColor.y * rtWorld.skyPower;
            this.blue = (double)rtWorld.skyLightColor.z * rtWorld.skyPower;
        }
    }

    final void calcColor(RtWorld rtWorld, int n, int n2) {
        double d;
        double d2;
        Vector3d vector3d;
        boolean bl;
        if (n > rtWorld.maxDepth) {
            return;
        }
        this.lightCount = 0;
        this.visibleMaterial = null;
        this.reflectedMaterial = null;
        if (!this.hit) {
            this.calcSkyColor(rtWorld, n2);
            return;
        }
        this.visibleMaterial = this.hitTriangle.material;
        double d3 = this.hitTriangle.material.diffuse;
        double d4 = this.hitTriangle.material.ambient;
        this.normal = this.hitTriangle.calcAverageNormal(rtWorld, this.hitPoint, this.direction, this.inside);
        this.red = 0.0;
        this.green = 0.0;
        this.blue = 0.0;
        RtMaterial rtMaterial = this.hitTriangle.material;
        Point3d point3d = this.hitTriangle.getReferencePosition();
        Color3f color3f = rtMaterial.getColor(point3d);
        double d5 = color3f.x;
        double d6 = color3f.y;
        double d7 = color3f.z;
        rtMaterial.peturb(this.normal, point3d);
        boolean bl2 = false;
        if (rtMaterial.reflectionMax > 0.0 || rtMaterial.reflectionMin > 0.0) {
            bl2 = bl = true;
        }
        if (rtMaterial.diffuse > 0.0) {
            if (rtWorld.pathTracing != 0) {
                if (!bl) {
                    this.pathTrace(rtWorld, n + 1, n2 + 1);
                }
            } else {
                this.red += d5 * rtMaterial.ambient;
                this.green += d6 * rtMaterial.ambient;
                this.blue += d7 * rtMaterial.ambient;
            }
        }
        if (!this.inside) {
            this.calcLights(rtWorld);
        }
        if (rtMaterial.multipleScattering) {
            vector3d = rtMaterial.samples.multipleScattering(rtWorld, this, rtMaterial);
            this.red += d5 * vector3d.x;
            this.green += d6 * vector3d.y;
            this.blue += d7 * vector3d.z;
        }
        if (rtMaterial.singleScattering) {
            vector3d = rtMaterial.samples.singleScattering(rtWorld, this, rtMaterial);
            this.red += d5 * vector3d.x;
            this.green += d6 * vector3d.y;
            this.blue += d7 * vector3d.z;
        }
        if (rtMaterial.fakeSingleScattering) {
            double d8 = rtMaterial.samples.fakeSingleScattering(rtWorld, this, rtMaterial);
            this.red += d5 * d8;
            this.green += d6 * d8;
            this.blue += d7 * d8;
        }
        if (rtWorld.useAmbientOcclusion && rtMaterial.diffuse > 0.0) {
            Color3f color3f2 = this.ambientOcclusion(rtWorld);
            color3f2.scale((float)rtWorld.skyPower);
            this.red += (double)color3f2.x * d3 * d5;
            this.green += (double)color3f2.y * d3 * d6;
            this.blue += (double)color3f2.z * d3 * d7;
        }
        double d9 = 0.0;
        if (rtMaterial.conserveEnergy) {
            d2 = rtMaterial.transmit * (1.0 - d9);
            d = rtMaterial.filter * (1.0 - d9);
        } else {
            d2 = rtMaterial.transmit;
            d = rtMaterial.filter;
        }
        if ((rtMaterial.transmit > 0.0 || rtMaterial.filter > 0.0) && n < rtWorld.maxDepth) {
            RtPathNode rtPathNode = rtWorld.getPathNode();
            rtPathNode.origin = this.hitPoint;
            rtPathNode.ignoreTriangle = this.hitTriangle;
            rtPathNode.normal = new Vector3d(this.normal);
            rtPathNode.inside = this.inside ^ true;
            double d10 = -this.direction.dot(this.normal);
            double d11 = 0.0;
            if (rtPathNode.inside) {
                d11 = 1.0 / rtMaterial.ior;
            } else {
                d11 = rtMaterial.ior;
                d10 = -d10;
                rtPathNode.normal.negate();
            }
            double d12 = d11 * d10 - Math.sqrt(1.0 - d11 * d11 * (1.0 - d10 * d10));
            rtPathNode.direction = new Vector3d();
            rtPathNode.direction.x = d11 * this.direction.x + d12 * rtPathNode.normal.x;
            rtPathNode.direction.y = d11 * this.direction.y + d12 * rtPathNode.normal.y;
            rtPathNode.direction.z = d11 * this.direction.z + d12 * rtPathNode.normal.z;
            rtPathNode.stopAtFirstHit = false;
            rtPathNode.hitTest(rtWorld);
            if (rtPathNode.hit && rtPathNode.inside && rtPathNode.hitTriangle.material != this.hitTriangle.material) {
                rtPathNode.inside = false;
            }
            rtPathNode.calcColor(rtWorld, n + 1, n2);
            this.needsOversampling |= rtPathNode.needsOversampling;
            this.reflectedMaterial = rtPathNode.reflectedMaterial != null ? rtPathNode.reflectedMaterial : rtPathNode.visibleMaterial;
            this.lightCount = rtPathNode.lightCount;
            this.red += rtMaterial.red * rtPathNode.red * d + rtPathNode.red * d2;
            this.green += rtMaterial.green * rtPathNode.green * d + rtPathNode.green * d2;
            this.blue += rtMaterial.blue * rtPathNode.blue * d + rtPathNode.blue * d2;
            rtPathNode.inUse = false;
        }
        if (bl && n < rtWorld.maxDepth && !this.inside) {
            double d13 = 1.0 + this.direction.dot(this.normal);
            d9 = rtMaterial.reflectionMin + Math.pow(d13, rtMaterial.reflectionFalloff) * (rtMaterial.reflectionMax - rtMaterial.reflectionMin);
            RtPathNode rtPathNode = rtWorld.getPathNode();
            rtPathNode.origin = this.hitPoint;
            rtPathNode.ignoreTriangle = this.hitTriangle;
            rtPathNode.hit = false;
            Vector3d vector3d2 = new Vector3d(this.direction);
            vector3d2.negate();
            rtPathNode.direction.set(this.normal);
            rtPathNode.direction.scale((double)2 * this.normal.dot(vector3d2));
            rtPathNode.direction.sub(vector3d2);
            rtPathNode.stopAtFirstHit = false;
            rtPathNode.hitTest(rtWorld);
            rtPathNode.calcColor(rtWorld, n + 1, n2);
            this.reflectedMaterial = rtPathNode.reflectedMaterial != null ? rtPathNode.reflectedMaterial : rtPathNode.visibleMaterial;
            this.lightCount = rtPathNode.lightCount;
            this.needsOversampling |= rtPathNode.needsOversampling;
            rtPathNode.red *= d9;
            rtPathNode.green *= d9;
            rtPathNode.blue *= d9;
            double d14 = rtMaterial.metallic;
            double d15 = 1.0 - d14;
            rtPathNode.red *= d15 + d14 * d5;
            rtPathNode.green *= d15 + d14 * d6;
            rtPathNode.blue *= d15 + d14 * d7;
            this.red += rtPathNode.red;
            this.green += rtPathNode.green;
            this.blue += rtPathNode.blue;
            rtPathNode.inUse = false;
        }
    }

    final void pathTrace(RtWorld rtWorld, int n, int n2) {
        double d;
        double d2;
        double d3;
        Object object;
        Color3f color3f = null;
        if (n2 > rtWorld.pathTracingMaxBounces) {
            this.red = 0.0;
            this.green = 0.0;
            this.blue = 0.0;
            return;
        }
        RtMaterial rtMaterial = this.hitTriangle.material;
        if (rtMaterial.texture != null && rtMaterial.texture.getPigment() != null) {
            this.hitTriangle.calcAverageNormal(rtWorld, this.hitPoint, this.direction, this.inside);
            object = this.hitTriangle.getReferencePosition();
            Color3f color3f2 = rtMaterial.texture.getPigment().colorAt((float)((Point3d)object).x, (float)((Point3d)object).y, (float)((Point3d)object).z);
            d3 = color3f2.x;
            d2 = color3f2.y;
            d = color3f2.z;
        } else {
            d3 = rtMaterial.red;
            d2 = rtMaterial.green;
            d = rtMaterial.blue;
        }
        if (rtWorld.useIrradianceCache && n2 == 1) {
            double d4 = Math.abs(this.direction.dot(this.normal));
            color3f = rtWorld.irradianceCache.estimateIrradiance(this.hitPoint, this.normal);
            if (color3f != null) {
                this.red = rtMaterial.diffuse * d3 * (double)color3f.x * d4;
                this.green = rtMaterial.diffuse * d2 * (double)color3f.y * d4;
                this.blue = rtMaterial.diffuse * d * (double)color3f.z * d4;
                return;
            }
        }
        object = rtWorld.getPathNode();
        ((RtPathNode)object).origin = this.hitPoint;
        ((RtPathNode)object).ignoreTriangle = this.hitTriangle;
        ((RtPathNode)object).normal = this.normal;
        ((RtPathNode)object).hit = false;
        if (n2 == 1 && rtWorld.pathTracing == 2) {
            ((RtPathNode)object).sampleIrradiance(rtWorld, n, n2);
        } else {
            ((RtPathNode)object).direction = this.sampleRandomly(this.normal);
        }
        ((RtPathNode)object).hitTest(rtWorld);
        ((RtPathNode)object).calcColor(rtWorld, n + 1, n2 + 1);
        double d5 = Math.abs(this.direction.dot(((RtPathNode)object).direction));
        this.red += rtMaterial.diffuse * d3 * ((RtPathNode)object).red * d5;
        this.green += rtMaterial.diffuse * d2 * ((RtPathNode)object).green * d5;
        this.blue += rtMaterial.diffuse * d * ((RtPathNode)object).blue * d5;
        ((RtPathNode)object).inUse = false;
    }

    public void sampleIrradiance(RtWorld rtWorld, int n, int n2) {
        Color3f color3f = new Color3f();
        double d = 0.0;
        int n3 = 0;
        float f = rtWorld.pathTracingPhiSamples;
        float f2 = rtWorld.pathTracingThetaSamples;
        double d2 = 1.0 / (double)f;
        double d3 = 1.0 / (double)f2;
        double d4 = 0.0;
        while (d4 < 1.0) {
            double d5 = 0.0;
            while (d5 < 1.0) {
                double d6 = (d4 + Math.random() * d2) * Math.PI * (double)2;
                double d7 = (d5 + Math.random() * d3) * Math.PI;
                this.direction = rtWorld.pathTracing == 2 ? this.sampleHemisphere(this.normal, d7, d6) : this.sampleRandomly(this.normal);
                this.hit = false;
                ++rtWorld.nextRayId;
                this.rayId = this.rayId;
                this.hitTest(rtWorld);
                this.calcColor(rtWorld, n + 1, n2 + 1);
                color3f.x = (float)((double)color3f.x + this.red);
                color3f.y = (float)((double)color3f.y + this.green);
                color3f.y = (float)((double)color3f.y + this.blue);
                if (this.hit) {
                    d += 1.0 / this.distance;
                    ++n3;
                }
                d5 += d3;
            }
            d4 += d2;
        }
        float f3 = f * f2;
        color3f.scale(1.0f / f3);
        if (rtWorld.useIrradianceCache) {
            double d8 = 0.0;
            if (n3 > 0) {
                d8 = (double)n3 / d;
            }
            rtWorld.irradianceCache.add(this.origin, this.normal, d8, color3f);
            rtWorld.irradianceSampled = true;
        }
        this.red = color3f.x;
        this.green = color3f.y;
        this.blue = color3f.z;
    }

    final void rotateToNormal(Vector3d vector3d, Vector3d vector3d2) {
        double d;
        double d2;
        double d3;
        double d4 = vector3d.x * vector3d.x;
        double d5 = vector3d.y * vector3d.y;
        double d6 = vector3d.z * vector3d.z;
        if (Math.abs(vector3d.x) > Math.abs(vector3d.y) && Math.abs(vector3d.x) > Math.abs(vector3d.z)) {
            d3 = Math.sqrt(1.0 / (1.0 + d6 / d4));
            d2 = -vector3d.z * d3 / vector3d.x;
            d = 0.0;
        } else if (Math.abs(vector3d.y) > Math.abs(vector3d.x) && Math.abs(vector3d.y) > Math.abs(vector3d.z)) {
            d2 = Math.sqrt(1.0 / (1.0 + d4 / d5));
            d = -vector3d.x * d2 / vector3d.y;
            d3 = 0.0;
        } else {
            d = Math.sqrt(1.0 / (1.0 + d5 / d6));
            d3 = -vector3d.y * d / vector3d.z;
            d2 = 0.0;
        }
        Vector3d vector3d3 = new Vector3d(d2, d, d3);
        Vector3d vector3d4 = new Vector3d();
        vector3d4.cross(vector3d, vector3d3);
        vector3d4.normalize();
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setColumn(0, vector3d3.x, vector3d3.y, vector3d3.z, 0.0);
        matrix4d.setColumn(1, vector3d4.x, vector3d4.y, vector3d4.z, 0.0);
        matrix4d.setColumn(2, vector3d.x, vector3d.y, vector3d.z, 0.0);
        matrix4d.setColumn(3, 0.0, 0.0, 0.0, 1.0);
        matrix4d.transform(vector3d2);
    }

    final void rotateToNormal2(Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = new Vector3d(vector3d.x, 0.1923, 0.8376);
        vector3d3.normalize();
        Vector3d vector3d4 = new Vector3d();
        vector3d4.cross(vector3d3, vector3d);
        vector3d4.normalize();
        Vector3d vector3d5 = new Vector3d();
        vector3d5.cross(vector3d, vector3d4);
        vector3d5.normalize();
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.setRow(0, vector3d4);
        matrix3d.setRow(1, vector3d5);
        matrix3d.setRow(2, vector3d);
        matrix3d.transform(vector3d2);
    }

    final Vector3d sampleRandomly(Vector3d vector3d) {
        double d = Math.PI * 2 * Math.random();
        double d2 = Math.random();
        double d3 = Math.sqrt(d2);
        double d4 = Math.cos(d) * d3;
        double d5 = Math.sin(d) * d3;
        double d6 = Math.sqrt(1.0 - d2);
        Vector3d vector3d2 = new Vector3d(d4, d5, d6);
        this.rotateToNormal(vector3d, vector3d2);
        return vector3d2;
    }

    final Vector3d sampleRandomly_(Vector3d vector3d) {
        double d = Math.random() * (Math.PI * 2);
        double d2 = Math.random() * Math.PI;
        double d3 = Math.sin(d2) * Math.cos(d);
        double d4 = Math.sin(d2) * Math.sin(d);
        double d5 = Math.cos(d2);
        Vector3d vector3d2 = new Vector3d(d3, d4, d5);
        this.rotateToNormal(vector3d, vector3d2);
        return vector3d2;
    }

    final Vector3d sampleRandomly__(Vector3d vector3d) {
        double d = Math.random() * Math.PI * (double)2;
        double d2 = Math.random() * Math.PI;
        double d3 = Math.cos(d2) * Math.sin(d);
        double d4 = Math.sin(d2) * Math.sin(d);
        double d5 = Math.cos(d);
        Vector3d vector3d2 = new Vector3d(d3, d4, d5);
        vector3d2.add(vector3d);
        vector3d2.normalize();
        if (vector3d.dot(vector3d2) <= 0.0) {
            vector3d2.negate();
        }
        return vector3d2;
    }

    final Vector3d sampleHemisphere_(Vector3d vector3d, double d, double d2) {
        double d3;
        double d4;
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        if (Math.abs(vector3d.x) < 0.5) {
            vector3d2.set(1.0, 0.0, 0.0);
        } else {
            vector3d2.cross(vector3d, new Vector3d(0.0, 1.0, 0.0));
        }
        vector3d2.normalize();
        vector3d3.cross(vector3d2, vector3d);
        while (!((d4 = Math.random() * (double)2 - 1.0) * d4 + (d3 = Math.random() * (double)2 - 1.0) * d3 < 1.0)) {
        }
        double d5 = Math.sqrt(1.0 - (d4 * d4 + d3 * d3));
        return new Vector3d(d4 * vector3d2.x + d3 * vector3d3.x + d5 * vector3d.x, d4 * vector3d2.y + d3 * vector3d3.y + d5 * vector3d.y, d4 * vector3d2.z + d3 * vector3d3.z + d5 * vector3d.z);
    }

    final Vector3d sampleHemisphere(Vector3d vector3d, double d, double d2) {
        double d3 = Math.cos(d2) * Math.sin(d);
        double d4 = Math.sin(d2) * Math.sin(d);
        double d5 = Math.cos(d);
        Vector3d vector3d2 = new Vector3d(d3, d4, d5);
        vector3d2.add(vector3d2, vector3d);
        vector3d2.normalize();
        if (vector3d.dot(vector3d2) < 0.0) {
            vector3d2.negate();
        }
        return vector3d2;
    }

    private final /* synthetic */ void this() {
        this.origin = new Point3d(0.0, 0.0, 1.0);
        this.direction = new Vector3d();
        this.inUse = false;
        this.hit = false;
        this.hitPoint = new Point3d();
        this.hitPointWorld = new Point3d();
        this.normal = new Vector3d();
        this.distance = 0.0;
        this.stopAtFirstHit = false;
        this.maxDistance = 0.0;
        this.ignoreTriangle = null;
        this.lightCount = 0;
        this.reflectedMaterial = null;
        this.needsOversampling = false;
        this.visibleMaterial = null;
        this.rayId = 0;
        this.inside = false;
    }

    RtPathNode() {
        this.this();
    }
}

