/*
 * Decompiled with CFR 0.152.
 */
package inyo;

import inyo.RtImageMap;
import inyo.RtScattering;
import inyo.RtShader;
import inyo.RtWorld;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import patterns.Texture;
import patterns.Vector3D;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class RtMaterial {
    public static final int COLOR_RGB = 0;
    public static final int COLOR_IMAGE = 1;
    public static final int DIFFUSE_POV = 0;
    public static final int DIFFUSE_LAMBERT = 1;
    public static final int DIFFUSE_WRAPPED_LAMBERT = 2;
    public static final int DIFFUSE_OREN_NAYER = 3;
    public static final int DIFFUSE_MINNAERT = 4;
    public static final int DIFFUSE_IMAGE = 5;
    public static final int DIFFUSE_PHARR = 6;
    public static final int SPECULAR_POV = 0;
    public static final int SPECULAR_PHONG = 1;
    public static final int SPECULAR_BLINN = 2;
    public static final int SPECULAR_COOK_TORRENCE = 3;
    public static final int SPECULAR_REDUCED_COOK_TORRENCE = 4;
    public static final int SPECULAR_WARD_ISOTROPIC = 5;
    public int colorShader;
    public int diffuseShader;
    public int specularShader;
    public int index;
    public double red;
    public double green;
    public double blue;
    public Color3f color;
    public double transmit;
    public double filter;
    public double ambient;
    public double diffuse;
    public double brilliance;
    public double specular;
    public double roughness;
    public double metallic;
    public double reflectionMin;
    public double reflectionMax;
    public double reflectionFalloff;
    public double ior;
    public boolean conserveEnergy;
    public Texture texture;
    public RtImageMap imageMap;
    public RtScattering samples;
    public double wrappedAngle;
    public double darkness;
    public double thickness;
    public double rms;
    boolean singleScattering;
    boolean fakeSingleScattering;
    boolean multipleScattering;
    double scatteringMaxRedDistance;
    double scatteringMaxGreenDistance;
    double scatteringMaxBlueDistance;
    double scatteringMultipleScale;
    double scatteringSingleScale;
    double scatteringSingleMaxDistance;
    double scatteringSingleBias;

    public boolean hasPigment() {
        boolean bl = false;
        if (this.texture != null && this.texture.getPigment() != null) {
            bl = true;
        }
        return bl;
    }

    public Color3f getColor(Point3d point3d) {
        if (this.hasPigment()) {
            return this.texture.getPigment().colorAt((float)point3d.x, (float)point3d.y, (float)point3d.z);
        }
        return this.color;
    }

    public void peturb(Vector3d vector3d, Point3d point3d) {
        Vector3D vector3D;
        if (this.texture != null && (vector3D = this.texture.getNormal()) != null) {
            Vector3f vector3f = vector3D.vectorAt((float)point3d.x, (float)point3d.y, (float)point3d.z);
            vector3d.x += (double)vector3f.x;
            vector3d.y += (double)vector3f.y;
            vector3d.z += (double)vector3f.z;
            vector3d.normalize();
        }
    }

    public double getDiffuse(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        switch (this.diffuseShader) {
            case 1: {
                return RtShader.lambertDiffuse(vector3d, vector3d2);
            }
            case 2: {
                return RtShader.wrappedLambertDiffuse(vector3d, vector3d2, this.wrappedAngle);
            }
            case 3: {
                return RtShader.orenNayarDiffuse(vector3d, vector3d2, vector3d3, this.brilliance);
            }
            case 4: {
                return RtShader.minnaertDiffuse(vector3d, vector3d2, vector3d3, this.darkness);
            }
            case 6: {
                return RtShader.pharrSkin(vector3d, vector3d3, vector3d2, this.thickness);
            }
        }
        return RtShader.povDiffuse(vector3d, vector3d2, vector3d3, this.diffuse, this.roughness, this.brilliance);
    }

    public double getSpecular(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        switch (this.specularShader) {
            case 1: {
                return RtShader.phongSpecular(vector3d, vector3d2, vector3d3, this.roughness);
            }
            case 2: {
                return RtShader.blinnSpecular(vector3d, vector3d2, vector3d3, this.ior, this.specular);
            }
            case 3: {
                return RtShader.cookTorrenceSpecular(vector3d, vector3d2, vector3d3, this.roughness, this.ior);
            }
            case 4: {
                return RtShader.reducedCookTorranceSpecular(vector3d, vector3d2, vector3d3, this.roughness);
            }
            case 5: {
                return RtShader.wardIsotropicSpecular(vector3d, vector3d2, vector3d3, this.rms);
            }
        }
        return RtShader.povSpecular(vector3d, vector3d2, vector3d3, this.specular, this.roughness);
    }

    private final /* synthetic */ void this() {
        this.index = 0;
        this.red = 1.0;
        this.green = 1.0;
        this.blue = 1.0;
        this.color = new Color3f();
        this.transmit = 0.0;
        this.filter = 0.0;
        this.ambient = 0.25;
        this.diffuse = 0.75;
        this.brilliance = 1.0;
        this.specular = 1.0;
        this.roughness = 0.001;
        this.metallic = 0.0;
        this.reflectionMin = 0.0;
        this.reflectionMax = 0.0;
        this.reflectionFalloff = 1.0;
        this.ior = 1.0;
        this.conserveEnergy = true;
        this.imageMap = null;
        this.samples = new RtScattering();
        this.wrappedAngle = 90.0;
        this.darkness = 0.0;
        this.thickness = 0.0;
        this.rms = 0.0;
        this.singleScattering = false;
        this.fakeSingleScattering = false;
        this.multipleScattering = false;
        this.scatteringMaxRedDistance = 50.0;
        this.scatteringMaxGreenDistance = 50.0;
        this.scatteringMaxBlueDistance = 50.0;
        this.scatteringMultipleScale = 0.003;
        this.scatteringSingleScale = 2.5;
        this.scatteringSingleMaxDistance = 4;
        this.scatteringSingleBias = 1.0;
    }

    public RtMaterial(RtWorld rtWorld) {
        this.this();
    }

    public RtMaterial(double d, double d2, double d3) {
        this.this();
        this.red = d;
        this.green = d2;
        this.blue = d3;
        this.diffuseShader = 0;
        this.specularShader = 0;
        this.color.set((float)d, (float)d2, (float)d3);
    }
}

