/*
 * Decompiled with CFR 0.152.
 */
package inyo;

import inyo.InyoJPatchInterface;
import inyo.JPatchInyoInterface;
import inyo.RtLight;
import inyo.RtMaterial;
import inyo.RtRayTracer;
import inyo.RtTriangle;
import inyo.RtVertex;
import inyo.RtWorld;
import java.awt.Image;
import java.util.ArrayList;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import patterns.TextureParser;

public class RtInterface
implements JPatchInyoInterface {
    RtWorld world = new RtWorld();
    RtMaterial currentMaterial;
    RtLight currentLight;
    ArrayList vertexList;
    ArrayList triangleList;

    public void objectBegin() {
        this.vertexList = new ArrayList();
        this.world.addModel();
    }

    public void objectEnd() {
        this.vertexList = null;
    }

    public void addVertex(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        Point3d point3d = this.world.transformPoint(d, d2, d3);
        Point3d point3d2 = new Point3d(d4, d5, d6);
        Vector3d vector3d = this.world.transformNormal(d7, d8, d9);
        RtVertex rtVertex = new RtVertex(point3d, point3d2, vector3d);
        this.vertexList.add(rtVertex);
    }

    public void addTriangle(int n, int n2, int n3) {
        RtVertex rtVertex = (RtVertex)this.vertexList.get(n);
        RtVertex rtVertex2 = (RtVertex)this.vertexList.get(n2);
        RtVertex rtVertex3 = (RtVertex)this.vertexList.get(n3);
        RtTriangle rtTriangle = new RtTriangle(rtVertex, rtVertex2, rtVertex3);
        rtTriangle.material = this.currentMaterial;
        this.world.currentModel.addTriangle(rtTriangle);
        ++this.world.triangleCount;
    }

    public void addMaterial(float f, float f2, float f3) {
        this.currentMaterial = new RtMaterial(f, f2, f3);
    }

    public void setMaterialFilter(double d) {
        this.currentMaterial.filter = d;
    }

    public void setMaterialTransmit(double d) {
        this.currentMaterial.transmit = d;
    }

    public void setMaterialAmbient(double d) {
        this.currentMaterial.ambient = d;
    }

    public void setMaterialDiffuse(double d) {
        this.currentMaterial.diffuse = d;
    }

    public void setMaterialBrilliance(double d) {
        this.currentMaterial.brilliance = d;
    }

    public void setMaterialSpecular(double d) {
        this.currentMaterial.specular = d;
    }

    public void setMaterialRoughness(double d) {
        this.currentMaterial.roughness = d;
    }

    public void setMaterialMetallic(double d) {
        this.currentMaterial.metallic = d;
    }

    public void setMaterialReflection(double d, double d2, double d3) {
        this.currentMaterial.reflectionMin = d;
        this.currentMaterial.reflectionMax = d2;
        this.currentMaterial.reflectionFalloff = d3;
    }

    public void setMaterialRefraction(double d) {
        this.currentMaterial.ior = d;
    }

    public void setMaterialConserveEnergy(boolean bl) {
        this.currentMaterial.conserveEnergy = bl;
    }

    public void setMaterialTexture(String string) {
        this.currentMaterial.texture = TextureParser.parseTexture(string);
    }

    public void setSkyColor(float f, float f2, float f3) {
        this.world.skyColor = new Color3f(f, f2, f3);
    }

    public void setSkyLightColor(float f, float f2, float f3) {
        this.world.skyLightColor = new Color3f(f, f2, f3);
    }

    public void setSkyPower(double d) {
        this.world.skyPower = d;
    }

    public void setSkyTexture(String string) {
        this.world.skyTexture = TextureParser.parseTexture(string);
    }

    public void addLight(double d, double d2, double d3, double d4) {
        this.currentLight = this.world.addLight(d, d2, d3, d4, 0.0);
    }

    public void setLightRadius(double d) {
        this.currentLight.radius = d;
    }

    public void setLightColor(float f, float f2, float f3) {
        this.currentLight.color = new Color3f(f, f2, f3);
    }

    public void setLightCastsShadow(boolean bl) {
        this.currentLight.castsShadow = bl;
    }

    public void setLightHasSpecular(boolean bl) {
        this.currentLight.hasSpecular = bl;
    }

    public void setLightHasDiffuse(boolean bl) {
        this.currentLight.hasDiffuse = bl;
    }

    public void setLightFalloffLinear(double d) {
        this.currentLight.falloffType = 1;
        this.currentLight.falloffScale = d;
    }

    public void setLightFalloffQuadratic(double d) {
        this.currentLight.falloffType = 2;
        this.currentLight.falloffScale = d;
    }

    public void setLightFalloffAngle(double d) {
        this.currentLight.falloffAngle = d;
    }

    public void setShowStats(boolean bl) {
        this.world.showStats = bl;
    }

    public void setOversample(int n, boolean bl) {
        this.world.jitter = n;
    }

    public void setMaxRecursionDepth(int n) {
        this.world.maxDepth = n;
    }

    public void setSoftShadowSamples(int n) {
        if (n == 0) {
            this.world.useSoftShadows = false;
        } else {
            this.world.useSoftShadows = true;
            this.world.softShadowSamples = n;
        }
    }

    public void setTransparentShadows(boolean bl) {
        this.world.useBlackShadows = bl ^ true;
    }

    public void setCaustics(boolean bl, boolean bl2) {
        this.world.useFakeCaustics = bl;
        this.world.useOversampledCaustics = bl2;
    }

    public void setUseAmbientOcclusion(boolean bl) {
        this.world.useAmbientOcclusion = bl;
    }

    public void setAmbientOcclusion(double d) {
        this.world.ambientOcclusionDistance = d;
    }

    public void setAmbientOcclusionSamples(int n) {
        this.world.ambientOcclusionSamples = n;
    }

    public void ambientOcclusionColorBleed(float f) {
        this.world.colorBleed = f;
    }

    public void setUsePathTrace(boolean bl) {
        this.world.pathTracing = 1;
    }

    public void setPathTracePhi(int n) {
        this.world.pathTracingPhiSamples = n;
    }

    public void setPathTraceTheta(int n) {
        this.world.pathTracingThetaSamples = n;
    }

    public void setPathTraceMaxBounces(int n) {
        this.world.pathTracingMaxBounces = n;
    }

    public void setCamera(Matrix4d matrix4d) {
        this.world.camera.setMatrix(matrix4d);
        this.world.setCamera(this.world.camera);
    }

    public void setCameraFocalLength(float f) {
        this.world.camera.setFocalLength(f);
        this.world.setCamera(this.world.camera);
    }

    public void setCameraPosition(double d, double d2, double d3) {
        this.world.camera.setPosition(d, d2, d3);
        this.world.setCamera(this.world.camera);
    }

    public void setCameraPointTo(double d, double d2, double d3) {
        this.world.camera.pointAt(d, d2, d3, null);
        this.world.setCamera(this.world.camera);
    }

    public void setImageSize(int n, int n2, double d) {
        this.world.height = n;
        this.world.width = n2;
        this.world.scale = d;
    }

    public void startRendering(InyoJPatchInterface inyoJPatchInterface) {
        System.out.println("startRendering()");
        RtRayTracer rtRayTracer = new RtRayTracer();
        Image image = rtRayTracer.renderImage(this.world);
        inyoJPatchInterface.renderingDone(image);
    }

    public double getProgress() {
        return this.world.progress;
    }

    public void stopRendering() {
        this.world.stopRendering = true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class RenderOnThread
    extends Thread {
        InyoJPatchInterface callback;
        RtWorld world;

        public void run() {
            RtRayTracer rtRayTracer = new RtRayTracer();
            Image image = rtRayTracer.renderImage(this.world);
            this.callback.renderingDone(image);
        }

        public RenderOnThread(RtWorld rtWorld, InyoJPatchInterface inyoJPatchInterface) {
            this.world = rtWorld;
            this.callback = inyoJPatchInterface;
        }
    }
}

