/*
 * Decompiled with CFR 0.152.
 */
package inyo;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;

class RtCanvas {
    static final int CARTESIAN = 0;
    static final int ABSOLUTE = 1;
    public int high;
    public int wide;
    public int halfHigh;
    public int halfWide;
    BufferedImage image;
    int[] frameBuffer;

    int rgb(int n, int n2, int n3) {
        return 0xFF000000 | (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | n3 & 0xFF;
    }

    final void fill(int n, int n2, int n3) {
        int n4 = this.rgb(n, n2, n3);
        int n5 = this.wide * this.high;
        int n6 = 0;
        while (n6 < n5) {
            this.frameBuffer[n6] = n4;
            ++n6;
        }
    }

    final int getIndex(int n, int n2, int n3) {
        if (n == 1) {
            return n2 + n3 * this.wide;
        }
        int n4 = this.halfWide + n2;
        int n5 = -n3 + this.halfHigh;
        return n4 + n5 * this.wide;
    }

    final void setPixel(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.getIndex(n, n2, n3);
        this.frameBuffer[n7] = 0xFF000000 | (n4 & 0xFF) << 16 | (n5 & 0xFF) << 8 | n6 & 0xFF;
    }

    final void setPixelScaled(int n, int n2, int n3, double d, double d2, double d3) {
        int n4 = this.clip(0, 255, (int)(d * 255.0));
        int n5 = this.clip(0, 255, (int)(d2 * 255.0));
        int n6 = this.clip(0, 255, (int)(d3 * 255.0));
        this.setPixel(n, n2, n3, n4, n5, n6);
    }

    final int clip(int n, int n2, int n3) {
        if (n3 < n) {
            return 0;
        }
        if (n3 > n2) {
            return n2;
        }
        return n3;
    }

    final int getRGB(int n, int n2, int n3) {
        return this.frameBuffer[this.getIndex(n, n2, n3)];
    }

    final int redByte(int n) {
        return n >> 16 & 0xFF;
    }

    final int greenByte(int n) {
        return n >> 8 & 0xFF;
    }

    final int blueByte(int n) {
        return n & 0xFF;
    }

    final boolean outOfRange(int n, int n2, int n3) {
        return n == 1 ? n2 < 0 || n3 < 0 || n2 >= this.wide || n3 >= this.high : n2 < -this.halfWide || n3 < -this.halfHigh || n2 >= this.halfWide || n3 >= this.halfHigh;
    }

    final void addPixel(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.outOfRange(n, n2, n3)) {
            return;
        }
        int n7 = this.getIndex(n, n2, n3);
        int n8 = this.frameBuffer[n7];
        n4 = this.clip(0, 255, n4 + this.redByte(n8));
        n5 = this.clip(0, 255, n5 + this.greenByte(n8));
        n6 = this.clip(0, 255, n6 + this.blueByte(n8));
        this.frameBuffer[n7] = 0xFF000000 | (n4 & 0xFF) << 16 | (n5 & 0xFF) << 8 | n6 & 0xFF;
    }

    final double getRed(int n, int n2, int n3) {
        return this.redByte(this.frameBuffer[this.getIndex(n, n2, n3)]);
    }

    final double getGreen(int n, int n2, int n3) {
        return this.greenByte(this.frameBuffer[this.getIndex(n, n2, n3)]);
    }

    final double getBlue(int n, int n2, int n3) {
        return this.blueByte(this.frameBuffer[this.getIndex(n, n2, n3)]);
    }

    final boolean sameColor(int n, int n2, int n3, int n4, int n5, double d) {
        int n6 = this.frameBuffer[this.getIndex(n, n2, n3)];
        int n7 = this.frameBuffer[this.getIndex(n, n2, n3)];
        double d2 = Math.abs(this.redByte(n6) - this.redByte(n7));
        double d3 = Math.abs(this.greenByte(n6) - this.greenByte(n7));
        double d4 = Math.abs(this.blueByte(n6) - this.blueByte(n7));
        boolean bl = false;
        if (d2 < d && d3 < d && d4 < d && (d2 + d3 + d4) / (double)3 < d) {
            bl = true;
        }
        return bl;
    }

    final double linear(double d, double d2, double d3) {
        return d + (d2 - d) * d3;
    }

    final int bilinear(int n, int n2, int n3, int n4, double d, double d2) {
        double d3 = this.linear(n, n2, d);
        double d4 = this.linear(n3, n4, d);
        return (int)this.linear(d3, d4, d2);
    }

    final void interpolate(int n, int n2, int n3, int n4) {
        n3 = -n3 + this.halfHigh;
        int n5 = (n2 += this.halfWide) + n4;
        int n6 = n3 + n4;
        int n7 = this.frameBuffer[this.getIndex(n, n2, n3)];
        int n8 = this.redByte(n7);
        int n9 = this.greenByte(n7);
        int n10 = this.blueByte(n7);
        n7 = this.frameBuffer[this.getIndex(n, n5, n3)];
        int n11 = this.redByte(n7);
        int n12 = this.greenByte(n7);
        int n13 = this.blueByte(n7);
        n7 = this.frameBuffer[this.getIndex(n, n2, n6)];
        int n14 = this.redByte(n7);
        int n15 = this.greenByte(n7);
        int n16 = this.blueByte(n7);
        n7 = this.frameBuffer[this.getIndex(n, n5, n6)];
        int n17 = this.redByte(n7);
        int n18 = this.greenByte(n7);
        int n19 = this.blueByte(n7);
        double d = 1.0 / (double)(n4 + 1);
        double d2 = 0.0;
        int n20 = n3;
        while (n20 < n6) {
            double d3 = 0.0;
            int n21 = n2;
            while (n21 < n5) {
                int n22 = this.getIndex(n, n21, n20);
                int n23 = this.bilinear(n8, n11, n14, n17, d3, d2);
                int n24 = this.bilinear(n9, n12, n15, n18, d3, d2);
                int n25 = this.bilinear(n10, n13, n16, n19, d3, d2);
                this.frameBuffer[n22] = this.rgb(n23, n24, n25);
                d3 += d;
                ++n21;
            }
            d2 += d;
            ++n20;
        }
    }

    final BufferedImage getImage() {
        return this.image;
    }

    boolean needsResampling(int n, int n2, int n3, double d) {
        if (this.outOfRange(n, n2, n3)) {
            return false;
        }
        int n4 = this.frameBuffer[this.getIndex(n, n2, n3)];
        int n5 = this.redByte(n4);
        int n6 = this.greenByte(n4);
        int n7 = this.blueByte(n4);
        int n8 = -1;
        while (n8 <= 1) {
            int n9 = n3 + n8;
            int n10 = -1;
            while (n10 <= 1) {
                int n11 = n2 + n10;
                if (!(n11 == n2 && n9 == n3 || this.outOfRange(n, n11, n9))) {
                    int n12 = this.frameBuffer[this.getIndex(n, n11, n9)];
                    int n13 = this.redByte(n12);
                    int n14 = this.greenByte(n12);
                    int n15 = this.blueByte(n12);
                    if ((double)Math.abs(this.redByte(n12) - n5) > d) {
                        return true;
                    }
                    if ((double)Math.abs(this.greenByte(n12) - n6) > d) {
                        return true;
                    }
                    if ((double)Math.abs(this.blueByte(n12) - n7) > d) {
                        return true;
                    }
                }
                ++n10;
            }
            ++n8;
        }
        return false;
    }

    void averagePixel(int n, RtCanvas rtCanvas, int n2, int n3) {
        if (this.outOfRange(n, n2, n3)) {
            return;
        }
        int[] nArray = new int[]{1, 4, 2, 2, 8, 4, 2, 4, 2};
        int[] nArray2 = new int[9];
        nArray2[0] = -1;
        nArray2[2] = 1;
        nArray2[3] = -1;
        nArray2[5] = 1;
        nArray2[6] = -1;
        nArray2[8] = 1;
        int[] nArray3 = nArray2;
        int[] nArray4 = new int[9];
        nArray4[0] = -1;
        nArray4[1] = -1;
        nArray4[2] = -1;
        nArray4[6] = 1;
        nArray4[7] = 1;
        nArray4[8] = 1;
        int[] nArray5 = nArray4;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < 9) {
            int n10 = n2 + nArray3[n9];
            int n11 = n3 + nArray5[n9];
            if (!this.outOfRange(n, n10, n11)) {
                n5 = rtCanvas.frameBuffer[this.getIndex(n, n10, n11)];
                n6 += this.redByte(n5) * nArray[n9];
                n7 += this.greenByte(n5) * nArray[n9];
                n8 += this.blueByte(n5) * nArray[n9];
                n4 += nArray[n9];
            }
            ++n9;
        }
        this.setPixel(n, n2, n3, n6 /= n4, n7 /= n4, n8 /= n4);
    }

    public RtCanvas(int n, int n2) {
        this.high = ++n2;
        this.wide = ++n;
        this.halfHigh = n2 / 2;
        this.halfWide = n / 2;
        this.image = new BufferedImage(n, n2, 1);
        this.frameBuffer = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
    }

    public RtCanvas(RtCanvas rtCanvas) {
        this.high = rtCanvas.high;
        this.wide = rtCanvas.wide;
        this.halfHigh = rtCanvas.halfHigh;
        this.halfWide = rtCanvas.halfWide;
        WritableRaster writableRaster = rtCanvas.getImage().copyData(null);
        this.image = new BufferedImage(this.wide, this.high, 1);
        this.image.setData(writableRaster);
        this.frameBuffer = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
    }
}

