/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.awt.Point;
import java.util.HashMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.remotecontrol.AddTagsDialog;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddNodeHandler
extends RequestHandler {
    public static final String command = "add_node";
    private double lat;
    private double lon;

    @Override
    protected void handleRequest() {
        GuiHelper.runInEDTAndWait(new Runnable(){

            public void run() {
                AddNodeHandler.this.addNode(AddNodeHandler.this.args);
            }
        });
    }

    @Override
    public String[] getMandatoryParams() {
        return new String[]{"lat", "lon"};
    }

    @Override
    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to create a new node.", new Object[0]) + "<br>" + I18n.tr("Coordinates: ", new Object[0]) + (String)this.args.get("lat") + ", " + (String)this.args.get("lon");
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.CREATE_OBJECTS;
    }

    private void addNode(HashMap<String, String> hashMap) {
        Point point;
        System.out.println("Adding node at (" + this.lat + ", " + this.lon + ")");
        LatLon latLon = new LatLon(this.lat, this.lon);
        Node node = null;
        if (Main.map != null && Main.map.mapView != null && (node = Main.map.mapView.getNearestNode(point = Main.map.mapView.getPoint(latLon), OsmPrimitive.isUsablePredicate)) != null && node.getCoor().greatCircleDistance(latLon) > Main.pref.getDouble("remotecontrol.tolerance", 0.1)) {
            node = null;
        }
        if (node == null) {
            node = new Node(latLon);
            Main.main.undoRedo.add(new AddCommand(node));
        }
        Main.main.getCurrentDataSet().setSelected(node);
        if (PermissionPrefWithDefault.CHANGE_VIEWPORT.isAllowed()) {
            AutoScaleAction.autoScale("selection");
        } else {
            Main.map.mapView.repaint();
        }
        AddTagsDialog.addTags(hashMap, this.sender);
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        try {
            this.lat = Double.parseDouble((String)this.args.get("lat"));
            this.lon = Double.parseDouble((String)this.args.get("lon"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RequestHandler.RequestHandlerBadRequestException("NumberFormatException (" + numberFormatException.getMessage() + ")");
        }
        if (!Main.main.hasEditLayer()) {
            throw new RequestHandler.RequestHandlerBadRequestException(I18n.tr("There is no layer opened to add node", new Object[0]));
        }
    }
}

