/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.io.remotecontrol.handler.AddNodeHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.AddWayHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.ImageryHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.ImportHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.LoadAndZoomHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.LoadObjectHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.OpenFileHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.VersionHandler;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestProcessor
extends Thread {
    public static final String PROTOCOLVERSION = "{\"protocolversion\": {\"major\": 1, \"minor\": 5}, \"application\": \"JOSM RemoteControl\"}";
    private Socket request;
    private static Map<String, Class<? extends RequestHandler>> handlers = new TreeMap<String, Class<? extends RequestHandler>>();

    public RequestProcessor(Socket socket) {
        super("RemoteControl request processor");
        this.setDaemon(true);
        this.request = socket;
    }

    public static void processRequest(Socket socket) {
        RequestProcessor requestProcessor = new RequestProcessor(socket);
        requestProcessor.start();
    }

    static void addRequestHandlerClass(String string, Class<? extends RequestHandler> clazz) {
        RequestProcessor.addRequestHandlerClass(string, clazz, false);
    }

    private static void addRequestHandlerClass(String string, Class<? extends RequestHandler> clazz, boolean bl) {
        String string2;
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        if (handlers.get(string2 = "/" + string) != null) {
            System.out.println("RemoteControl: ignoring duplicate command " + string + " with handler " + clazz.getName());
        } else {
            if (!bl) {
                System.out.println("RemoteControl: adding command \"" + string + "\" (handled by " + clazz.getSimpleName() + ")");
            }
            handlers.put(string2, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        OutputStreamWriter outputStreamWriter = null;
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.request.getOutputStream());
            outputStreamWriter = new OutputStreamWriter(bufferedOutputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.request.getInputStream(), "ASCII"));
            String string = bufferedReader.readLine();
            if (string == null) {
                this.sendError(outputStreamWriter);
                return;
            }
            System.out.println("RemoteControl received: " + string);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.hasMoreTokens()) {
                this.sendError(outputStreamWriter);
                return;
            }
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                this.sendError(outputStreamWriter);
                return;
            }
            String string3 = stringTokenizer.nextToken();
            if (!string2.equals("GET")) {
                this.sendNotImplemented(outputStreamWriter);
                return;
            }
            int n = string3.indexOf(63);
            String string4 = n < 0 ? string3 : string3.substring(0, n);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n2 = 20;
            for (int i = 0; i < n2 && (string = bufferedReader.readLine()) != null; ++i) {
                object4 = string.split(": ", 2);
                if (((String[])object4).length != 2) break;
                hashMap.put(object4[0], object4[1]);
            }
            object4 = null;
            if (!this.request.getInetAddress().isLoopbackAddress()) {
                object4 = this.request.getInetAddress().getHostAddress();
            } else {
                object3 = (String)hashMap.get("Referer");
                object2 = Pattern.compile("(https?://)?([^/]*)");
                if (object3 != null && ((Matcher)(object = ((Pattern)object2).matcher((CharSequence)object3))).find()) {
                    object4 = ((Matcher)object).group(2);
                }
                if (object4 == null) {
                    object4 = "localhost";
                }
            }
            object3 = handlers.get(string4);
            if (object3 == null) {
                object2 = new StringBuilder(1024);
                object = handlers.entrySet().iterator();
                while (true) {
                    if (!object.hasNext()) {
                        object = "http://josm.openstreetmap.de/wiki/Help/Preferences/RemoteControl";
                        String string5 = "No command specified! The following commands are available:<ul>" + ((StringBuilder)object2).toString() + "</ul>" + "See <a href=\"" + (String)object + "\">" + (String)object + "</a> for complete documentation.";
                        this.sendBadRequest(outputStreamWriter, string5);
                        return;
                    }
                    Map.Entry entry = (Map.Entry)object.next();
                    String[] stringArray = ((RequestHandler)((Class)entry.getValue()).newInstance()).getMandatoryParams();
                    ((StringBuilder)object2).append("<li>");
                    ((StringBuilder)object2).append((String)entry.getKey());
                    if (stringArray != null) {
                        ((StringBuilder)object2).append("<br/>mandatory parameter: ").append(Utils.join(", ", Arrays.asList(stringArray)));
                    }
                    ((StringBuilder)object2).append("</li>");
                }
            }
            object2 = (RequestHandler)((Class)object3).newInstance();
            try {
                ((RequestHandler)object2).setCommand(string4);
                ((RequestHandler)object2).setUrl(string3);
                ((RequestHandler)object2).setSender((String)object4);
                ((RequestHandler)object2).handle();
                this.sendHeader(outputStreamWriter, "200 OK", ((RequestHandler)object2).getContentType(), false);
                outputStreamWriter.write("Content-length: " + ((RequestHandler)object2).getContent().length() + "\r\n");
                outputStreamWriter.write("\r\n");
                outputStreamWriter.write(((RequestHandler)object2).getContent());
                ((Writer)outputStreamWriter).flush();
                return;
            }
            catch (RequestHandler.RequestHandlerErrorException requestHandlerErrorException) {
                this.sendError(outputStreamWriter);
                return;
            }
            catch (RequestHandler.RequestHandlerBadRequestException requestHandlerBadRequestException) {
                this.sendBadRequest(outputStreamWriter, requestHandlerBadRequestException.getMessage());
                return;
            }
            catch (RequestHandler.RequestHandlerForbiddenException requestHandlerForbiddenException) {
                this.sendForbidden(outputStreamWriter, requestHandlerForbiddenException.getMessage());
                return;
            }
        }
        catch (IOException iOException) {
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                this.sendError(outputStreamWriter);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
                return;
            }
        }
        finally {
            try {
                this.request.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void sendError(Writer writer) throws IOException {
        this.sendHeader(writer, "500 Internal Server Error", "text/html", true);
        writer.write("<HTML>\r\n");
        writer.write("<HEAD><TITLE>Internal Error</TITLE>\r\n");
        writer.write("</HEAD>\r\n");
        writer.write("<BODY>");
        writer.write("<H1>HTTP Error 500: Internal Server Error</h2>\r\n");
        writer.write("</BODY></HTML>\r\n");
        writer.flush();
    }

    private void sendNotImplemented(Writer writer) throws IOException {
        this.sendHeader(writer, "501 Not Implemented", "text/html", true);
        writer.write("<HTML>\r\n");
        writer.write("<HEAD><TITLE>Not Implemented</TITLE>\r\n");
        writer.write("</HEAD>\r\n");
        writer.write("<BODY>");
        writer.write("<H1>HTTP Error 501: Not Implemented</h2>\r\n");
        writer.write("</BODY></HTML>\r\n");
        writer.flush();
    }

    private void sendForbidden(Writer writer, String string) throws IOException {
        this.sendHeader(writer, "403 Forbidden", "text/html", true);
        writer.write("<HTML>\r\n");
        writer.write("<HEAD><TITLE>Forbidden</TITLE>\r\n");
        writer.write("</HEAD>\r\n");
        writer.write("<BODY>");
        writer.write("<H1>HTTP Error 403: Forbidden</h2>\r\n");
        if (string != null) {
            writer.write(string);
        }
        writer.write("</BODY></HTML>\r\n");
        writer.flush();
    }

    private void sendBadRequest(Writer writer, String string) throws IOException {
        this.sendHeader(writer, "400 Bad Request", "text/html", true);
        writer.write("<HTML>\r\n");
        writer.write("<HEAD><TITLE>Bad Request</TITLE>\r\n");
        writer.write("</HEAD>\r\n");
        writer.write("<BODY>");
        writer.write("<H1>HTTP Error 400: Bad Request</h2>\r\n");
        if (string != null) {
            writer.write(string);
        }
        writer.write("</BODY></HTML>\r\n");
        writer.flush();
    }

    private void sendHeader(Writer writer, String string, String string2, boolean bl) throws IOException {
        writer.write("HTTP/1.1 " + string + "\r\n");
        Date date = new Date();
        writer.write("Date: " + date + "\r\n");
        writer.write("Server: JOSM RemoteControl\r\n");
        writer.write("Content-type: " + string2 + "\r\n");
        writer.write("Access-Control-Allow-Origin: *\r\n");
        if (bl) {
            writer.write("\r\n");
        }
    }

    static {
        RequestProcessor.addRequestHandlerClass("load_and_zoom", LoadAndZoomHandler.class, true);
        RequestProcessor.addRequestHandlerClass("zoom", LoadAndZoomHandler.class, true);
        RequestProcessor.addRequestHandlerClass("imagery", ImageryHandler.class, true);
        RequestProcessor.addRequestHandlerClass("add_node", AddNodeHandler.class, true);
        RequestProcessor.addRequestHandlerClass("add_way", AddWayHandler.class, true);
        RequestProcessor.addRequestHandlerClass("import", ImportHandler.class, true);
        RequestProcessor.addRequestHandlerClass("version", VersionHandler.class, true);
        RequestProcessor.addRequestHandlerClass("load_object", LoadObjectHandler.class, true);
        RequestProcessor.addRequestHandlerClass("open_file", OpenFileHandler.class, true);
    }
}

