/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.gui.widgets.TextContextualPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JosmComboBox
extends JComboBox {
    public static final String DEFAULT_PROTOTYPE_DISPLAY_VALUE = "Prototype display value";

    public JosmComboBox() {
        this(DEFAULT_PROTOTYPE_DISPLAY_VALUE);
    }

    public JosmComboBox(Object object) {
        this.init(object);
    }

    public JosmComboBox(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        ArrayList arrayList = new ArrayList(comboBoxModel.getSize());
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            arrayList.add(comboBoxModel.getElementAt(i));
        }
        this.init(this.findPrototypeDisplayValue(arrayList));
    }

    public JosmComboBox(Object[] objectArray) {
        super(objectArray);
        this.init(this.findPrototypeDisplayValue(Arrays.asList(objectArray)));
    }

    public JosmComboBox(Vector<?> vector) {
        super(vector);
        this.init(this.findPrototypeDisplayValue(vector));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object findPrototypeDisplayValue(Collection<?> collection) {
        Object var2_2 = null;
        int n = -1;
        if (collection != null) {
            Object e = this.getPrototypeDisplayValue();
            JList jList = this.getList();
            try {
                int n2 = 0;
                for (Object obj : collection) {
                    Component component;
                    if (obj != null && (component = this.getRenderer().getListCellRendererComponent(jList, obj, n2, true, true)) != null) {
                        Dimension dimension = component.getPreferredSize();
                        if (dimension.height > n) {
                            n = dimension.height;
                            var2_2 = obj;
                        }
                    }
                    ++n2;
                }
            }
            finally {
                this.setPrototypeDisplayValue(e);
            }
        }
        return var2_2;
    }

    protected final JList getList() {
        for (int i = 0; i < this.getUI().getAccessibleChildrenCount(this); ++i) {
            Accessible accessible = this.getUI().getAccessibleChild(this, i);
            if (!(accessible instanceof ComboPopup)) continue;
            return ((ComboPopup)((Object)accessible)).getList();
        }
        return null;
    }

    protected void init(Object object) {
        if (object != null) {
            this.setPrototypeDisplayValue(object);
            int n = Toolkit.getDefaultToolkit().getScreenSize().height;
            int n2 = n / this.getPreferredSize().height / 2;
            JList jList = this.getList();
            if (jList != null) {
                int n3;
                if (jList.getPrototypeCellValue() != object) {
                    jList.setPrototypeCellValue(object);
                }
                if ((n3 = jList.getFixedCellHeight()) > 0) {
                    n2 = n / n3 / 2;
                }
            }
            this.setMaximumRowCount(Math.max(this.getMaximumRowCount(), n2));
        }
        ContextMenuHandler contextMenuHandler = new ContextMenuHandler();
        this.addPropertyChangeListener("editable", contextMenuHandler);
        this.addPropertyChangeListener("editor", contextMenuHandler);
    }

    public final void reinitialize(Collection<?> collection) {
        this.init(this.findPrototypeDisplayValue(collection));
    }

    protected class ContextMenuHandler
    extends MouseAdapter
    implements PropertyChangeListener {
        private JTextComponent component;
        private PopupMenuLauncher launcher;

        protected ContextMenuHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("editable")) {
                if (propertyChangeEvent.getNewValue().equals(true)) {
                    this.enableMenu();
                } else {
                    this.disableMenu();
                }
            } else if (propertyChangeEvent.getPropertyName().equals("editor")) {
                this.disableMenu();
                if (JosmComboBox.this.isEditable()) {
                    this.enableMenu();
                }
            }
        }

        private void enableMenu() {
            Component component;
            if (this.launcher == null && (component = JosmComboBox.this.getEditor().getEditorComponent()) instanceof JTextComponent) {
                this.component = (JTextComponent)component;
                this.component.addMouseListener(this);
                this.launcher = TextContextualPopupMenu.enableMenuFor(this.component);
            }
        }

        private void disableMenu() {
            if (this.launcher != null) {
                TextContextualPopupMenu.disableMenuFor(this.component, this.launcher);
                this.launcher = null;
                this.component.removeMouseListener(this);
                this.component = null;
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.processEvent(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.processEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.processEvent(mouseEvent);
        }

        private void processEvent(MouseEvent mouseEvent) {
            if (this.launcher != null && !mouseEvent.isPopupTrigger() && this.launcher.getMenu().isShowing()) {
                this.launcher.getMenu().setVisible(false);
            }
        }
    }
}

