/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.plugin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.gui.preferences.plugin.PluginPreferencesModel;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginListPanel
extends VerticallyScrollablePanel {
    private PluginPreferencesModel model;

    public PluginListPanel() {
        this(new PluginPreferencesModel());
    }

    public PluginListPanel(PluginPreferencesModel pluginPreferencesModel) {
        this.model = pluginPreferencesModel;
        this.setLayout(new GridBagLayout());
    }

    protected String formatPluginRemoteVersion(PluginInformation pluginInformation) {
        StringBuilder stringBuilder = new StringBuilder();
        if (pluginInformation.version == null || pluginInformation.version.trim().equals("")) {
            stringBuilder.append(I18n.tr("unknown", new Object[0]));
        } else {
            stringBuilder.append(pluginInformation.version);
            if (pluginInformation.oldmode) {
                stringBuilder.append("*");
            }
        }
        return stringBuilder.toString();
    }

    protected String formatPluginLocalVersion(PluginInformation pluginInformation) {
        if (pluginInformation == null) {
            return I18n.tr("unknown", new Object[0]);
        }
        if (pluginInformation.localversion == null || pluginInformation.localversion.trim().equals("")) {
            return I18n.tr("unknown", new Object[0]);
        }
        return pluginInformation.localversion;
    }

    protected String formatCheckboxTooltipText(PluginInformation pluginInformation) {
        if (pluginInformation == null) {
            return "";
        }
        if (pluginInformation.downloadlink == null) {
            return I18n.tr("Plugin bundled with JOSM", new Object[0]);
        }
        return pluginInformation.downloadlink;
    }

    public void displayEmptyPluginListInformation() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(40, 0, 40, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        HtmlPanel htmlPanel = new HtmlPanel();
        htmlPanel.setText("<html>" + I18n.tr("Please click on <strong>Download list</strong> to download and display a list of available plugins.", new Object[0]) + "</html>");
        this.add((Component)htmlPanel, gridBagConstraints);
    }

    private static void alertPluginStillRequired(Component component, String string, Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(I18n.trn("Plugin {0} is still required by this plugin:", "Plugin {0} is still required by these {1} plugins:", set.size(), string, set.size()));
        stringBuilder.append("<ul>");
        for (String string2 : set) {
            stringBuilder.append("<li>").append(string2).append("</li>");
        }
        stringBuilder.append("</ul>").append("</html>");
        JOptionPane.showMessageDialog(component, stringBuilder.toString(), I18n.tr("Warning", new Object[0]), 2);
    }

    public void refreshView() {
        final Rectangle rectangle = this.getVisibleRect();
        List<PluginInformation> list = this.model.getDisplayedPlugins();
        this.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        if (list.isEmpty()) {
            this.displayEmptyPluginListInformation();
            return;
        }
        int n = -1;
        for (PluginInformation pluginInformation : list) {
            boolean bl = this.model.isSelectedPlugin(pluginInformation.getName());
            String string = this.formatPluginRemoteVersion(pluginInformation);
            String string2 = this.formatPluginLocalVersion(this.model.getPluginInformation(pluginInformation.getName()));
            JPluginCheckBox jPluginCheckBox = new JPluginCheckBox(pluginInformation, bl);
            String string3 = I18n.tr("{0}: Version {1} (local: {2})", pluginInformation.getName(), string, string2);
            if (pluginInformation.requires != null && !pluginInformation.requires.isEmpty()) {
                string3 = string3 + I18n.tr(" (requires: {0})", pluginInformation.requires);
            }
            JLabel jLabel = new JLabel(string3, pluginInformation.getScaledIcon(), 2);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = ++n;
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)jPluginCheckBox, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)jLabel, gridBagConstraints);
            HtmlPanel htmlPanel = new HtmlPanel();
            htmlPanel.setText(pluginInformation.getDescriptionAsHtml());
            htmlPanel.getEditorPane().addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        OpenBrowser.displayUrl(hyperlinkEvent.getURL().toString());
                    }
                }
            });
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = ++n;
            gridBagConstraints.insets = new Insets(3, 25, 5, 5);
            gridBagConstraints.weighty = 1.0;
            this.add((Component)htmlPanel, gridBagConstraints);
        }
        this.revalidate();
        this.repaint();
        if (rectangle != null && rectangle.width > 0 && rectangle.height > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PluginListPanel.this.scrollRectToVisible(rectangle);
                }
            });
        }
    }

    private class PluginCbActionListener
    implements ActionListener {
        private final JPluginCheckBox cb;

        public PluginCbActionListener(JPluginCheckBox jPluginCheckBox) {
            this.cb = jPluginCheckBox;
        }

        protected void selectRequiredPlugins(PluginInformation pluginInformation) {
            if (pluginInformation != null && pluginInformation.requires != null) {
                for (String string : pluginInformation.getRequiredPlugins()) {
                    if (PluginListPanel.this.model.isSelectedPlugin(string)) continue;
                    PluginListPanel.this.model.setPluginSelected(string, true);
                    this.selectRequiredPlugins(PluginListPanel.this.model.getPluginInformation(string));
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PluginListPanel.this.model.setPluginSelected(this.cb.pi.getName(), this.cb.isSelected());
            if (this.cb.isSelected() && this.cb.pi.requires != null) {
                this.selectRequiredPlugins(this.cb.pi);
                PluginHandler.checkRequiredPluginsPreconditions(PluginListPanel.this, PluginListPanel.this.model.getAvailablePlugins(), this.cb.pi, false);
            } else if (!this.cb.isSelected()) {
                HashSet<String> hashSet = new HashSet<String>();
                block0: for (PluginInformation pluginInformation : PluginListPanel.this.model.getAvailablePlugins()) {
                    if (pluginInformation.equals(this.cb.pi) || pluginInformation.requires == null || !PluginListPanel.this.model.isSelectedPlugin(pluginInformation.getName())) continue;
                    for (String string : pluginInformation.getRequiredPlugins()) {
                        if (!string.equals(this.cb.pi.getName())) continue;
                        hashSet.add(pluginInformation.getName());
                        continue block0;
                    }
                }
                if (!hashSet.isEmpty()) {
                    PluginListPanel.alertPluginStillRequired(PluginListPanel.this, this.cb.pi.getName(), hashSet);
                }
            }
        }
    }

    private class JPluginCheckBox
    extends JCheckBox {
        public final PluginInformation pi;

        public JPluginCheckBox(PluginInformation pluginInformation, boolean bl) {
            this.pi = pluginInformation;
            this.setSelected(bl);
            this.setToolTipText(PluginListPanel.this.formatCheckboxTooltipText(pluginInformation));
            this.addActionListener(new PluginCbActionListener(this));
        }
    }
}

