/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.relation.DownloadSelectedIncompleteMembersAction;
import org.openstreetmap.josm.actions.relation.EditRelationAction;
import org.openstreetmap.josm.actions.relation.SelectInRelationListAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveComparator;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.PopupMenuHandler;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.ListPopupMenu;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionListDialog
extends ToggleDialog {
    private JList lstPrimitives;
    private DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
    private SelectionListModel model = new SelectionListModel(this.selectionModel);
    private SelectAction actSelect = new SelectAction();
    private SearchAction actSearch = new SearchAction();
    private ZoomToJOSMSelectionAction actZoomToJOSMSelection = new ZoomToJOSMSelectionAction();
    private ZoomToListSelection actZoomToListSelection = new ZoomToListSelection();
    private SelectInRelationListAction actSetRelationSelection = new SelectInRelationListAction();
    private EditRelationAction actEditRelationSelection = new EditRelationAction();
    private DownloadSelectedIncompleteMembersAction actDownloadSelectedIncompleteMembers = new DownloadSelectedIncompleteMembersAction();
    private final ListPopupMenu popupMenu;
    private final PopupMenuHandler popupMenuHandler;

    protected void buildContentPanel() {
        this.lstPrimitives = new JList(this.model);
        this.lstPrimitives.setSelectionMode(2);
        this.lstPrimitives.setSelectionModel(this.selectionModel);
        this.lstPrimitives.setCellRenderer(new OsmPrimitivRenderer());
        this.lstPrimitives.setTransferHandler(null);
        final SideButton sideButton = new SideButton(this.actSelect);
        this.lstPrimitives.getSelectionModel().addListSelectionListener(this.actSelect);
        sideButton.createArrow(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectionHistoryPopup.launch(sideButton, SelectionListDialog.this.model.getSelectionHistory());
            }
        });
        final SideButton sideButton2 = new SideButton(this.actSearch);
        sideButton2.createArrow(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchPopupMenu.launch(sideButton2);
            }
        });
        this.createLayout(this.lstPrimitives, true, Arrays.asList(sideButton, sideButton2));
    }

    public SelectionListDialog() {
        super(I18n.tr("Selection", new Object[0]), "selectionlist", I18n.tr("Open a selection list window.", new Object[0]), Shortcut.registerShortcut("subwindow:selection", I18n.tr("Toggle: {0}", I18n.tr("Current Selection", new Object[0])), 84, 5007), 150, true);
        this.buildContentPanel();
        this.model.addListDataListener(new TitleUpdater());
        this.model.addListDataListener(this.actZoomToJOSMSelection);
        this.popupMenu = new ListPopupMenu(this.lstPrimitives);
        this.popupMenuHandler = this.setupPopupMenuHandler();
        this.lstPrimitives.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SelectionListDialog.this.actZoomToListSelection.valueChanged(listSelectionEvent);
                SelectionListDialog.this.popupMenuHandler.setPrimitives(SelectionListDialog.this.model.getSelected());
            }
        });
        this.lstPrimitives.addMouseListener(new MouseEventHandler());
        InputMapUtils.addEnterAction(this.lstPrimitives, this.actZoomToListSelection);
    }

    @Override
    public void showNotify() {
        MapView.addEditLayerChangeListener(this.model);
        SelectionEventManager.getInstance().addSelectionListener(this.model, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        DatasetEventManager.getInstance().addDatasetListener(this.model, DatasetEventManager.FireMode.IN_EDT);
        MapView.addEditLayerChangeListener(this.actSearch);
        this.model.editLayerChanged(null, Main.map.mapView.getEditLayer());
        if (Main.map.mapView.getEditLayer() != null) {
            this.model.setJOSMSelection(Main.map.mapView.getEditLayer().data.getAllSelected());
        }
        this.actSearch.updateEnabledState();
    }

    @Override
    public void hideNotify() {
        MapView.removeEditLayerChangeListener(this.actSearch);
        MapView.removeEditLayerChangeListener(this.model);
        SelectionEventManager.getInstance().removeSelectionListener(this.model);
        DatasetEventManager.getInstance().removeDatasetListener(this.model);
    }

    private PopupMenuHandler setupPopupMenuHandler() {
        PopupMenuHandler popupMenuHandler = new PopupMenuHandler(this.popupMenu);
        popupMenuHandler.addAction(this.actZoomToJOSMSelection);
        popupMenuHandler.addAction(this.actZoomToListSelection);
        popupMenuHandler.addSeparator();
        popupMenuHandler.addAction(this.actSetRelationSelection);
        popupMenuHandler.addAction(this.actEditRelationSelection);
        popupMenuHandler.addSeparator();
        popupMenuHandler.addAction(this.actDownloadSelectedIncompleteMembers);
        return popupMenuHandler;
    }

    public PopupMenuHandler getPopupMenuHandler() {
        return this.popupMenuHandler;
    }

    public Collection<OsmPrimitive> getSelectedPrimitives() {
        return this.model.getSelected();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OsmPrimitiveQuickComparator
    implements Comparator<OsmPrimitive> {
        private OsmPrimitiveQuickComparator() {
        }

        private int compareId(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
            long l;
            long l2 = osmPrimitive.getUniqueId();
            if (l2 < (l = osmPrimitive2.getUniqueId())) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            return 0;
        }

        private int compareType(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
            if (osmPrimitive.getType().equals((Object)OsmPrimitiveType.WAY)) {
                return -1;
            }
            if (osmPrimitive.getType().equals((Object)OsmPrimitiveType.NODE)) {
                return 1;
            }
            if (osmPrimitive2.getType().equals((Object)OsmPrimitiveType.WAY)) {
                return 1;
            }
            return -1;
        }

        @Override
        public int compare(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
            if (osmPrimitive.getType().equals((Object)osmPrimitive2.getType())) {
                return this.compareId(osmPrimitive, osmPrimitive2);
            }
            return this.compareType(osmPrimitive, osmPrimitive2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SelectionHistoryPopup
    extends JPopupMenu {
        public static void launch(Component component, Collection<Collection<? extends OsmPrimitive>> collection) {
            if (collection == null || collection.isEmpty()) {
                return;
            }
            SelectionHistoryPopup selectionHistoryPopup = new SelectionHistoryPopup(collection);
            Rectangle rectangle = component.getBounds();
            selectionHistoryPopup.show(component, rectangle.x, rectangle.y + rectangle.height);
        }

        public SelectionHistoryPopup(Collection<Collection<? extends OsmPrimitive>> collection) {
            for (Collection<? extends OsmPrimitive> collection2 : collection) {
                this.add(new SelectionMenuItem(collection2));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SelectionMenuItem
    extends JMenuItem
    implements ActionListener {
        private final DefaultNameFormatter df = DefaultNameFormatter.getInstance();
        protected Collection<? extends OsmPrimitive> sel;

        public SelectionMenuItem(Collection<? extends OsmPrimitive> collection) {
            this.sel = collection;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (OsmPrimitive object : collection) {
                if (!object.isSelectable()) continue;
                if (object instanceof Way) {
                    ++n;
                    continue;
                }
                if (object instanceof Node) {
                    ++n2;
                    continue;
                }
                if (!(object instanceof Relation)) continue;
                ++n3;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (n != 0) {
                stringBuffer.append(stringBuffer.length() > 0 ? ", " : "").append(I18n.trn("{0} way", "{0} ways", n, n));
            }
            if (n2 != 0) {
                stringBuffer.append(stringBuffer.length() > 0 ? ", " : "").append(I18n.trn("{0} node", "{0} nodes", n2, n2));
            }
            if (n3 != 0) {
                stringBuffer.append(stringBuffer.length() > 0 ? ", " : "").append(I18n.trn("{0} relation", "{0} relations", n3, n3));
            }
            if (n + n2 + n3 == 0) {
                stringBuffer.append(I18n.tr("Unselectable now", new Object[0]));
                this.sel = new ArrayList<OsmPrimitive>();
            }
            if (n + n2 + n3 == 1) {
                stringBuffer.append(": ");
                for (OsmPrimitive osmPrimitive : collection) {
                    stringBuffer.append(osmPrimitive.getDisplayName(this.df));
                }
                this.setText(stringBuffer.toString());
            } else {
                this.setText(I18n.tr("Selection: {0}", stringBuffer));
            }
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Main.main.getCurrentDataSet().setSelected(this.sel);
        }
    }

    protected static class SearchPopupMenu
    extends JPopupMenu {
        public static void launch(Component component) {
            if (org.openstreetmap.josm.actions.search.SearchAction.getSearchHistory().isEmpty()) {
                return;
            }
            SearchPopupMenu searchPopupMenu = new SearchPopupMenu();
            Rectangle rectangle = component.getBounds();
            searchPopupMenu.show(component, rectangle.x, rectangle.y + rectangle.height);
        }

        public SearchPopupMenu() {
            for (SearchAction.SearchSetting searchSetting : org.openstreetmap.josm.actions.search.SearchAction.getSearchHistory()) {
                this.add(new SearchMenuItem(searchSetting));
            }
        }
    }

    protected static class SearchMenuItem
    extends JMenuItem
    implements ActionListener {
        protected final SearchAction.SearchSetting s;

        public SearchMenuItem(SearchAction.SearchSetting searchSetting) {
            super(searchSetting.toString());
            this.s = searchSetting;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            org.openstreetmap.josm.actions.search.SearchAction.searchWithoutHistory(this.s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SelectionListModel
    extends AbstractListModel
    implements MapView.EditLayerChangeListener,
    SelectionChangedListener,
    DataSetListener {
        private static final int SELECTION_HISTORY_SIZE = 10;
        private LinkedList<Collection<? extends OsmPrimitive>> history;
        private final List<OsmPrimitive> selection = new ArrayList<OsmPrimitive>();
        private DefaultListSelectionModel selectionModel;

        public SelectionListModel(DefaultListSelectionModel defaultListSelectionModel) {
            this.selectionModel = defaultListSelectionModel;
        }

        public String getJOSMSelectionSummary() {
            if (this.selection.isEmpty()) {
                return I18n.tr("Selection", new Object[0]);
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (OsmPrimitive osmPrimitive : this.selection) {
                switch (osmPrimitive.getType()) {
                    case NODE: {
                        ++n;
                        break;
                    }
                    case WAY: {
                        ++n2;
                        break;
                    }
                    case RELATION: {
                        ++n3;
                    }
                }
            }
            return I18n.tr("Sel.: Rel.:{0} / Ways:{1} / Nodes:{2}", n3, n2, n);
        }

        public void remember(Collection<? extends OsmPrimitive> collection) {
            int n;
            if (collection == null) {
                return;
            }
            if (collection.isEmpty()) {
                return;
            }
            if (this.history == null) {
                return;
            }
            if (this.history.isEmpty()) {
                this.history.add(collection);
                return;
            }
            if (((Object)this.history.getFirst()).equals(collection)) {
                return;
            }
            this.history.addFirst(collection);
            for (n = 1; n < this.history.size(); ++n) {
                if (!((Object)this.history.get(n)).equals(collection)) continue;
                this.history.remove(n);
                break;
            }
            n = Main.pref.getInteger("select.history-size", 10);
            while (this.history.size() > n) {
                this.history.removeLast();
            }
        }

        public List<Collection<? extends OsmPrimitive>> getSelectionHistory() {
            return this.history;
        }

        @Override
        public Object getElementAt(int n) {
            return this.selection.get(n);
        }

        @Override
        public int getSize() {
            return this.selection.size();
        }

        public Collection<OsmPrimitive> getSelected() {
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                hashSet.add(this.selection.get(i));
            }
            return hashSet;
        }

        public void setSelected(Collection<OsmPrimitive> collection) {
            this.selectionModel.clearSelection();
            if (collection == null) {
                return;
            }
            for (OsmPrimitive osmPrimitive : collection) {
                int n = this.selection.indexOf(osmPrimitive);
                if (n < 0) continue;
                this.selectionModel.addSelectionInterval(n, n);
            }
        }

        @Override
        protected void fireContentsChanged(Object object, int n, int n2) {
            Collection<OsmPrimitive> collection = this.getSelected();
            super.fireContentsChanged(object, n, n2);
            this.setSelected(collection);
        }

        public void setJOSMSelection(final Collection<? extends OsmPrimitive> collection) {
            this.selection.clear();
            if (collection != null) {
                this.selection.addAll(collection);
                this.sort();
            }
            GuiHelper.runInEDTAndWait(new Runnable(){

                public void run() {
                    SelectionListModel.this.fireContentsChanged(this, 0, SelectionListModel.this.getSize());
                    if (collection != null) {
                        SelectionListModel.this.remember(collection);
                        double d = -1.0;
                        SubclassFilteredCollection subclassFilteredCollection = new SubclassFilteredCollection(collection, OsmPrimitive.wayPredicate);
                        int n = Math.max(1, Main.pref.getInteger("selection.max-ways-for-statusline", 250));
                        if (!subclassFilteredCollection.isEmpty() && subclassFilteredCollection.size() <= n) {
                            d = 0.0;
                            for (Way way : subclassFilteredCollection) {
                                d += way.getLength();
                            }
                        }
                        Main.map.statusLine.setDist(d);
                    }
                }
            });
        }

        public void update(Collection<? extends OsmPrimitive> collection) {
            if (collection == null) {
                return;
            }
            if (collection.isEmpty()) {
                return;
            }
            Collection<OsmPrimitive> collection2 = this.getSelected();
            for (OsmPrimitive osmPrimitive : collection) {
                int n = this.selection.indexOf(osmPrimitive);
                if (n < 0) continue;
                super.fireContentsChanged(this, n, n);
            }
            this.setSelected(collection2);
        }

        public void sort() {
            if (this.selection.size() > Main.pref.getInteger("selection.no_sort_above", 100000)) {
                return;
            }
            if (this.selection.size() > Main.pref.getInteger("selection.fast_sort_above", 10000)) {
                Collections.sort(this.selection, new OsmPrimitiveQuickComparator());
            } else {
                Collections.sort(this.selection, new OsmPrimitiveComparator());
            }
        }

        @Override
        public void editLayerChanged(OsmDataLayer osmDataLayer, OsmDataLayer osmDataLayer2) {
            if (osmDataLayer2 == null) {
                this.setJOSMSelection(null);
                this.history = null;
            } else {
                this.history = osmDataLayer2.data.getSelectionHistory();
                this.setJOSMSelection(osmDataLayer2.data.getAllSelected());
            }
        }

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
            this.setJOSMSelection(collection);
        }

        @Override
        public void dataChanged(DataChangedEvent dataChangedEvent) {
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
            this.update(nodeMovedEvent.getPrimitives());
        }

        @Override
        public void otherDatasetChange(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
            this.update(abstractDatasetChangedEvent.getPrimitives());
        }

        @Override
        public void relationMembersChanged(RelationMembersChangedEvent relationMembersChangedEvent) {
            this.update(relationMembersChangedEvent.getPrimitives());
        }

        @Override
        public void tagsChanged(TagsChangedEvent tagsChangedEvent) {
            this.update(tagsChangedEvent.getPrimitives());
        }

        @Override
        public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
            this.update(wayNodesChangedEvent.getPrimitives());
        }

        @Override
        public void primitivesAdded(PrimitivesAddedEvent primitivesAddedEvent) {
        }

        @Override
        public void primitivesRemoved(PrimitivesRemovedEvent primitivesRemovedEvent) {
        }
    }

    class ZoomToListSelection
    extends AbstractAction
    implements ListSelectionListener {
        public ZoomToListSelection() {
            this.putValue("Name", I18n.tr("Zoom to selected element(s)", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Zoom to selected element(s)", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/autoscale", "selection"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
            Collection<OsmPrimitive> collection = SelectionListDialog.this.model.getSelected();
            if (collection.isEmpty()) {
                return;
            }
            boundingXYVisitor.computeBoundingBox(collection);
            if (boundingXYVisitor.getBounds() == null) {
                return;
            }
            boundingXYVisitor.enlargeBoundingBox();
            Main.map.mapView.recalculateCenterScale(boundingXYVisitor);
        }

        public void updateEnabledState() {
            this.setEnabled(!SelectionListDialog.this.model.getSelected().isEmpty());
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class ZoomToJOSMSelectionAction
    extends AbstractAction
    implements ListDataListener {
        public ZoomToJOSMSelectionAction() {
            this.putValue("Name", I18n.tr("Zoom to selection", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Zoom to selection", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/autoscale", "selection"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AutoScaleAction.autoScale("selection");
        }

        public void updateEnabledState() {
            this.setEnabled(SelectionListDialog.this.model.getSize() > 0);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.updateEnabledState();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.updateEnabledState();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.updateEnabledState();
        }
    }

    class SelectAction
    extends AbstractAction
    implements ListSelectionListener {
        public SelectAction() {
            this.putValue("Name", I18n.tr("Select", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Set the selected elements on the map to the selected items in the list above.", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Collection<OsmPrimitive> collection = SelectionListDialog.this.model.getSelected();
            if (collection.isEmpty()) {
                return;
            }
            if (Main.map == null || Main.map.mapView == null || Main.map.mapView.getEditLayer() == null) {
                return;
            }
            Main.map.mapView.getEditLayer().data.setSelected(collection);
        }

        public void updateEnabledState() {
            this.setEnabled(!SelectionListDialog.this.model.getSelected().isEmpty());
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    static class SearchAction
    extends AbstractAction
    implements MapView.EditLayerChangeListener {
        public SearchAction() {
            this.putValue("Name", I18n.tr("Search", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Search for objects", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            org.openstreetmap.josm.actions.search.SearchAction.search();
        }

        public void updateEnabledState() {
            this.setEnabled(Main.main != null && Main.main.getEditLayer() != null);
        }

        public void editLayerChanged(OsmDataLayer osmDataLayer, OsmDataLayer osmDataLayer2) {
            this.updateEnabledState();
        }
    }

    class TitleUpdater
    implements ListDataListener {
        TitleUpdater() {
        }

        protected void updateTitle() {
            SelectionListDialog.this.setTitle(SelectionListDialog.this.model.getJOSMSelectionSummary());
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.updateTitle();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.updateTitle();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.updateTitle();
        }
    }

    class MouseEventHandler
    extends PopupMenuLauncher {
        public MouseEventHandler() {
            super(SelectionListDialog.this.popupMenu);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (MouseEventHandler.isDoubleClick(mouseEvent)) {
                int n = SelectionListDialog.this.lstPrimitives.locationToIndex(mouseEvent.getPoint());
                if (n < 0) {
                    return;
                }
                OsmDataLayer osmDataLayer = Main.main.getEditLayer();
                if (osmDataLayer == null) {
                    return;
                }
                osmDataLayer.data.setSelected(Collections.singleton((OsmPrimitive)SelectionListDialog.this.model.getElementAt(n)));
            }
        }
    }
}

