/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.util;

import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.util.NameVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleNameVisitor
extends NameVisitor {
    public static final int MULTIPLE_NAME_MAX_LENGTH = 80;
    private String multipleClassname;
    private String displayName;
    private int size;

    public void visit(Collection<? extends OsmPrimitive> collection) {
        String string = "";
        String string2 = null;
        this.size = collection.size();
        this.multipleClassname = null;
        for (OsmPrimitive osmPrimitive : collection) {
            String string3 = osmPrimitive.get("name");
            if (string3 == null) {
                string3 = osmPrimitive.get("ref");
            }
            if (string3 != null && !string3.isEmpty() && string.length() <= 80) {
                if (!string.isEmpty()) {
                    string = string + ", ";
                }
                string = string + string3;
            }
            osmPrimitive.visit(this);
            if (this.multipleClassname == null) {
                this.multipleClassname = this.className;
                string2 = this.classNamePlural;
                continue;
            }
            if (this.multipleClassname.equals(this.className)) continue;
            this.multipleClassname = "object";
            string2 = I18n.trn("object", "objects", 2L, new Object[0]);
        }
        if (this.size <= 1) {
            this.displayName = this.name;
        } else {
            this.displayName = this.size + " " + I18n.trn(this.multipleClassname, string2, this.size, new Object[0]);
            if (!string.isEmpty()) {
                this.displayName = string.length() <= 80 ? this.displayName + ": " + string : this.displayName + ": " + string.substring(0, 80) + "...";
            }
        }
    }

    @Override
    public JLabel toLabel() {
        return new JLabel(this.getText(), this.getIcon(), 0);
    }

    public String getText() {
        return this.displayName;
    }

    public Icon getIcon() {
        if (this.size <= 1) {
            return this.icon;
        }
        return ImageProvider.get("data", this.multipleClassname);
    }

    public String toString() {
        return this.getText();
    }
}

