/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeRelationMemberRoleCommand
extends Command {
    private final Relation relation;
    private int position = -1;
    private final String newRole;
    private String oldRole;
    private Boolean oldModified;

    public ChangeRelationMemberRoleCommand(Relation relation, int n, String string) {
        this.relation = relation;
        this.position = n;
        this.newRole = string;
    }

    @Override
    public boolean executeCommand() {
        if (this.position < 0 || this.position >= this.relation.getMembersCount()) {
            return false;
        }
        this.oldRole = this.relation.getMember(this.position).getRole();
        if (this.newRole.equals(this.oldRole)) {
            return true;
        }
        this.relation.setMember(this.position, new RelationMember(this.newRole, this.relation.getMember(this.position).getMember()));
        this.oldModified = this.relation.isModified();
        this.relation.setModified(true);
        return true;
    }

    @Override
    public void undoCommand() {
        this.relation.setMember(this.position, new RelationMember(this.oldRole, this.relation.getMember(this.position).getMember()));
        this.relation.setModified(this.oldModified);
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.relation);
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Change relation member role for {0} {1}", new Object[]{OsmPrimitiveType.from(this.relation), this.relation.getDisplayName(DefaultNameFormatter.getInstance())});
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get(this.relation.getDisplayType());
    }
}

