/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplifyWayAction
extends JosmAction {
    public static final double EARTH_RAD = 6378137.0;

    public SimplifyWayAction() {
        super(I18n.tr("Simplify Way", new Object[0]), "simplify", I18n.tr("Delete unnecessary nodes from a way.", new Object[0]), Shortcut.registerShortcut("tools:simplify", I18n.tr("Tool: {0}", I18n.tr("Simplify Way", new Object[0])), 89, 5005), true);
        this.putValue("help", HelpUtil.ht("/Action/SimplifyWay"));
    }

    protected boolean confirmWayWithNodesOutsideBoundingBox(List<? extends OsmPrimitive> list) {
        System.out.println(list);
        return DeleteCommand.checkAndConfirmOutlyingDelete(Main.map.mapView.getEditLayer(), list, null);
    }

    protected void alertSelectAtLeastOneWay() {
        HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("Please select at least one way to simplify.", new Object[0]), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Action/SimplifyWay#SelectAWayToSimplify"));
    }

    protected boolean confirmSimplifyManyWays(int n) {
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Yes", new Object[0]), ImageProvider.get("ok"), I18n.tr("Simplify all selected ways", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Cancel operation", new Object[0]), null)};
        int n2 = HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("The selection contains {0} ways. Are you sure you want to simplify them all?", n), I18n.tr("Simplify ways?", new Object[0]), 2, null, buttonSpecArray, buttonSpecArray[0], HelpUtil.ht("/Action/SimplifyWay#ConfirmSimplifyAll"));
        return n2 == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        DataSet dataSet = SimplifyWayAction.getCurrentDataSet();
        dataSet.beginUpdate();
        try {
            List<Way> list = OsmPrimitive.getFilteredList(dataSet.getSelected(), Way.class);
            if (list.isEmpty()) {
                this.alertSelectAtLeastOneWay();
                return;
            }
            if (!this.confirmWayWithNodesOutsideBoundingBox(list)) {
                return;
            }
            if (list.size() > 10 && !this.confirmSimplifyManyWays(list.size())) {
                return;
            }
            LinkedList<Command> linkedList = new LinkedList<Command>();
            for (Way way : list) {
                SequenceCommand sequenceCommand = this.simplifyWay(way, dataSet);
                if (sequenceCommand == null) continue;
                linkedList.add(sequenceCommand);
            }
            if (linkedList.isEmpty()) {
                return;
            }
            SequenceCommand sequenceCommand = new SequenceCommand(I18n.trn("Simplify {0} way", "Simplify {0} ways", linkedList.size(), linkedList.size()), linkedList);
            Main.main.undoRedo.add(sequenceCommand);
        }
        finally {
            dataSet.endUpdate();
        }
        Main.map.repaint();
    }

    protected boolean isRequiredNode(Way way, Node node) {
        boolean bl;
        boolean bl2 = bl = Collections.frequency(way.getNodes(), node) > 1;
        if (!bl) {
            LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
            linkedList.addAll(node.getReferrers());
            linkedList.remove(way);
            boolean bl3 = bl = !linkedList.isEmpty();
        }
        if (!bl) {
            bl = node.isTagged();
        }
        return bl;
    }

    public SequenceCommand simplifyWay(Way way, DataSet dataSet) {
        double d = Main.pref.getDouble("simplify-way.max-error", 3.0);
        int n = 0;
        int n2 = 0;
        ArrayList<Node> arrayList = new ArrayList<Node>(way.getNodesCount());
        while (n2 < way.getNodesCount()) {
            if (this.isRequiredNode(way, way.getNode(n2))) {
                arrayList.add(way.getNode(n2));
                ++n2;
                ++n;
                continue;
            }
            ++n2;
            while (n2 < way.getNodesCount() && !this.isRequiredNode(way, way.getNode(n2))) {
                ++n2;
            }
            this.buildSimplifiedNodeList(way.getNodes(), n, Math.min(way.getNodesCount() - 1, n2), d, arrayList);
            n = n2++;
        }
        HashSet<Node> hashSet = new HashSet<Node>();
        hashSet.addAll(way.getNodes());
        hashSet.removeAll(arrayList);
        if (hashSet.isEmpty()) {
            return null;
        }
        LinkedList<Command> linkedList = new LinkedList<Command>();
        Way way2 = new Way(way);
        way2.setNodes(arrayList);
        linkedList.add(new ChangeCommand(way, way2));
        linkedList.add(new DeleteCommand(hashSet));
        dataSet.clearSelection(hashSet);
        return new SequenceCommand(I18n.trn("Simplify Way (remove {0} node)", "Simplify Way (remove {0} nodes)", hashSet.size(), hashSet.size()), linkedList);
    }

    protected void buildSimplifiedNodeList(List<Node> list, int n, int n2, double d, List<Node> list2) {
        Node node = list.get(n);
        Node node2 = list.get(n2);
        int n3 = -1;
        double d2 = 0.0;
        for (int i = n + 1; i < n2; ++i) {
            Node node3 = list.get(i);
            double d3 = Math.abs(6378137.0 * SimplifyWayAction.xtd(node.getCoor().lat() * Math.PI / 180.0, node.getCoor().lon() * Math.PI / 180.0, node2.getCoor().lat() * Math.PI / 180.0, node2.getCoor().lon() * Math.PI / 180.0, node3.getCoor().lat() * Math.PI / 180.0, node3.getCoor().lon() * Math.PI / 180.0));
            if (!(d3 > d2)) continue;
            d2 = d3;
            n3 = i;
        }
        if (n3 != -1 && d2 >= d) {
            this.buildSimplifiedNodeList(list, n, n3, d, list2);
            this.buildSimplifiedNodeList(list, n3, n2, d, list2);
        } else {
            if (list2.isEmpty() || list2.get(list2.size() - 1) != node) {
                list2.add(node);
            }
            if (node != node2) {
                list2.add(node2);
            }
        }
    }

    public static double dist(double d, double d2, double d3, double d4) {
        return 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((d - d3) / 2.0), 2.0) + Math.cos(d) * Math.cos(d3) * Math.pow(Math.sin((d2 - d4) / 2.0), 2.0)));
    }

    public static double course(double d, double d2, double d3, double d4) {
        return Math.atan2(Math.sin(d2 - d4) * Math.cos(d3), Math.cos(d) * Math.sin(d3) - Math.sin(d) * Math.cos(d3) * Math.cos(d2 - d4)) % (Math.PI * 2);
    }

    public static double xtd(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = SimplifyWayAction.dist(d, d2, d5, d6);
        double d8 = SimplifyWayAction.course(d, d2, d5, d6);
        double d9 = SimplifyWayAction.course(d, d2, d3, d4);
        return Math.asin(Math.sin(d7) * Math.sin(d8 - d9));
    }

    @Override
    protected void updateEnabledState() {
        if (SimplifyWayAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(SimplifyWayAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }
}

