/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Stroke;
import javax.swing.UIManager;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.Style;

public abstract class MapObjectImpl {
    private Layer layer;
    private String name;
    private Style style;
    private Boolean visible;

    public MapObjectImpl(String string) {
        this(null, string, null);
    }

    public MapObjectImpl(Layer layer) {
        this(layer, null, null);
    }

    public MapObjectImpl(Layer layer, String string, Style style) {
        this.layer = layer;
        this.name = string;
        this.style = style;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public Style getStyle() {
        return this.style;
    }

    public Style getStyleAssigned() {
        return this.style == null ? (this.layer == null ? null : this.layer.getStyle()) : this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Color getColor() {
        Style style = this.getStyleAssigned();
        return style == null ? null : this.getStyleAssigned().getColor();
    }

    public void setColor(Color color) {
        if (this.style == null && color != null) {
            this.style = new Style();
        }
        if (this.style != null) {
            this.style.setColor(color);
        }
    }

    public Color getBackColor() {
        Style style = this.getStyleAssigned();
        return style == null ? null : this.getStyleAssigned().getBackColor();
    }

    public void setBackColor(Color color) {
        if (this.style == null && color != null) {
            this.style = new Style();
        }
        if (this.style != null) {
            this.style.setBackColor(color);
        }
    }

    public Stroke getStroke() {
        Style style = this.getStyleAssigned();
        return style == null ? null : this.getStyleAssigned().getStroke();
    }

    public void setStroke(Stroke stroke) {
        if (this.style == null && stroke != null) {
            this.style = new Style();
        }
        if (this.style != null) {
            this.style.setStroke(stroke);
        }
    }

    public Font getFont() {
        Style style = this.getStyleAssigned();
        return style == null ? null : this.getStyleAssigned().getFont();
    }

    public void setFont(Font font) {
        if (this.style == null && font != null) {
            this.style = new Style();
        }
        if (this.style != null) {
            this.style.setFont(font);
        }
    }

    private boolean isVisibleLayer() {
        return this.layer == null || this.layer.isVisible() == null ? true : this.layer.isVisible();
    }

    public boolean isVisible() {
        return this.visible == null ? this.isVisibleLayer() : this.visible.booleanValue();
    }

    public void setVisible(Boolean bl) {
        this.visible = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public static Font getDefaultFont() {
        Font font = UIManager.getDefaults().getFont("TextField.font");
        return new Font(font.getName(), 1, font.getSize());
    }

    public void paintText(Graphics graphics, Point point) {
        if (this.name != null && graphics != null && point != null) {
            if (this.getFont() == null) {
                Font font = MapObjectImpl.getDefaultFont();
                this.setFont(new Font(font.getName(), 1, font.getSize()));
            }
            graphics.setColor(Color.DARK_GRAY);
            graphics.setFont(this.getFont());
            graphics.drawString(this.name, point.x + 5 + 2, point.y + 5);
        }
    }
}

