/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.RenderableElement;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.ShapeElement;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.net.URI;

public class Use
extends ShapeElement {
    float x = 0.0f;
    float y = 0.0f;
    float width = 1.0f;
    float height = 1.0f;
    SVGElement href = null;
    AffineTransform refXform;

    protected void build() throws SVGException {
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName("x"))) {
            this.x = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("y"))) {
            this.y = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("width"))) {
            this.width = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("height"))) {
            this.height = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("xlink:href"))) {
            URI uRI = styleAttribute.getURIValue(this.getXMLBase());
            this.href = this.diagram.getUniverse().getElement(uRI);
        }
        this.refXform = new AffineTransform();
        this.refXform.translate(this.x, this.y);
    }

    public void render(Graphics2D graphics2D) throws SVGException {
        this.beginLayer(graphics2D);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.transform(this.refXform);
        if (this.href == null || !(this.href instanceof RenderableElement)) {
            return;
        }
        RenderableElement renderableElement = (RenderableElement)this.href;
        renderableElement.pushParentContext(this);
        renderableElement.render(graphics2D);
        renderableElement.popParentContext();
        graphics2D.setTransform(affineTransform);
        this.finishLayer(graphics2D);
    }

    public Shape getShape() {
        if (this.href instanceof ShapeElement) {
            Shape shape = ((ShapeElement)this.href).getShape();
            shape = this.refXform.createTransformedShape(shape);
            shape = this.shapeToParent(shape);
            return shape;
        }
        return null;
    }

    public Rectangle2D getBoundingBox() throws SVGException {
        if (this.href instanceof ShapeElement) {
            ShapeElement shapeElement = (ShapeElement)this.href;
            shapeElement.pushParentContext(this);
            Rectangle2D rectangle2D = shapeElement.getBoundingBox();
            shapeElement.popParentContext();
            rectangle2D = this.refXform.createTransformedShape(rectangle2D).getBounds2D();
            rectangle2D = this.boundsToParent(rectangle2D);
            return rectangle2D;
        }
        return null;
    }

    public boolean updateTime(double d) throws SVGException {
        float f;
        boolean bl = super.updateTime(d);
        StyleAttribute styleAttribute = new StyleAttribute();
        boolean bl2 = false;
        if (this.getPres(styleAttribute.setName("x")) && (f = styleAttribute.getFloatValueWithUnits()) != this.x) {
            this.x = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("y")) && (f = styleAttribute.getFloatValueWithUnits()) != this.y) {
            this.y = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("width")) && (f = styleAttribute.getFloatValueWithUnits()) != this.width) {
            this.width = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("height")) && (f = styleAttribute.getFloatValueWithUnits()) != this.height) {
            this.height = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("xlink:href"))) {
            URI uRI = styleAttribute.getURIValue(this.getXMLBase());
            SVGElement sVGElement = this.diagram.getUniverse().getElement(uRI);
            if (sVGElement != this.href) {
                this.href = sVGElement;
                bl2 = true;
            }
        }
        if (bl2) {
            this.build();
        }
        return bl || bl2;
    }
}

