/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.SessionLayerImporter;
import org.openstreetmap.josm.io.session.SessionReader;
import org.openstreetmap.josm.tools.I18n;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GeoImageSessionImporter
implements SessionLayerImporter {
    public Layer load(Element element, SessionReader.ImportSupport importSupport, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        Object object;
        List<SessionReader.LayerDependency> list;
        String string = element.getAttribute("version");
        if (!"0.1".equals(string)) {
            throw new IllegalDataException(I18n.tr("Version ''{0}'' of meta data for geoimage layer is not supported. Expected: 0.1", string));
        }
        ArrayList<ImageEntry> arrayList = new ArrayList<ImageEntry>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            list = nodeList.item(i);
            if (list.getNodeType() != 1 || !(object = (Element)((Object)list)).getTagName().equals("geoimage")) continue;
            ImageEntry imageEntry = new ImageEntry();
            NodeList nodeList2 = object.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node = nodeList2.item(j);
                if (node.getNodeType() != 1) continue;
                Element element2 = (Element)node;
                try {
                    double d;
                    if (element2.getTagName().equals("file")) {
                        imageEntry.setFile(new File(element2.getTextContent()));
                        continue;
                    }
                    if (element2.getTagName().equals("position")) {
                        double d2 = Double.parseDouble(element2.getAttribute("lat"));
                        d = Double.parseDouble(element2.getAttribute("lon"));
                        imageEntry.setPos(new LatLon(d2, d));
                        continue;
                    }
                    if (element2.getTagName().equals("speed")) {
                        imageEntry.setSpeed(Double.parseDouble(element2.getTextContent()));
                        continue;
                    }
                    if (element2.getTagName().equals("elevation")) {
                        imageEntry.setElevation(Double.parseDouble(element2.getTextContent()));
                        continue;
                    }
                    if (element2.getTagName().equals("gps-time")) {
                        imageEntry.setGpsTime(new Date(Long.parseLong(element2.getTextContent())));
                        continue;
                    }
                    if (element2.getTagName().equals("gps-orientation")) {
                        imageEntry.setExifOrientation(Integer.parseInt(element2.getTextContent()));
                        continue;
                    }
                    if (element2.getTagName().equals("exif-time")) {
                        imageEntry.setExifTime(new Date(Long.parseLong(element2.getTextContent())));
                        continue;
                    }
                    if (element2.getTagName().equals("exif-coordinates")) {
                        double d3 = Double.parseDouble(element2.getAttribute("lat"));
                        d = Double.parseDouble(element2.getAttribute("lon"));
                        imageEntry.setExifCoor(new LatLon(d3, d));
                        continue;
                    }
                    if (!element2.getTagName().equals("exif-image-direction")) continue;
                    imageEntry.setExifImgDir(Double.parseDouble(element2.getTextContent()));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            arrayList.add(imageEntry);
        }
        GpxLayer gpxLayer = null;
        list = importSupport.getLayerDependencies();
        if (list.size() > 0 && (object = ((SessionReader.LayerDependency)list.iterator().next()).getLayer()) instanceof GpxLayer) {
            gpxLayer = (GpxLayer)object;
        }
        return new GeoImageLayer(arrayList, gpxLayer);
    }
}

