/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.remotecontrol.AddTagsDialog;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class LoadAndZoomHandler
extends RequestHandler {
    public static final String command = "load_and_zoom";
    public static final String command2 = "zoom";
    private double minlat;
    private double maxlat;
    private double minlon;
    private double maxlon;
    private final Set<Long> ways = new HashSet<Long>();
    private final Set<Long> nodes = new HashSet<Long>();
    private final Set<Long> relations = new HashSet<Long>();

    public String getPermissionMessage() {
        String string = I18n.tr("Remote Control has been asked to load data from the API.", new Object[0]) + "<br>" + I18n.tr("Bounding box: ", new Object[0]) + new BBox(this.minlon, this.minlat, this.maxlon, this.maxlat).toStringCSV(", ");
        if (this.args.containsKey("select") && this.ways.size() + this.nodes.size() + this.relations.size() > 0) {
            string = string + "<br>" + I18n.tr("Sel.: Rel.:{0} / Ways:{1} / Nodes:{2}", this.relations.size(), this.ways.size(), this.nodes.size());
        }
        return string;
    }

    public String[] getMandatoryParams() {
        return new String[]{"bottom", "top", "left", "right"};
    }

    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException {
        DownloadOsmTask downloadOsmTask = new DownloadOsmTask();
        try {
            boolean bl = this.isLoadInNewLayer();
            if (command.equals(this.myCommand)) {
                if (!PermissionPrefWithDefault.LOAD_DATA.isAllowed()) {
                    System.out.println("RemoteControl: download forbidden by preferences");
                } else {
                    Object object;
                    Area area = null;
                    if (!bl) {
                        object = null;
                        DataSet dataSet = Main.main.getCurrentDataSet();
                        if (dataSet != null) {
                            object = dataSet.getDataSourceArea();
                        }
                        if (object != null && !((Area)object).isEmpty()) {
                            area = new Area(new Rectangle2D.Double(this.minlon, this.minlat, this.maxlon - this.minlon, this.maxlat - this.minlat));
                            area.subtract((Area)object);
                            if (!area.isEmpty()) {
                                Rectangle2D rectangle2D = area.getBounds2D();
                                this.minlat = rectangle2D.getMinY();
                                this.minlon = rectangle2D.getMinX();
                                this.maxlat = rectangle2D.getMaxY();
                                this.maxlon = rectangle2D.getMaxX();
                            }
                        }
                    }
                    if (area != null && area.isEmpty()) {
                        System.out.println("RemoteControl: no download necessary");
                    } else {
                        object = downloadOsmTask.download(bl, new Bounds(this.minlat, this.minlon, this.maxlat, this.maxlon), null);
                        Main.worker.submit(new PostDownloadHandler((DownloadTask)downloadOsmTask, (Future<?>)object));
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("RemoteControl: Error parsing load_and_zoom remote control request:");
            exception.printStackTrace();
            throw new RequestHandler.RequestHandlerErrorException();
        }
        if (this.args.containsKey("addtags")) {
            GuiHelper.executeByMainWorkerInEDT(new Runnable(){

                public void run() {
                    DataSet dataSet = Main.main.getCurrentDataSet();
                    if (dataSet == null) {
                        return;
                    }
                    dataSet.clearSelection();
                }
            });
        }
        final Bounds bounds = new Bounds(new LatLon(this.minlat, this.minlon), new LatLon(this.maxlat, this.maxlon));
        if (this.args.containsKey("select") && PermissionPrefWithDefault.CHANGE_SELECTION.isAllowed()) {
            GuiHelper.executeByMainWorkerInEDT(new Runnable(){

                public void run() {
                    HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
                    DataSet dataSet = Main.main.getCurrentDataSet();
                    if (dataSet == null) {
                        return;
                    }
                    for (Way osmPrimitive : dataSet.getWays()) {
                        if (!LoadAndZoomHandler.this.ways.contains(osmPrimitive.getId())) continue;
                        hashSet.add(osmPrimitive);
                    }
                    LoadAndZoomHandler.this.ways.clear();
                    for (Node node : dataSet.getNodes()) {
                        if (!LoadAndZoomHandler.this.nodes.contains(node.getId())) continue;
                        hashSet.add(node);
                    }
                    LoadAndZoomHandler.this.nodes.clear();
                    for (Relation relation : dataSet.getRelations()) {
                        if (!LoadAndZoomHandler.this.relations.contains(relation.getId())) continue;
                        hashSet.add(relation);
                    }
                    LoadAndZoomHandler.this.relations.clear();
                    dataSet.setSelected(hashSet);
                    if (PermissionPrefWithDefault.CHANGE_VIEWPORT.isAllowed()) {
                        if (!"download".equals(LoadAndZoomHandler.this.args.get("zoom_mode")) && !hashSet.isEmpty()) {
                            AutoScaleAction.autoScale("selection");
                        } else {
                            LoadAndZoomHandler.this.zoom(bounds);
                        }
                    }
                    if (Main.isDisplayingMapView() && Main.map.relationListDialog != null) {
                        Main.map.relationListDialog.selectRelations(null);
                        Main.map.relationListDialog.dataChanged(null);
                        Main.map.relationListDialog.selectRelations(Utils.filteredCollection(hashSet, Relation.class));
                    }
                }
            });
        } else if (PermissionPrefWithDefault.CHANGE_VIEWPORT.isAllowed()) {
            this.zoom(bounds);
        }
        AddTagsDialog.addTags(this.args, this.sender);
    }

    protected void zoom(final Bounds bounds) {
        if (Main.isDisplayingMapView()) {
            GuiHelper.executeByMainWorkerInEDT(new Runnable(){

                public void run() {
                    BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
                    boundingXYVisitor.visit(bounds);
                    Main.map.mapView.recalculateCenterScale(boundingXYVisitor);
                }
            });
        }
    }

    public PermissionPrefWithDefault getPermissionPref() {
        return null;
    }

    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        this.minlat = 0.0;
        this.maxlat = 0.0;
        this.minlon = 0.0;
        this.maxlon = 0.0;
        try {
            this.minlat = LatLon.roundToOsmPrecision(Double.parseDouble((String)this.args.get("bottom")));
            this.maxlat = LatLon.roundToOsmPrecision(Double.parseDouble((String)this.args.get("top")));
            this.minlon = LatLon.roundToOsmPrecision(Double.parseDouble((String)this.args.get("left")));
            this.maxlon = LatLon.roundToOsmPrecision(Double.parseDouble((String)this.args.get("right")));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RequestHandler.RequestHandlerBadRequestException("NumberFormatException (" + numberFormatException.getMessage() + ")");
        }
        if (this.args.containsKey("select")) {
            this.ways.clear();
            this.nodes.clear();
            this.relations.clear();
            for (String string : ((String)this.args.get("select")).split(",")) {
                try {
                    if (string.startsWith("way")) {
                        this.ways.add(Long.parseLong(string.substring(3)));
                        continue;
                    }
                    if (string.startsWith("node")) {
                        this.nodes.add(Long.parseLong(string.substring(4)));
                        continue;
                    }
                    if (string.startsWith("relation")) {
                        this.relations.add(Long.parseLong(string.substring(8)));
                        continue;
                    }
                    if (string.startsWith("rel")) {
                        this.relations.add(Long.parseLong(string.substring(3)));
                        continue;
                    }
                    System.out.println("RemoteControl: invalid selection '" + string + "' ignored");
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("RemoteControl: invalid selection '" + string + "' ignored");
                }
            }
        }
    }
}

