/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;

public class ImportHandler
extends RequestHandler {
    public static final String command = "import";
    private URL url;
    private Collection<DownloadTask> suitableDownloadTasks;

    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException {
        try {
            if (this.suitableDownloadTasks != null && !this.suitableDownloadTasks.isEmpty()) {
                this.suitableDownloadTasks.iterator().next().loadUrl(this.isLoadInNewLayer(), this.url.toExternalForm(), null);
            }
        }
        catch (Exception exception) {
            System.out.println("RemoteControl: Error parsing import remote control request:");
            exception.printStackTrace();
            throw new RequestHandler.RequestHandlerErrorException();
        }
    }

    public String[] getMandatoryParams() {
        return new String[]{"url"};
    }

    public String getPermissionMessage() {
        String string = null;
        if (this.suitableDownloadTasks != null && !this.suitableDownloadTasks.isEmpty()) {
            string = this.suitableDownloadTasks.iterator().next().getConfirmationMessage(this.url);
        }
        return I18n.tr("Remote Control has been asked to import data from the following URL:", new Object[0]) + "<br>" + (string == null ? this.url.toString() : string);
    }

    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.IMPORT_DATA;
    }

    protected void parseArgs() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.request.indexOf(63) != -1) {
            String string = this.request.substring(this.request.indexOf(63) + 1);
            if (string.indexOf("url=") == 0) {
                hashMap.put("url", this.decodeParam(string.substring(4)));
            } else {
                String[] stringArray;
                int n = string.indexOf("&url=");
                if (n != -1) {
                    hashMap.put("url", this.decodeParam(string.substring(n + 5)));
                    string = string.substring(0, n);
                } else if (string.indexOf(35) != -1) {
                    string = string.substring(0, string.indexOf(35));
                }
                for (String string2 : stringArray = string.split("&", -1)) {
                    int n2 = string2.indexOf(61);
                    if (n2 == -1) continue;
                    hashMap.put(string2.substring(0, n2), string2.substring(n2 + 1));
                }
            }
        }
        this.args = hashMap;
    }

    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        String string = (String)this.args.get("url");
        try {
            this.url = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RequestHandler.RequestHandlerBadRequestException("MalformedURLException: " + malformedURLException.getMessage());
        }
        this.suitableDownloadTasks = Main.main.menu.openLocation.findDownloadTasks(string);
        if (this.suitableDownloadTasks.isEmpty()) {
            this.suitableDownloadTasks.add(new DownloadOsmTask());
        }
    }
}

